/*
	pmp.c -- File capture/download

  Poor Man's Packet (PMP)
  Copyright (c) 1991 by Andrew C. Payne    All Rights Reserved.

  Permission to use, copy, modify, and distribute this software and its
  documentation without fee for NON-COMMERCIAL AMATEUR RADIO USE ONLY is hereby
  granted, provided that the above copyright notice appear in all copies.
  The author makes no representations about the suitability of this software
  for any purpose.  It is provided "as is" without express or implied warranty.

	July, 1989
	Andrew C. Payne
*/

/* ----- Includes ----- */
#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <mem.h>
#include <string.h>

#include "pmp.h"

/* ----- Local Variables ----- */

static long	buffree;		/* bytes free in capture buffer */
static char	*capbuffer;		/* start of capture buffer */
static char	*cap;			/* capture pointer */
static FILE	*capfile;		/* capture file */

/* ----- Subroutines ----- */

/* InitCapture()
	Initalize the capture system.
*/
void InitCapture()
{
	capbuffer = cap = malloc(CaptureBuffer);
	if(cap == NULL)
		OutOfMemory();

	buffree = CaptureBuffer;
	capfile = NULL;
	*CaptureFile = '\0';
}

/* FlushCapture()
	Flushes the contents of the capture buffer to the capture file.
*/
void FlushCapture()
{
	if(CaptureBuffer != buffree) {	/* bytes in buffer */
		fwrite(capbuffer, CaptureBuffer - buffree, 1, capfile);
		cap = capbuffer;
		buffree = CaptureBuffer;
	}
}

/* Capture(s,len)
	Given a string and a length, store it in the capture buffer.
*/
void Capture(char *s, int len)
{
	if(capfile == NULL)
		return;

	if(len > buffree)		/* flush if it won't fit */
		FlushCapture();

	CaptureSize += len;
	buffree -= len;			/* add to buffer */
	memcpy(cap, s, len);
	cap += len;
}

/* OpenCapture(fname)
	Given a filename, opens the file as the current capture file.
*/
void OpenCapture(char *fname)
{
	if(capfile != NULL)		/* close existing file */
		CloseCapture();

	strcpy(CaptureFile,fname);	/* save name */
	capfile = fopen(fname,"w");
	if(capfile == NULL) {
		uprintf(InvAttr,"  Can't open '%s' ",fname);
		return;
	}
	cap = capbuffer;
	buffree = CaptureBuffer;
	CaptureSize = 0;
}

/* CloseCapture()
	Closes the current capture file.
*/
void CloseCapture(void)
{
	if(capfile != NULL) {
		FlushCapture();
		fclose(capfile);
	}
	capfile = NULL;
	*CaptureFile = '\0';
}

/* Capturing()
	Returns TRUE if currently capturing to a file.
*/
int Capturing(void)
{
	return capfile != NULL;
}
