Program TestLL;

{ This is a short little program I wrote to test the Linked List.
  The documentation is pretty scarce. At this point you should
  understand enough about how it works.                           }

uses LinkList, CRT;

var
  AList1,
  AList2 : Data_Ptr;  { Our Two Lists. }
  ANum   : DataType;
  Count  : integer;


begin
  clrscr;

  Init_List(AList1);


  { First test is a stack. First we insert at the beginning,
    and then we'll use the Pop_First to get it back.          }

  randomize;
  for Count := 1 to 20 do
    begin
      ANum := Random(40);
      gotoxy(5,Count);
      write(ANum);
      Insert_Begin(AList1, ANum);
    end;


  for Count := 1 to 20 do
    begin
      gotoxy(45, Count);
      Write(Pop_First(AList1));
    end;
  gotoxy(15,23);
  write('--> Hit the ENTER Key to Continue <--');
  readln;
  clrscr;

  Init_List(AList2);

  { The second test is a little different. We are going to insert
    in order and then retreive from the rear, so we should be able
    to see our list in reverse order.                              }

  randomize;
  for Count := 1 to 20 do
    begin
      ANum := Random(40);
      gotoxy(5,Count);
      write(ANum);
      Insert_In_Order(AList2, ANum);
    end;

  for Count := 1 to 20 do
    begin
      gotoxy(45, Count);
      Write(Pop_Last(AList2));
    end;
  gotoxy(15,23);
  write('--> Hit the ENTER Key to Continue <--');
  readln;

end.
