/*
        TRYXCVT.C --- Demonstrates the C formatting 
                      routines ecvt, fcvt, and gcvt

        Ray Duncan, October 1987
*/

#include <stdio.h>
#include <stdlib.h>

main (int argc, char *argv[])
{       
   double value;                /* value to be converted */
   int digits;                  /* number of digits stored */   
   char buff[80];               /* buffer to hold ASCIIZ string */
   int decptr;                  /* receives position of decimal point */
   int signptr;                 /* receives flag specifying sign */
   char *strptr;                /* receives pointer to string */

   while(1)
   {  
                                /* prompt for number of digits */
        printf("\n\nEnter digits (Q to quit):  ");

        gets(buff);             /* read string from keyboard */

                                /* exit if 'Q' or 'q' entered */
        if( buff[0] == 'Q' || buff[0] == 'q') break;     

        digits=atoi(buff);      /* convert digits to format */

                                /* prompt for value to convert */
        printf("\nEnter value: ");

        gets(buff);             /* read string from keyboard */

        value=atof(buff);       /* convert string to 8-byte real value */

                                /* convert value to string with ecvt */                 
        strptr = ecvt(value,digits,&decptr,&signptr);

                                /* display results of conversion */
        printf("\necvt(%f) = %s, decimal position = %d, sign = %d",
                                value,strptr,decptr,signptr);

                                /* convert value to string with fcvt */
        strptr = fcvt(value,digits,&decptr,&signptr);

                                /* display results of conversion */
        printf("\n\nfcvt(%f) = %s, decimal position = %d, sign = %d",
                                value,strptr,decptr,signptr);

                                /* convert value to string with gcvt */
        strptr = gcvt(value,digits,buff);

                                /* display results of conversion */
        printf("\n\ngcvt(%f) = %s",value,strptr);
   }
}
