/*----------------------------------------------------------
   GRAYS.C -- Gray Shades Using Windows 3.0 Palette Manager
              (c) Charles Petzold, 1990
  ----------------------------------------------------------*/

#include <windows.h>
#include "grays.h"

long FAR PASCAL WndProc (HWND, WORD, WORD, LONG) ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     char     szAppName [] = "Grays" ;
     HWND     hwnd ;
     MSG      msg ;
     WNDCLASS wndclass ;

     if (!hPrevInstance) 
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     hwnd = CreateWindow (szAppName, "Gray Shades",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
     {
     static HPALETTE hPal ;
     static short    cxClient, cyClient ;
     static WORD     wDisplay = IDM_DITHERED ;
     HBRUSH          hBrush ;
     HDC             hdc ;
     HMENU           hMenu ;
     LOCALHANDLE     hLocalMem ;
     LOGPALETTE      *plp ;
     long            i ;
     PAINTSTRUCT     ps ;
     RECT            rc ;
     WORD            nGrayLevel ;

     switch (message)
          {
          case WM_CREATE:

                    // Allocate memory for LOGPALETTE structure and lock it

               hLocalMem = LocalAlloc (LMEM_MOVEABLE, sizeof (LOGPALETTE) +
                                                 64 * sizeof (PALETTEENTRY)) ;

               plp = (LOGPALETTE *) LocalLock (hLocalMem) ;

                    // Initialize the fields of the LOGPALETTE structure

               plp->palVersion    = 0x300 ;
               plp->palNumEntries = 65 ;

               for (i = 0 ; i <= 64 ; i++)
                    {
                    nGrayLevel = min (255, 4 * i) ;

                    plp->palPalEntry[i].peRed   = nGrayLevel ;
                    plp->palPalEntry[i].peGreen = nGrayLevel ;
                    plp->palPalEntry[i].peBlue  = nGrayLevel ;
                    plp->palPalEntry[i].peFlags = 0 ;
                    }

                    // Create the logical palette

               hPal = CreatePalette (plp) ;

                    // Unlock and free the allocated memory

               LocalUnlock (hLocalMem) ;
               LocalFree (hLocalMem) ;
               return 0 ;

          case WM_COMMAND:
               hMenu = GetMenu (hwnd) ;
                                             // Process menu commands
               switch (wParam)
                    {
                    case IDM_DITHERED:
                    case IDM_PALETTERGB:
                    case IDM_PALETTEINDEX:
                         CheckMenuItem (hMenu, wDisplay, MF_UNCHECKED) ;
                         wDisplay = wParam ;
                         CheckMenuItem (hMenu, wDisplay, MF_CHECKED) ;

                         InvalidateRect (hwnd, NULL, TRUE) ;
                         return 0 ;
                    }
               break ;

          case WM_SIZE:
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ;
               return 0 ;

          case WM_PAINT:
               hdc = BeginPaint (hwnd, &ps) ;

                         // If the display is not to be dithered, select and
                         //      realize the palette

               if (wDisplay != IDM_DITHERED)
                    {
                    SelectPalette (hdc, hPal, FALSE) ;
                    RealizePalette (hdc) ;
                    }

               for (i = 0 ; i <= 64 ; i++)
                    {
                         // Use a RECT structure for each of 65 rectangles

                    rc.left   = (short) ( i      * cxClient / 65) ;
                    rc.top    = 0 ;
                    rc.right  = (short) ((i + 1) * cxClient / 65) ;
                    rc.bottom = cyClient ;

                         // Determine the level of gray

                    nGrayLevel = min (255, 4 * i) ;

                         // Create a brush depending on the display

                    switch (wDisplay)
                         {
                         case IDM_DITHERED:
                              hBrush = CreateSolidBrush (RGB (
                                        nGrayLevel, nGrayLevel, nGrayLevel)) ;
                              break ;

                         case IDM_PALETTERGB:
                              hBrush = CreateSolidBrush (PALETTERGB (
                                        nGrayLevel, nGrayLevel, nGrayLevel)) ;
                              break ;

                         case IDM_PALETTEINDEX:
                              hBrush = CreateSolidBrush (PALETTEINDEX (i)) ;
                              break ;
                         }

                         // Fill the rectangle and delete the brush

                    FillRect (hdc, &rc, hBrush) ;
                    DeleteObject (hBrush) ;
                    }

               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_QUERYNEWPALETTE:
               hdc = GetDC (hwnd) ;

               SelectPalette (hdc, hPal, FALSE) ;

               if (RealizePalette (hdc) > 0)
                    {
                    ReleaseDC (hwnd, hdc) ;
                    InvalidateRect (hwnd, NULL, FALSE) ;
                    return TRUE ;
                    }
               else
                    {
                    ReleaseDC (hwnd, hdc) ;
                    return FALSE ;
                    }
               break ;

          case WM_PALETTECHANGED:
               if (wParam != hwnd)
                    {
                    hdc = GetDC (hwnd) ;

                    SelectPalette (hdc, hPal, FALSE) ;

                    if (RealizePalette (hdc) > 0)
                         {
                         InvalidateRect (hwnd, NULL, FALSE) ;
                         }

                    ReleaseDC (hwnd, hdc) ;
                    }
               return 0 ;

          case WM_DESTROY :

                    // Delete the logical palette

               DeleteObject (hPal) ;
               PostQuitMessage (0) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
