/* 
WINMEM.C -- How much memory can we allocate under Windows?

cl -c -AS -Gsw -Oais -Zpe winmem.c
link /align:16 winmem,,,/nod:slibcew libw,win.def
rc winmem.exe

; WIN.DEF -- generic Windows .DEF file
EXETYPE     WINDOWS
STUB        'WINSTUB.EXE'
CODE        PRELOAD MOVEABLE DISCARDABLE
DATA        PRELOAD MOVEABLE MULTIPLE
HEAPSIZE    10240
STACKSIZE   5120

or (Borland C++ 2.0; no .DEF file required):
	bcc -W winmem.c
	rc winmem.exe

Copyright (c) 1991 Ziff Communications Co.
    PC Magazine * Andrew Schulman
*/

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include "windows.h"

/* printf to a Windows MessageBox */
int msgprintf(char *fmt, ...)
{
    static char s[1024];
    int len;
    va_list marker;
    va_start(marker, fmt);
    len = wvsprintf((char far *) s, (char far *) fmt, marker);
    va_end(marker);
    MessageBox(NULL, s, "PC Magazine Windows Memory Allocation Test", MB_OK);
    return len;
}

/* return name of current Windows mode - far ptr for use with wvsprintf */
char far *win_mode(void)
{
    unsigned long flags = GetWinFlags();
    return (flags & WF_ENHANCED ? "Enhanced" :
    flags & WF_STANDARD ?         "Standard" :
    /* default */                 "Real") ;
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpszCmdLine, int nCmdShow)
{
    unsigned long blksize = 32L << 10L;     /* 32k per block */
    unsigned long freespace, largest, allocated, save;
    time_t t1, t2;
    char far *fp;

    /* retrieve these BEFORE we start allocating memory */
    freespace = GetFreeSpace(0);
    largest = GlobalCompact(-1);

    /* allocate as much memory as possible */
    time(&t1);
    allocated = 0;
    while (fp = GlobalLock(GlobalAlloc(GMEM_MOVEABLE, blksize)))
    {
        *fp = 'x';
        fp[blksize-1] = 'y';
        allocated += blksize;
        save = fp;
        Yield();    /* Let another program run */
    }
    time(&t2);

    /* display results */
    msgprintf("Running in %s mode\n"
              "%lu bytes available\n"
              "%lu bytes in largest block\n"
              "Allocated %lu bytes in %lu seconds\n"
              "Sample pointer: %04X:%04X", 
              win_mode(),
              freespace, largest, allocated, t2 - t1,
              FP_SEG(save), FP_OFF(save));
    
    /* allocated memory will be freed automatically on exit */
    return 0;
}

