/*
UNDOCSEL.C -- illustrates undocumented Windows selector functions

cl -c -AS -G2sw -Oais -Zpe undocsel.c printf.c
link /align:16 undocsel printf,undocsel,,/nod slibcew libw,win.def
rc undocsel.exe

Copyright (c) 1991 Ziff Communications Co.
    PC Magazine * Andrew Schulman
*/
        
#include <windows.h>
#include <dos.h>
#include "printf.h"

/* undocumented Windows functions */
extern DWORD FAR PASCAL GetSelectorBase(unsigned sel);
extern DWORD FAR PASCAL GetSelectorLimit(unsigned sel);
extern void FAR PASCAL SetSelectorBase(unsigned sel, DWORD base);
extern void FAR PASCAL SetSelectorLimit(unsigned sel, DWORD limit);

#define FAIL(s) return MessageBox(NULL, s, "UNDOCSEL", MB_OK), 0

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpszCmdLine, int nCmdShow)
{
    unsigned sel, _ds;
    unsigned long far *pticks;
    if (! (GetWinFlags() & WF_PMODE))
        FAIL("This program requires Windows Standard or Enhanced mode");
    open_display("Undocumented Selector Function Test");
    _asm mov _ds, ds
    sel = AllocSelector(_ds);       // copy DS
    printf("sel=%04X\n", sel);
    SetSelectorBase(sel, 0x400);    // BIOS data area
    SetSelectorLimit(sel, 0xFFFF);  // only 64k allowed
    FP_SEG(pticks) = sel;
    FP_OFF(pticks) = 0x6c;          // BIOS timer tick
    printf("base=%08lx limit=%08lx ticks=%08lX\n", 
        GetSelectorBase(sel), GetSelectorLimit(sel), *pticks);
    show_display();
    FreeSelector(sel);
}
