PROCEDURE promptyn
*
PARAMETERS mess, choice_1, choice_2, top, left, win_title
*
* mess      = <exp_C>, message to display in the box
* choice_1  = <exp_C>, first of the two choices
* choice_2  = <exp_C>, second of the two choices
* top       = <exp_N>, top row of the window
* left      = <exp_N>, left column of the window
* win_title = <exp_C>, appears on top bar of window

**************************
* Local Memory Variables *
**************************
PRIVATE promptvar, ret_val

* Initialize the menu variable
promptvar =1

* What we return to the calling .prg
ret_val = SPACE(5)

**************************************************
* Fill in some parameters if they weren't passed *
**************************************************
IF PARAMETERS() < 1 .OR. EMPTY(mess)
   mess = "Please Choose:"
ENDIF

IF PARAMETERS() < 3 .OR. (EMPTY(choice_1) .AND. EMPTY(choice_2))
   choice_1 = "Yes"
   choice_2 = "No"
ENDIF

* Pad everything with spaces to make it look nicer
choice_1 = " " + choice_1 + " "
choice_2 = " " + choice_2 + " "

*********************************************
* Calculate prompt window size and location *
*********************************************

* Figure out our prompt window width
winwidth = MIN(LEN(mess) + LEN(choice_1) + LEN(choice_2) + 5, ;
SCOLS())

* Now the location, more parameters if necessary
IF PARAMETERS() < 4
   top = 99                          && Set to 99 if top is not specified
ENDIF

* If top not specified _or_ passed 99
IF top = 99
   top = INT((SROWS()/2)-2)          && calculate center based on screen rows
ENDIF
bottom = top + 4

* If left not specified _or_ passed 99
IF PARAMETERS() < 5
   left = 99                         && Set to 99 if left is not specified
ENDIF

IF left = 99
   left = INT((SCOLS()-winwidth)/2)  && calc center based on screen columns
ENDIF

right = left + winwidth

**********************************
* Define and activate the window *
**********************************
IF PARAMETERS() < 6
   DEFINE WINDOW promptwin FROM top,left TO top+4,right PANEL
ELSE
   DEFINE WINDOW promptwin FROM top,left TO top+4,right PANEL ;
   TITLE " " + win_title + " "
ENDIF
ACTIVATE WINDOW promptwin

*********************************
* Put the choices on the screen *
*********************************
@WROW()-2,1 SAY mess
@ROW(),COL()+1 PROMPT choice_1 MESSAGE " "
@ROW(),COL()+1 PROMPT choice_2 MESSAGE " "
MENU TO promptvar

***************************
* Clean house and go home *
***************************
RELEASE WINDOW promptwin

IF EMPTY(promptvar)            && They pressed <escape>
   ret_val = ""
ELSE
   ret_val = IIF(promptvar=1,ALLTRIM(choice_1),ALLTRIM(choice_2))
ENDIF

RETURN ret_val
* eof
FUNCTION promptyn
PARAMETERS mess, choice_1, choice_2, top, left, win_title
*
* mess      = <exp_C>, message to display in the box
* choice_1  = <exp_C>, first of the two choices
* choice_2  = <exp_C>, second of the two choices
* top       = <exp_N>, top row of the window
* left      = <exp_N>, left column of the window
* win_title = <exp_C>, appears on top bar of window

**************************
* Local Memory Variables *
**************************
PRIVATE promptvar, ret_val

* Initialize the menu variable
promptvar =1

* What we return to the calling .prg
ret_val = SPACE(5)

**************************************************
* Fill in some parameters if they weren't passed *
**************************************************
IF PARAMETERS() < 1 .OR. EMPTY(mess)
   mess = "Please Choose:"
ENDIF

IF PARAMETERS() < 3 .OR. (EMPTY(choice_1) .AND. EMPTY(choice_2))
   choice_1 = "Yes"
   choice_2 = "No"
ENDIF

* Pad everything with spaces to make it look nicer
choice_1 = " " + choice_1 + " "
choice_2 = " " + choice_2 + " "

*********************************************
* Calculate prompt window size and location *
*********************************************
* Figure out our prompt window width
winwidth = MIN(LEN(mess) + LEN(choice_1) + LEN(choice_2) + 5, ;
SCOLS())

* Now the location, more parameters if necessary
IF PARAMETERS() < 4
   top = 99                  && Set to 99 if top is not specified
ENDIF

* If top not specified _or_ passed 99
IF top = 99
   top = INT((SROWS()/2)-2)  && calculate center based on screen rows
ENDIF
bottom = top + 4

* If left not specified _or_ passed 99
IF PARAMETERS() < 5
   left = 99                 && Set to 99 if left is not specified
ENDIF

IF left = 99                 && calc center based on screen columns
   left = INT((SCOLS()-winwidth)/2)
ENDIF

right = left + winwidth

**********************************
* Define and activate the window *
**********************************
IF PARAMETERS() < 6
   DEFINE WINDOW promptwin FROM top,left TO top+4,right PANEL
ELSE
   DEFINE WINDOW promptwin FROM top,left TO top+4,right PANEL ;
   TITLE " " + win_title + " "
ENDIF
ACTIVATE WINDOW promptwin

*********************************
* Put the choices on the screen *
*********************************
@WROW()-2,1 SAY mess
@ROW(),COL()+1 PROMPT choice_1 MESSAGE " "
@ROW(),COL()+1 PROMPT choice_2 MESSAGE " "
MENU TO promptvar

***************************
* Clean house and go home *
***************************
RELEASE WINDOW promptwin
IF EMPTY(promptvar)            && They pressed <escape>
   ret_val = ""
ELSE
   ret_val = IIF(promptvar=1,ALLTRIM(choice_1),ALLTRIM(choice_2))
ENDIF
RETURN ret_val
* eof
