UNIT MenuUnit;
(**) INTERFACE (**)
USES CRT;
CONST MaxMsgLen = 32;
TYPE
  MessageString = String[MaxMsgLen];
  EntryPointer   = ^EntryType;
  EntryType = OBJECT
    Prev, Next           : EntryPointer;
    XCor, YCor, ChoiceNo : Integer;
    Message              : MessageString;
    CONSTRUCTOR Init(iPr, iNx : EntryPointer; iX, iY,
                  iC : Integer; iM : MessageString);
    PROCEDURE Draw(Selected : Boolean);
    FUNCTION GetChoice : Integer;
  END;

  BBMenu = OBJECT
    XCor, YCor, Wid, Choices : Integer;
    FirstEntry, CurEntry     : EntryPointer;
    CONSTRUCTOR Init(iX, iY, iW : Integer);
    DESTRUCTOR Done;
    PROCEDURE AddPrompt(iM : MessageString);
    PROCEDURE Draw;
    FUNCTION GetChoice : Integer;
  END;

(**) IMPLEMENTATION (**)
  CONSTRUCTOR BBMenu.Init(iX, iY, iW : Integer);
  BEGIN
    XCor := iX;
    YCor := iY;
    Wid  := iW;
    IF Wid > MaxMsgLen THEN Wid := MaxMsgLen;
    IF xCor+Wid > 80 THEN Wid := 80 - xCor;
    FirstEntry := NIL;
    Choices := 0;
  END;

  DESTRUCTOR BBMenu.Done;
  BEGIN
    IF FirstEntry <> NIL THEN
      BEGIN
        FirstEntry^.Prev^.Next := NIL;
        REPEAT
          CurEntry := FirstEntry;
          FirstEntry := FirstEntry^.Next;
          Dispose(CurEntry);
        UNTIL FirstEntry = NIL;
      END;
  END;

  PROCEDURE BBMenu.AddPrompt(iM : MessageString);
  VAR EP : EntryPointer;
  BEGIN
    Inc(Choices);
    {pad with spaces}
    FillChar(iM[length(iM)+1], Wid-length(iM), ' ');
    iM[0] := Char(Wid);
    IF FirstEntry = NIL THEN
      BEGIN
        FirstEntry := New(EntryPointer, Init(NIL,
                      NIL, XCor, YCor+Choices-1,
                      Choices, iM));
        FirstEntry^.Next := FirstEntry;
        FirstEntry^.Prev := FirstEntry;
      END
    ELSE
      BEGIN
        EP := New(EntryPointer, Init(FirstEntry^.Prev,
              FirstEntry, XCor, YCor+Choices-1,
              Choices, iM));
        FirstEntry^.Prev^.Next := EP;
        FirstEntry^.Prev := EP;
      END;
  END;

  PROCEDURE BBMenu.Draw;
  VAR ro, co : Byte;
  BEGIN
    GotoXY(xCor-1, yCor-1); Write(#218);
    FOR co := 1 to Wid DO Write(#196); Write(#191);
    FOR ro := yCor TO yCor + Choices -1 DO
      BEGIN
        GotoXY(xCor-1, ro); Write(#179);
        GotoXY(xCor+Wid, ro); Write(#179);
      END;
    GotoXY(xCor-1, yCor+Choices); Write(#192);
    FOR co := 1 to Wid DO Write(#196); Write(#217);
    CurEntry := FirstEntry;
    REPEAT
      CurEntry^.Draw(FALSE);
      CurEntry := CurEntry^.Next;
    UNTIL CurEntry = FirstEntry;
  END;

CONST
  kEnter = $000D;  kEsc   = $001B;
  kHome  = $4700;  kEnd   = $4F00;  
  kLeft  = $4B00;  kRight = $4D00;
  kDown  = $5000;  kUp    = $4800;

  FUNCTION BBMenu.GetChoice : Integer;
  VAR
    SaveX, SaveY : Integer;
    Finished     : Boolean;
    InChar       : Char;
    InWord       : Word;
  BEGIN
    SaveX := WhereX;
    SaveY := WhereY;
    Draw;
    Finished := FALSE;
    REPEAT
      CurEntry^.Draw(TRUE);
      InChar := ReadKey;
      IF (InChar = #0) AND KeyPressed THEN
        BEGIN
          InChar := ReadKey;
          InWord := Word(InChar) SHL 8;
        END
      ELSE InWord := Ord(InChar);
      CurEntry^.Draw(FALSE);
      CASE InWord OF
        kLeft, kUp    : CurEntry := CurEntry^.Prev;
        kRight, kDown : CurEntry := CurEntry^.Next;
        kHome         : CurEntry := FirstEntry;
        kEnd          : CurEntry := FirstEntry^.Prev;
        kEsc : BEGIN
                Finished:= True;
                GetChoice := 0;
              END;
        kEnter : BEGIN
                Finished := True;
                GetChoice := CurEntry^.GetChoice;
              END;
      END;
    UNTIL Finished;
    GotoXY(SaveX, SaveY);
  END;

  CONSTRUCTOR EntryType.Init(iPr, iNx : EntryPointer;
                iX, iY, iC : Integer;
                iM : MessageString);
  BEGIN
    Prev     := iPr;
    Next     := iNx;
    XCor     := iX;
    YCor     := iY;
    ChoiceNo := iC;
    Message  := iM;
  END;

  PROCEDURE EntryType.Draw(Selected : Boolean);
  BEGIN
    IF Selected THEN TextAttr := $70
    ELSE TextAttr := $07;
    GotoXY(XCor, YCor);
    Write(Message);
  END;

  FUNCTION EntryType.GetChoice : Integer;
  BEGIN GetChoice := ChoiceNo; END;

END.
