// POINT.CPP
// Definitions of Member Functions for Point and Pixel Classes
// Copyright (C) 1991 Ziff Davis Communications
// PC Magazine * Ray Duncan

#include <math.h>
#include <iostream.h>
#include "point.h"

// Member function for POINT class to set X coordinate
void POINT::setX(double NewX)
{
    X = NewX;
};

// Member function for POINT class to set Y coordinate
void POINT::setY(double NewY)
{
    Y = NewY;
};

// Member function for POINT class to fetch X coordinate
double POINT::getX(void)
{
    return(X);
};

// Member function for POINT class to fetch Y coordinate
double POINT::getY(void)
{
    return(Y);
};

// Constructor function for POINT class
POINT::POINT (double NewX, double NewY)
{
    X = NewX;
    Y = NewY;
};

// member function for POINT class to translate point by given X,Y
void POINT::translate(double DispX, double DispY)
{
    X = X + DispX;
    Y = Y + DispY;      
}

// member function for POINT class to rotate point by given degrees
void POINT::rotate(double degrees)
{
    double radians = deg2rad(degrees);
    double tempX = (X * cos(radians)) - (Y * sin(radians));
    Y = (X * sin(radians)) + (Y * cos(radians));
    X = tempX;    
}

// private member function for POINT class to convert degrees to radians
double POINT::deg2rad(double degrees)
{
    return ((degrees * 2 * pi)/360);
}

// private member function for POINT class to convert radians to degrees
double POINT::rad2deg(double radians)
{
    return ((radians * 360)/(2 * pi));
}

// Member function for PIXEL class to set color
void PIXEL::setColor(int NewColor)
{
    Color = NewColor;
};

// Member function for PIXEL class to fetch color
int PIXEL::getColor(void)
{
    return(Color);
};

// Member function for PIXEL class to display location and color
void PIXEL::display(void)
{
    cout << "  X = " << getX();
    cout << "  Y = " << getY();
    cout << "  Color = " << getColor();
};

// Constructor function for PIXEL class
PIXEL::PIXEL (double NewX, double NewY, int NewColor) : POINT (NewX, NewY)
{
    Color = NewColor;
};


