PROGRAM readboot;
{*******************************************************************************
*                                                                              *
*     BOOT SECTOR READER, Version 1.1   Copyright (c) 1991 Barry Simon         *
*                        all rights reserved                                   *
*                                                                              *
*            First Published in PC Magazine, September 10, 1991                *
*                                                                              *
*  Requires Turbo Pascal 6.0 to compile (because of use of inline assembler)   *
*                                                                              *
*******************************************************************************}



USES DOS, common;

VAR
  j, k : Byte;
  NumSec : LongInt;

  PROCEDURE GetDriveNum;          {The program uses the first character
                                     to determine a drive letter; if there
                                     is no parater at all, use default drive}
  VAR
    S : STRING;
  BEGIN
    IF ParamCount > 0 THEN S := ParamStr(1) ELSE GetDir(0, S);
    DriveNum := Ord(Upcase(S[1]))-Ord('A')
  END;

BEGIN
  WriteLn('PC Magazine''s Boot Sector Reader');
  WriteLn('  copyright, Barry Simon 1991');
  GetDriveNum;
  WriteLn;
  WriteLn('  Analyzing Drive ', Char(Ord('A')+DriveNum));
  ReadSector(0);
  WITH BootSector DO BEGIN
    SystemID[0] := #8;            {fudge to fix record}
    WriteLn('    The system ID is ', SystemID, '.');
    WriteLn('    The number of bytes per sector is ', BytesPerSector, '.');
    WriteLn('    The number of sectors per cluster is ', SectorsPerCluster, '.');
    WriteLn('    The number of sectors prior to the data area is ', SectorsBeforeData, '.');
    WriteLn('    The number of copies of the FAT is ', NumFAT, '.');
    WriteLn('    The number of file slots in the root directory is ', NumRootDir, '.');
    IF NumSectors = 0 THEN
      WriteLn('    The number of sectors on the disk is ', LongNumSec, '.')
    ELSE WriteLn('    The number of sectors on the disk is ', NumSectors, '.');
    WriteLn('    The DOS media descriptor is ', Hex(MediaDesc), '.');
    WriteLn('    The number of sectors per FAT is ', NumSecPerFAT, '.');
    WriteLn('    The number of sectors per track is ', NumSecPerTrack, '.');
    WriteLn('    The number of heads on the disk is ', NumHeads, '.');
    WriteLn('    The number of hidden sectors is ', NumHidden, '.');
    WriteLn;
  END;                            {with BootSector}
  WriteLn('    The raw data in the first 40 bytes of the boot sector are:');
  Write('      ');
  FOR j := 0 TO 4 DO BEGIN
    FOR k := 0 TO 3 DO BEGIN
      Write(Hex(Sector[4*j+k]), ' ');
    END;
    Write(' ');
  END;
  WriteLn;
  Write('      ');
  FOR j := 0 TO 4 DO BEGIN
    FOR k := 0 TO 3 DO BEGIN
      Write(Hex(Sector[20+4*j+k]), ' ');
    END;
    Write(' ');
  END;
  WriteLn;
END.


