/***************************************************************************

   File:    savelib.c

   Date:    5/31/91

   CFGSAVE 1.0 Copyright (c) 1991 Gene Kavner
   First published in PC Magazine, October 29, 1991

***************************************************************************/


/***************************************************************************
                              Includes
***************************************************************************/
#include <windows.h>
#include <string.h>
#include <stdio.h>

#include "save.h"

/***************************************************************************
                              Globals
***************************************************************************/
FARPROC FAR lpPrevSendMsgProc;
HWND        hwndExitWindows, hwndTop;

/***************************************************************************
                        SetMessageHook()
***************************************************************************/
BOOL FAR PASCAL SetMessageHook(hwnd)
HWND hwnd;
{

   /*-----------------------------------------*\
   | Set the Message Hook to start trapping    |
   | messages.                                 |
   \*-----------------------------------------*/

   lpPrevSendMsgProc = SetWindowsHook(WH_CALLWNDPROC,(FARPROC)SendMessageProc);
   hwndTop = hwnd;         /* get handle to main window of the CfgSave app */
   hwndExitWindows = NULL; /* reset handle to Exit Windows window */
   return(TRUE);
}


/***************************************************************************
                           SendMessageProc()
***************************************************************************/
void FAR PASCAL SendMessageProc(nCode,wParam,lParam)
int            nCode;
WORD           wParam;
LPPARAM        lParam;
{
   if (nCode < 0) {
      DefHookProc(nCode,wParam,(LONG)lParam, (FARPROC FAR*)&lpPrevSendMsgProc);
      return;
   }

   /* if this is WM_QUERYENDSESSION message, divert it to CfgSave top level window */
   if (lParam->wMsg == WM_QUERYENDSESSION) {
      lParam->hwnd=hwndTop;
      DefHookProc(nCode,wParam,(LONG)lParam,(FARPROC FAR*)&lpPrevSendMsgProc);
      return;
   }

   /* check if a WM_CREATE message was received */
   if (lParam->wMsg == WM_CREATE) {

      /* if Exit Windows window hasn't been detected yet, check if this is it */
      if (!hwndExitWindows) {
         hwndExitWindows = FindWindow (NULL, "Exit Windows");
      }

      /* if Exit Windows window does exist, check if Save Changes checkbox
         control is being created (its ID is 111 decimal)
      */
      else if (GetDlgItem(hwndExitWindows,111)==lParam->hwnd) {
         /* if this is Save Changes checkbox, check it and simulate user
            pressing the OK button.
         */
         PostMessage(lParam->hwnd, BM_SETCHECK, 1, NULL);
         PostMessage(hwndExitWindows, WM_COMMAND, IDOK, NULL);
      }
   }

   DefHookProc(nCode,wParam,(LONG)lParam,(FARPROC FAR*)&lpPrevSendMsgProc);
   return;
}

/***************************************************************************
                     CancelMessageHook(VOID)
***************************************************************************/
VOID FAR PASCAL CancelMessageHook(VOID)
{
   UnhookWindowsHook(WH_CALLWNDPROC, (FARPROC)SendMessageProc);
}
