// bigcopy.c RHS 3/29/90

#include<stdio.h>
#include<stdlib.h>
#include<ctype.h>
#include<dos.h>
#include<malloc.h>
#include<string.h>
#include<conio.h>
#include<io.h>

#define MAXBUFSIZE  32767
#define MAXFNAME    80
#define NUMELEMENTS(item)   (sizeof(item)/sizeof(item[0]))

char infname[MAXFNAME];
char drive[2];
char curdrive;
  
long length;

struct _disks
    {
    long inbytes;
    char *name;
    } disks[4] =
        {
        {  362496L, "360k" },
        {  730112L, "720k" },
        { 1213952L, "1.22meg" },
        { 1457664L, "1.44meg" }
        };

char *bigcopy = "BIGCOPY.";
char bigcopyfname[14];
int bigcopyfileno = 0;

long diskfreespace(char drive);


void main(int argc, char **argv)
    {
    FILE *hin, *hout;
    long bytesfree, totread, bytestoread, bytesremain, chunksize = 0L, temp;
    int i,numdisks;
    char *bufptr;
    unsigned bytesread;

    if(argc < 3 || argc > 4)
        {
        printf("Usage: BIGCOPY <filename> <drive> [chunksize]\n");
        exit(1);
        }
    strcpy(infname,strupr(argv[1]));

#if defined(__BORLANDC__)
    curdrive = getdisk();
    curdrive++;
#else
    _dos_getdrive((unsigned *)&curdrive);
#endif

    drive[0] = *(argv[2]);
    drive[0] = (char)toupper(drive[0]);
    drive[1] = (char)(drive[0]-'A'+1);

    if(argc == 4)
        chunksize = atol(argv[3]);

    if(!(hin = fopen(infname,"rb")))
        {
        printf("Unable to open %s\n",infname);
        exit(2);
        }

    if(!(bufptr = malloc(MAXBUFSIZE)))
        {
        printf("Unable allocate copy buffer\n");
        exit(3);
        }

    length = filelength(fileno(hin));
    bytesfree = diskfreespace(drive[1]);

    if(bytesfree < length)
        {
        printf("%s is %ld bytes long...",infname,length);
        printf("Copying it will require:\n");
        printf(
            "Disks   Disk Size\n"
            "=========================\n");

        for(i = 0; i < NUMELEMENTS(disks); i++)
            {
            if(disks[i].inbytes > length)
                numdisks = 1;
            else
                {
                unsigned remain;

                numdisks = (int)(length / disks[i].inbytes);
                if(numdisks == 0)
                    numdisks++;
                if((remain = (unsigned)(length % disks[i].inbytes)) > 0)
                    numdisks++;
                }
            printf("%7s %5d disk%s\n",disks[i].name,numdisks,
                (numdisks > 1 ? "s" : ""));
            }
        }

    for(bytesremain = length; bytesremain != 0L; )
        {
        if(drive[1] != curdrive)
            {
            printf("Insert disk %d in drive %c\n",bigcopyfileno,drive[0]);
            printf("Press any key to begin copying, or ^C to exit...\n");
            if(getch() == 3)
                exit(0);
            }

        bytesfree = diskfreespace(drive[1]);

            // bytes to read should be lesser of free space or unread bytes
        bytestoread = (bytesfree < bytesremain ? bytesfree : bytesremain);
            // bytes to read should be chunksize if chunksize is smaller
        if(chunksize > 0L && chunksize < bytestoread)
            bytestoread = chunksize;

        sprintf(bigcopyfname,"%c:%s%03d",drive[0],bigcopy,bigcopyfileno++);
        printf("\tCopying %ld bytes from %s to %s",bytestoread,
            infname,bigcopyfname);

        if(!(hout = fopen(bigcopyfname,"wb")))
            {
            printf("\nUnable to open output file: %s\n",bigcopyfname);
            exit(5);
            }

        for(totread = 0L; totread < bytestoread; totread += bytesread )
            {
            temp = MAXBUFSIZE;
            bytesread = (bytestoread-totread > temp
                ? MAXBUFSIZE : (unsigned)(bytestoread-totread));
            
            if((bytesread = fread(bufptr,sizeof(char),bytesread,hin)) == 0)
                break;

            if((fwrite(bufptr,sizeof(char),bytesread,hout)) != bytesread)
                {
                printf("\nError writing %s",bigcopyfname);
                exit(6);
                }
            printf(".");
            }
        printf("\n");
        bytesremain -= totread;
        fclose(hout);
        }
    fclose(hin);
    free(bufptr);
    exit(0);
    }


long diskfreespace(char drive)
    {
    long bfree;
#if defined(__BORLANDC__)
    struct dfree diskfree;

    getdfree(drive, &diskfree);
    if(diskfree.df_sclus == 0xffff)
        {
        printf("Invalid drive: %c\n",drive-1+'A');
        exit(4);
        }

    bfree = (long)diskfree.df_avail;
    bfree *= diskfree.df_sclus;
    bfree *= diskfree.df_bsec;
#else
    struct diskfree_t diskfree;

    if(_dos_getdiskfree(drive,&diskfree))
        {
        printf("Invalid drive: %c\n",drive);
        exit(4);
        }

    bfree = (long)diskfree.avail_clusters;
    bfree *= diskfree.sectors_per_cluster;
    bfree *= diskfree.bytes_per_sector;
#endif
    return bfree;
    }
