NEWCMD.ASM
 
;****************************************************************************
; NEWCMD illustrates how interrupt 2Fh, functions AE00h and AE01h can be
; used to add new internal commands to DOS.  NEWCMD installs a replacement
; for the CLS command that clears the screen to white on blue when CLS is
; typed on the command line.  Requires DOS 3.3 or higher.
;****************************************************************************
 
color           equ     1Fh                     ;Colors to clear the screen
                                                ;  to (default=white on blue)
code            segment
                assume  cs:code
                org     100h
begin:          jmp     init
 
command         db      3,"CLS"                 ;Command text
int2Fh          dd      ?                       ;Interrupt 2Fh vector
 
;****************************************************************************
; MPLEX_INT handles calls to interrupt 2Fh.
;****************************************************************************
 
mplex_int       proc    far
                pushf                           ;Save FLAGS
                sti                             ;Interrupts on
                cmp     ax,0AE00h               ;Branch if this is
                je      check_cmd               ;  function AE00h
                cmp     ax,0AE01h               ;Also branch if it's
                je      exec_cmd                ;  function AE01h
mplex_exit:     popf                            ;Restore FLAGS and chain
                jmp cs:[int2Fh]                 ;  the interrupt
 
check_cmd:      call    compare                 ;Inspect the command string
                jne     mplex_exit              ;Exit if it's not CLS
                mov     al,0FFh                 ;Set AL to FFh and exit
                popf                            ;  if it is
                iret
 
exec_cmd:       call    compare                 ;Inspect the command string
                jne     mplex_exit              ;Exit if it's not CLS
                mov     byte ptr [si],00h       ;Nullify the string
                call    cls                     ;Clear the command from the
                popf                            ;  buffer and exit
                iret
mplex_int       endp
 
;****************************************************************************
; COMPARE returns with the Z flag set if the command pointed to by DS:SI
; is "CLS," or with Z clear if it's not.
;****************************************************************************
 
compare         proc    near
                push    cx                      ;Save registers
                push    si
                push    di
                push    es
                push    cs                      ;Point ES:DI to command
                pop     es                      ;  text in this segment
                mov     di,offset command
                cld                             ;Clear direction flag
                mov     cx,4                    ;Compare up to four bytes
                repe    cmpsb                   ;Compare while equal
                pop     es                      ;Restore registers and exit
                pop     di
                pop     si
                pop     cx
                ret
compare         endp
 
;****************************************************************************
; CLS clears the screen.
;****************************************************************************
 
cls             proc    near
                push    ax                      ;Save registers
                push    bx
                push    cx
                push    dx
                push    ds
 
                mov     ah,12h                  ;See if an EGA or VGA is
                mov     bl,10h                  ;  installed
                int     10h
                mov     ax,40h                  ;Point DS to the BIOS data
                mov     ds,ax                   ;  area
                mov     ax,0600h                ;Prepare for call to
                mov     bh,color                ;  function 06h in the
                xor     cx,cx                   ;  video BIOS
                mov     dh,24
                cmp     bl,10h                  ;Branch if this is a CGA
                je      getcols                 ;  or MDA
                mov     dh,ds:[84h]             ;Get line count from BIOS
getcols:        mov     dl,ds:[4Ah]             ;Get column count, too
                dec     dl                      ;Decrement it
                int     10h                     ;Clear the screen
                mov     ah,02h                  ;Home the cursor by calling
                mov     bh,ds:[62h]             ;  function 02h in the video
                xor     dx,dx                   ;  BIOS
                int     10h
 
                pop     ds                      ;Restore registers and exit
                pop     dx              
                pop     cx
                pop     bx
                pop     ax
                ret
cls             endp
 
;****************************************************************************
; INIT makes the program resident in memory.
;****************************************************************************
 
errmsg          db      "Requires DOS 3.3 or higher",13,10,"$"
 
init            proc    near
                assume  cs:code,ds:code
 
                mov     ah,30h                  ;Get DOS version number
                int     21h                     ;  with function 30h
                xchg    ah,al                   ;Swap AH and AL
                cmp     ax,031Eh                ;Branch if this is version
                jae     install                 ;  3.30 or higher
 
                mov     ah,9                    ;Display error message
                mov     dx,offset errmsg
                int     21h
                mov     ax,4C01h                ;Exit with ERRORLEVEL=1
                int     21h
 
install:        mov     ax,352Fh                ;Get current interrupt 2Fh
                int     21h                     ;  vector and save it
                mov     word ptr int2Fh,bx
                mov     word ptr int2Fh[2],es
                mov     ax,252Fh                ;Point interrupt 2Fh to
                mov     dx,offset mplex_int     ;  MPLEX_INT routine
                int     21h
 
                mov     ax,3100h
                mov     dx,(offset errmsg - offset code + 15) shr 4
                int     21h
init            endp
 
code            ends
                end     begin
