// keyboard.h RHS 8/1/91

#if !defined(KEYBOARD_H)
#define KEYBOARD_H

#include"stddefs.h"

#define BETTER
#if !defined(BETTER)
inline WORD SCANCODE(WORD u)
    {
    return (u | 0x0100);
    }

const WORD  KEY_HOME        = SCANCODE(71);
const WORD  KEY_END         = SCANCODE(79);
const WORD  KEY_PGUP        = SCANCODE(73);
const WORD  KEY_PGDN        = SCANCODE(81);
const WORD  KEY_UP          = SCANCODE(72);
const WORD  KEY_DOWN        = SCANCODE(80);
const WORD  KEY_LEFT        = SCANCODE(75);
const WORD  KEY_RIGHT       = SCANCODE(77);
const WORD  KEY_SHIFTTAB    = SCANCODE(15);
const WORD  KEY_DEL         = SCANCODE(83);
const WORD  KEY_INSERT      = SCANCODE(82);
const WORD  KEY_BACKSPACE   = 8;
const WORD  KEY_TAB         = 9;
const WORD  KEY_ENTER       = 13;
const WORD  KEY_SPACE       = 0x20;
const WORD  KEY_ESC         = 27;
const WORD  KEY_F1          = SCANCODE(59);
const WORD  KEY_F7          = SCANCODE(65);
const WORD  KEY_F9          = SCANCODE(67);
const WORD  KEY_F10         = SCANCODE(68);
const WORD  KEY_CTRLENTER   = 10;

#else
#define  SCANCODE(u)    (u | 0x0100)
#define  KEY_HOME        SCANCODE(71)
#define  KEY_END         SCANCODE(79)
#define  KEY_PGUP        SCANCODE(73)
#define  KEY_PGDN        SCANCODE(81)
#define  KEY_UP          SCANCODE(72)
#define  KEY_DOWN        SCANCODE(80)
#define  KEY_LEFT        SCANCODE(75)
#define  KEY_RIGHT       SCANCODE(77)
#define  KEY_SHIFTTAB    SCANCODE(15)
#define  KEY_DEL         SCANCODE(83)
#define  KEY_INSERT      SCANCODE(82)
#define  KEY_BACKSPACE   8
#define  KEY_TAB         9
#define  KEY_ENTER       13
#define  KEY_SPACE       0x20
#define  KEY_ESC         27
#define  KEY_F1          SCANCODE(59)
#define  KEY_F7          SCANCODE(65)
#define  KEY_F9          SCANCODE(67)
#define  KEY_F10         SCANCODE(68)
#define  KEY_CTRLENTER   10
#endif

class KeyBoard
    {
        int key, lastkey;
    public:
        KeyBoard(void)
            {
            key = lastkey = 0;
            }
        int Get(void);
        int LastKey(void)
            {
            return lastkey;
            }
    };

#endif

