;**********************************************************************
; PROC BinarySearch(SearchVal)                             Paradox 3.5
; Binary search to locate closest match.  SearchVal is the
; string to search for.   Only works on sorted columns (primary key
; or physically sorted.)
;**********************************************************************
PROC BinarySearch(SearchVal)
PRIVATE
  Found,                            ; Controls while loop
  LowRec,                           ; Lower limit of current search area
  HighRec,                          ; Upper limit of current search area
  ThisRec                           ; Current record to compare to searchval

MESSAGE "Searching"                 ; Display message
SearchVal = UPPER(SearchVal)        ; Convert to upper case
LowRec = 1                          ; Initialize
HighRec = NimageRecords()           ; Get number of records
Found = FALSE                       ; Initialize

WHILE Found = FALSE
                                    ; Find midpoint of current search area
  ThisRec = INT((LowRec + HighRec) / 2)
  MOVETO RECORD ThisRec             ; Move to midpoint record
  IF SearchVal = UPPER([]) THEN     ; If SearchVal matches current field
    Found = True                    ; Record found
  ELSE
    IF SearchVal > UPPER([]) THEN   ; Next search area will be upper half of
      LowRec = ThisRec + 1          ;   current area
    ELSE                            ; Next search area will be lower half of
      HighRec = ThisRec - 1         ;   current area
    ENDIF
    IF LowRec > HighRec THEN        ; We're finished
      Found = "Match not found"     ; So exit the while loop
    ENDIF
  ENDIF
ENDWHILE
IF (SearchVal > UPPER([])) THEN
  MOVETO RECORD ThisRec + 1
ENDIF
ENDPROC

;**********************************************************************
; PROC DoBinary()                                          Paradox 3.5
; Acts similar to the ZOOM command, but calls PROC BinarySearch().
;**********************************************************************
PROC DoBinary()
IF IMAGETYPE() = "Display" THEN         ; Only for Display images
   STYLE ATTRIBUTE 63                   ; Look like Paradox
   @ 0,0 ?? "Value:  "
   @ 1,0 ?? "Enter a value to search for." + SPACES(52)
   @ 0,8 ACCEPT "A72" TO SearchVal      ; Get value to match
   BinarySearch(SearchVal)              ; Look for it
   STYLE
ELSE BEEP
ENDIF
ENDPROC
