// file.h

#if !defined(FILE_H)
#define FILE_H

#include<stdio.h>
#include<string.h>
#include<dir.h>
#include<iostream.h>
#include<io.h>

#if defined(_Windows)
#include<windows.h>
#endif

#include"findfile.h"
#include"stddefs.h"

class File
    {
#if defined(_Windows)
    int fh;
#else
    FILE *fp;
#endif
    char *name;
    int linelen;
    char *linebuffer;
#if defined(_Windows)
    int mode;
#else
    char mode[5];
#endif
    int MAXBUF;

    void Init(void);
    void InitLineBuffer(void);
    void SetLineBuffer(void);

public:
    File(char *newname);
    File(void)                      {   Init();             }
    ~File(void);
    void SetName(char *newname);
    void Close(void);
    void SetLineLen(int len)        {   linelen = len;      }
    int Delete(void);
    void Reset(void)                
        {   
#if defined(_Windows)
        lseek(fh,0L,SEEK_SET);
#else
        rewind(fp);         
#endif
        }
#if defined(_Windows)
    int Open(WORD m);
    
    WORD WriteAt(DWORD offset, WORD size, void far *buf);
    DWORD WriteAt(DWORD offset, DWORD size, void far *buf);
    WORD Write(WORD size, void far *buf);
    DWORD Write(DWORD size, void far *buf);
    
    WORD ReadAt(DWORD offset, WORD size, void far *buf);
    DWORD ReadAt(DWORD offset, DWORD size, void far *buf);
    WORD Read(WORD size,void far *buf);
    DWORD Read(DWORD size,void far *buf);

    int Create(int attrib);
#ifdef OLD
    void Append(File& fromfile, DWORD startoffset = 0L, DWORD endoffset = 0xffffffffL);
#else
    void Append(File& fromfile, DWORD startoffset = 0L, DWORD endoffset = 0xffffffffL, 
        LPSTR buffer = NULL);
#endif
    void CopyBytes(DWORD dest, DWORD source, DWORD size);

#else
    int ReadAt(long offset, int size, void *buf);
    int Open(char *m);
    int Read(int size, void *buf);
    int _fRead(int size, void far *buf, char *nearbuf);
    int WriteAt(long offset, int size, void *buf);
    int Write(int size, void *buf);
    int _fWrite(int size, void far *buf, char *nearbuf);
    int Move(char *movedir);
    char *GetLine(void);
    int Copy(char *newfile);
#endif
    long CurPosition(void)          
        {   
#if defined(_Windows)
        return lseek(fh,0L,SEEK_CUR);
#else
        return ftell(fp);   
#endif
        }
    int Offset(long offset);
    long Size(void);
    char *GetName(void)             {   return name;        }
    int Flush(void)                 
        {   
#if defined(_Windows)
        return 0;
#else
        return fflush(fp);  
#endif
        }
    BOOL IsOpen(void)               
        {   
#if defined(_Windows)
        return (fh ? TRUE : FALSE);
#else
        return (fp ? TRUE : FALSE); 
#endif
        }
    BOOL Rename(char *newname)
        {
        if(rename(name,newname))
            return FALSE;
        SetName(newname);
        return TRUE;
        }
    DWORD Eof(void)
        {
#if defined(_Windows)
        return lseek(fh,0L,SEEK_END);
#else
        return fseek(fp,0L,SEEK_END);
#endif
        }
    };
#endif



            



