// stdwin.h

#if !defined(STDWIN_H)
#define STDWIN_H

#include"winapp.h"

/* STDWIN
A class derived from Window. This class creates a standard, overlapped Window
with optional Scroll bars.
*/
class WinAppStdWindow : public Window
    {
protected:
    HMENU hMenu;        // main menu for this window
    HMENU hPopUp;       // first popup for this menu
    HANDLE hAccel;
public:
    WinAppStdWindow(char *name) :
        Window(name)
        {
            // StdWindow class settings
        AddClassStyle(CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS);

            // Window settings: OVERLAPPEDWINDOW includes
            // OVERLAPPED, CAPTION, SYSMENU, THICKFRAME,MINIMIZE_BOX,
            // and MAXIMIZE_BOX
        AddWinStyle(WS_BORDER | WS_OVERLAPPEDWINDOW | WS_VISIBLE);

        SetWinX(CW_USEDEFAULT);
        SetWinY(CW_USEDEFAULT);
        SetWinWidth(CW_USEDEFAULT);
        SetWinHeight(CW_USEDEFAULT);
        }

    static BOOL FAR PASCAL AboutDlg(HWND hDlg, unsigned message, 
        WORD wParam, LONG lParam);

    void EnableScrolls(void)
        {
        AddWinStyle(WS_HSCROLL | WS_VSCROLL);
        }
    HMENU Menu(void)     {   return hMenu;   }
    HMENU PopUp(void)    {   return hPopUp;  }
    virtual ~WinAppStdWindow(){}
    };

#endif


