// windlg.cpp RHS 1/15/91

#include"windlg.h"

inline void *GetWinDlgPtr(HWND hWnd)
    {
#if defined(__SMALL__) || defined(__MEDIUM__)
    return (void *)GetWindowWord(hWnd,DLGWINDOWEXTRA);
#elif defined(__LARGE__) || defined(__COMPACT__) || defined(__HUGE__)
    return (void *)GetWindowLong(hWnd,DLGWINDOWEXTRA);
#else
    #error Must use Small, Medium, Large, Compact or Huge models!
#endif
    }

inline void SetWinDlgPtr(HWND hWnd, void *ptr)
    {
#if defined(__SMALL__) || defined(__MEDIUM__)
    SetWindowWord(hWnd,DLGWINDOWEXTRA,(WORD)ptr);
#elif defined(__LARGE__) || defined(__COMPACT__) || defined(__HUGE__)
    SetWindowLong(hWnd,DLGWINDOWEXTRA,(LONG)ptr);
#else
    #error Must use Small, Medium, Large, Compact or Huge models!
#endif
    }
  

Window *winDlg;

long far pascal WinDlgWndProc(HWND hWnd, WORD msg, WORD wParam, LONG lParam)
    {
    Window *w = (Window *)GetWinDlgPtr(hWnd);

    if(msg == WM_NCCREATE)
        {
        w = winDlg;
        SetWinDlgPtr(hWnd, w);
        w->SethWnd(hWnd);
        }

    if(!w)
        return DefWindowProc(hWnd, msg, wParam, lParam);
    WinAppMsg m;
    m.msg = msg;
    m.wParam = wParam;
    m.lParam = lParam;
    m.msgRetVal = 0L;
    StdWndProc(w,m);
    return m.msgRetVal;
    }
