/* CLIPSRV1.C -- first version of clipboard server */

#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include "windows.h"
#include "objwnd.h"

#define WM_CLIPCMD      (WM_USER+1)

extern BOOL FAR PASCAL IsWinOldApTask(HANDLE);  /* undocumented */

HWND this_hwnd, hwndNextViewer;

void do_run(HWND hwnd, char far *cmd)
{
    WinExec(cmd, SW_NORMAL);
}

void do_settitle(HWND hwnd, char far *cmd)
{
	SendMessage(hwnd, WM_SETTEXT, 0, cmd);
}

#pragma argsused
long clipcmd(HWND hwnd, unsigned msg, WORD wparam, LONG lparam)
{
	HWND owner = wparam;	// HWND of clipboard owner
	char far *s = (char far *) lparam;
	char far *cmd = _fstrtok(s, " \t");
	char far *param = s + _fstrlen(cmd) + 1;
	if (_fstrcmp(cmd, "RUN") == 0)
		do_run(owner, param);
	else if (_fstrcmp(cmd, "SETTITLE") == 0)
		do_settitle(owner, param);
	else if (_fstrcmp(cmd, "EXIT") == 0)
		SendMessage(hwnd, WM_DESTROY, 0, 0L);
    _ffree((char far *) lparam);
    return 0;
}

long check_clipboard(HWND hwnd, unsigned msg, WORD wparam, LONG lparam)
{
    char far *fp = 0;
    HWND owner;
	
    if (hwndNextViewer)
        SendMessage(hwndNextViewer, msg, wparam, lparam);
    
    /* only process CMDCLIP requests from OLDAPs */
    owner = GetClipboardOwner();
    if (IsWinOldApTask(GetWindowTask(owner)))
    {
        HANDLE hGMem;
        if (! OpenClipboard(hwnd))
            return 0;
        if (hGMem = GetClipboardData(CF_TEXT))
        {
            LPSTR lp = GlobalLock(hGMem);
            if (_fstrncmp(lp, "CMDCLIP ", 8) == 0)
            {
                int len = _fstrlen(lp);
                if ((lp[len-1] == '\n') || (lp[len-1] == '\r'))
                    lp[len-1] = '\0';   // remove CRLF
                if ((fp = _fmalloc(len+1)) != 0)
                {
                    char far *fp1 = fp;
                    char far *fp2 = &lp[8];     // remove "CMDCLIP "
                    while (*fp1++ = *fp2++)
                        ;
                }
                else
                    ;   /* insufficient memory */
            }
            GlobalUnlock(hGMem);
        }
        CloseClipboard();
    }
    // don't send message until clipboard closed
    if (fp)
        SendMessage(hwnd, WM_CLIPCMD, owner, fp);
    return 0;
}

long changecbchain(HWND hwnd, unsigned msg, WORD wparam, LONG lparam)
{
    /* maintain linked list of clipboard viewers */
    if (wparam == hwndNextViewer)
        hwndNextViewer = LOWORD(lparam);
    else if (hwndNextViewer)
        SendMessage(hwndNextViewer, msg, wparam, lparam);
    return 0;
}

#pragma argsused
long destroy(HWND hwnd, unsigned msg, WORD wparam, LONG lparam)
{
    ChangeClipboardChain(this_hwnd, hwndNextViewer);
    PostQuitMessage(0);
    return 0;
}

#pragma argsused
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
    LPSTR lpCmdLine, int nCmdShow)
{
    if (hPrevInstance)
    {
        MessageBox(NULL, "CLIPSERV already installed", "CLIPSERV", MB_OK);
        return 1;       // only one instance allowed
    }
    
    objwnd_init();
    this_hwnd = objwnd(hPrevInstance, hInstance, "clipserv");
    hwndNextViewer = SetClipboardViewer(this_hwnd);
    
    on(WM_CHANGECBCHAIN, changecbchain);
    on(WM_DRAWCLIPBOARD, check_clipboard);
    on(WM_DESTROY, destroy);
    on(WM_CLIPCMD, clipcmd);     /* user-defined message */
    
    return mainloop();	/* go resident */
}

