#include<windows.h>
#include<string.h>

#define IDM_ABOUT  0xE010
#define IDM_HELP   0xE020
#define IDM_TOP    0xE030
#define IDM_BOTTOM 0xE040
#define DO_TOP     1
#define DO_BOTTOM  2

HMENU hmSystemMenu=NULL;
LPSTR szAppName="ToTop";
HANDLE hInst;
HWND hWndMain;
int nDoingTopBottomAction=0,nGotLButtonDown,nSuccess;
int nDestroyOkCursor=0,nDestroyNotOkCursor=0,nShowingOkCursor;
HCURSOR hcOldCursor=NULL,hcOkCursor=NULL,hcNotOkCursor=NULL;

int PASCAL WinMain(HANDLE hInstance,HANDLE hPrevInstance,
    LPSTR lpszCmdLine,int nCmdShow);
LONG FAR PASCAL WndProc(HWND, WORD, WORD, LONG);
void DoTopBottomAction(int nTopOrBottom);
void StopDoingTopBottomAction(void);
void TopBottomWindowAtPoint(long lParam);
HWND IsDoable(long lParam);

int PASCAL WinMain(HANDLE hInstance,HANDLE hPrevInstance,
LPSTR lpszCmdLine,int nCmdShow){
    MSG msg;
    hInst=hInstance;
    if(hPrevInstance){                  /* one instance */
        MessageBox(NULL,"Cannot start multiple\n"
        "instances of ToTop",NULL,MB_ICONSTOP);
        return 1;
    }
    if(0x30a>((LOBYTE(LOWORD(GetVersion()))<<8)|    /* win 3.1? */
    (HIBYTE(LOWORD(GetVersion()))))){
        MessageBox(NULL,"ToTop requires\n"
        "Windows 3.1 or better",NULL,MB_ICONSTOP);
        return 1;
    }
    if(!GetSystemMetrics(SM_MOUSEPRESENT)){   /* mouse? */
        MessageBox(NULL,"ToTop requires\na mouse",NULL,MB_ICONSTOP);
        return 1;
    }
    {                                   /* make window class */
        WNDCLASS wndclass;
        memset(&wndclass, 0x00, sizeof(WNDCLASS));
        wndclass.style=CS_DBLCLKS;
        wndclass.lpfnWndProc=WndProc;
        wndclass.cbClsExtra=0;
        wndclass.cbWndExtra=0;
        wndclass.hInstance=hInst;
        wndclass.hIcon=LoadIcon(hInst,"ToTopIcon");
        wndclass.hCursor=LoadCursor(NULL,IDC_ARROW);
        wndclass.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);
        wndclass.lpszMenuName=szAppName;
        wndclass.lpszClassName=szAppName;
        if(!RegisterClass(&wndclass)){
            MessageBox(NULL,"Could not register class",
            NULL,MB_ICONEXCLAMATION);
            return 1;
        }
    }
    hWndMain=CreateWindowEx(WS_EX_TOPMOST,szAppName,szAppName,
    WS_CAPTION|WS_SYSMENU|WS_ICONIC|WS_CLIPCHILDREN|WS_OVERLAPPED,
    CW_USEDEFAULT,0,CW_USEDEFAULT,0,NULL,NULL,hInst,NULL);
    if(hWndMain==NULL){                 /* couldn't create */
        UnregisterClass(szAppName,hInst);
        MessageBox(NULL,"Could not create window",
        NULL,MB_ICONEXCLAMATION);
        return 1;
    }
    hmSystemMenu=GetSystemMenu(hWndMain,FALSE);
    AppendMenu(hmSystemMenu,MF_SEPARATOR,0,(LPSTR)NULL);
    AppendMenu(hmSystemMenu,MF_STRING,IDM_HELP,"&Help...");
    AppendMenu(hmSystemMenu,MF_STRING,IDM_ABOUT,"&About...");
    AppendMenu(hmSystemMenu,MF_SEPARATOR,0,(LPSTR)NULL);
    AppendMenu(hmSystemMenu,MF_STRING,IDM_TOP,"&Top");
    AppendMenu(hmSystemMenu,MF_STRING,IDM_BOTTOM,"&Bottom");
                                        /* done modifying menu */
    ShowWindow(hWndMain, SW_SHOWMINIMIZED);
    while(GetMessage(&msg,NULL,0,0)){
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    UnregisterClass(szAppName,hInst);
    return msg.wParam;
}
LONG FAR PASCAL WndProc(HWND hWnd,WORD Message,
WORD wParam,LONG lParam){
    HWND hwndTemp;
    switch(Message){
    case WM_SYSCOMMAND:
        switch(wParam&0xFFF0){
        case IDM_TOP:
            DoTopBottomAction(DO_TOP);
            break;
        case IDM_BOTTOM:
            DoTopBottomAction(DO_BOTTOM);
            break;
        case IDM_HELP:
            MessageBox(hWnd,
            "ToTop can 'float' or 'sink'\n"
            "any application\n"
            "running under Windows 3.1\n\n"
            "Choose Top or Bottom,\n"
            "then click the left mouse\n"
            "button on any window\n\n"
            "Use right mouse button to cancel",
            "Using ToTop",MB_ICONINFORMATION);
            break;
        case IDM_ABOUT:
            MessageBox(hWnd,
            "ToTop 1.0\n"
            "Copyright  1992 John Deurbrouck\n\n"
            "First published in PC Magazine\n"
            "September 29, 1992",
            "About ToTop",MB_ICONINFORMATION);
            break;
        case SC_MAXIMIZE:
        case SC_RESTORE:
        case SC_SIZE:
            break;
        default:
            return DefWindowProc(hWnd,Message,wParam,lParam);
        }
        break;
    case WM_SIZE:
        switch(wParam){
        case SIZE_MAXIMIZED:
        case SIZE_RESTORED:
            break;
        default:
            return DefWindowProc(hWnd,Message,wParam,lParam);
        }
        break;
    case WM_MOUSEMOVE:
        if(!nDoingTopBottomAction){
            return DefWindowProc(hWnd,Message,wParam,lParam);
        }
        hwndTemp=IsDoable(GetMessagePos());
        if(hwndTemp){                   /* processable? */
            if(!nShowingOkCursor){      /* need to change cursor? */
                nShowingOkCursor=1;
                SetCursor(hcOkCursor);  /* yes, change it */
            }
        }
        else{
            if(nShowingOkCursor){       /* need to change cursor? */
                nShowingOkCursor=0;
                SetCursor(hcNotOkCursor); /* yes, change it */
            }
        }
        break;
    case WM_LBUTTONDOWN:
        if(!nDoingTopBottomAction){
            return DefWindowProc(hWnd,Message,wParam,lParam);
        }
        nGotLButtonDown=1;
        break;
    case WM_LBUTTONUP:
        if(!nDoingTopBottomAction){
            return DefWindowProc(hWnd,Message,wParam,lParam);
        }
        if(nGotLButtonDown)TopBottomWindowAtPoint(GetMessagePos());
        StopDoingTopBottomAction();
        break;
    case WM_LBUTTONDBLCLK:
    case WM_MBUTTONDBLCLK:
    case WM_RBUTTONDBLCLK:
    case WM_MBUTTONUP:
    case WM_RBUTTONUP:
        if(nDoingTopBottomAction)StopDoingTopBottomAction();
        else return DefWindowProc(hWnd,Message,wParam,lParam);
        break;
    case WM_CLOSE:
        if(nDoingTopBottomAction)StopDoingTopBottomAction();
        DestroyWindow(hWnd);
        PostQuitMessage(0);
        break;
    default:
        return DefWindowProc(hWnd,Message,wParam,lParam);
    }
    return 0L;
}
void DoTopBottomAction(int nTopOrBottom){
/*
**  called with DO_TOP or DO_BOTTOM, which determines whether
**  the target window is floated or sunk
**
**  takes control of the mouse, sets nDoingTopBottomAction
**  to nTopOrBottom, then returns
*/
    LPSTR desiredcursor,desiredncursor;
    if(nDoingTopBottomAction)return;
    switch(nTopOrBottom){
    case DO_TOP:
        desiredcursor="TopCursor";
        desiredncursor="NTopCursor";
        break;
    case DO_BOTTOM:
        desiredcursor="BottomCursor";
        desiredncursor="NBottomCursor";
        break;
    default:
        return;
    }
    nDestroyOkCursor=nDestroyNotOkCursor=0;
    hcOkCursor=LoadCursor(hInst,desiredcursor);
    if(!hcOkCursor)hcOkCursor=LoadCursor(NULL,IDC_CROSS);
    else nDestroyOkCursor=1;
    hcNotOkCursor=LoadCursor(hInst,desiredncursor);
    if(!hcNotOkCursor){
        hcNotOkCursor=LoadCursor(NULL,IDC_CROSS);
    }
    else nDestroyNotOkCursor=1;
    SetCapture(hWndMain);
    hcOldCursor=SetCursor(hcOkCursor);
    nShowingOkCursor=1;
    nDoingTopBottomAction=nTopOrBottom;
    nGotLButtonDown=0;
    nSuccess=0;
}
void StopDoingTopBottomAction(void){
/*
**  if nDoingTopBottomAction, zeros it and releases mouse
**  also destroys cursor(s)
*/
    if(nDoingTopBottomAction){
        nDoingTopBottomAction=0;
        if(hcOldCursor)SetCursor(hcOldCursor);
        else SetCursor(LoadCursor(NULL,IDC_ARROW));
        if(nDestroyOkCursor){
            DestroyCursor(hcOkCursor);
            hcOkCursor=NULL;
        }
        if(nDestroyNotOkCursor){
            DestroyCursor(hcNotOkCursor);
            hcNotOkCursor=NULL;
        }
        nDestroyOkCursor=nDestroyNotOkCursor=0;
        ReleaseCapture();
        if(!nSuccess)MessageBeep(-1);
    }
}
void TopBottomWindowAtPoint(long lParam){
/*
**  goes by nDoingTopBottomAction, which determines whether the point
**  at lParam (taken from a mouse message) gets its window sent to
**  the top or the bottom
*/
    HWND hwnd=IsDoable(lParam),order;
    if(!hwnd)return;
    order=(nDoingTopBottomAction==DO_TOP)?HWND_TOPMOST:HWND_NOTOPMOST;
    if(SetWindowPos(hwnd,order,0,0,0,0,
    SWP_NOACTIVATE|SWP_NOMOVE|SWP_NOSIZE)){
        nSuccess=1;
    }
}
HWND IsDoable(long lParam){
    /*
    **  takes current position, returns window handle of window that
    **  should be topped or bottomed. If not possible, returns NULL.
    */
    HWND child,parent,desktop,order;
    POINT point;
    LONG extended_style;
    if(!nDoingTopBottomAction)return NULL;
    desktop=GetDesktopWindow();
    point.x=(int)LOWORD(lParam);
    point.y=(int)HIWORD(lParam);
    child=WindowFromPoint(point);
    if((!child)||(child==desktop))return NULL;
    /*
    **  ok, it's a good window
    **  let's go back to the highest level
    **  *before* the desktop
    */
    for(;;){
        parent=GetParent(child);
        if(!parent||(parent==desktop))break;
        child=parent;
    }
    /*
    **  now child is HWND for target app,
    **  so let's find out it if can be done...
    */
    extended_style=GetWindowLong(child,GWL_EXSTYLE);
    if(extended_style&WS_EX_TOPMOST){   /* window topped */
        return (nDoingTopBottomAction==DO_BOTTOM)?child:NULL;
    }
    else{                               /* window not topped */
        return (nDoingTopBottomAction==DO_TOP)?child:NULL;
    }
}
