/* 
WINCLIP.H -- DOS access to Windows Clipboard (Enhanced mode)

Copyright (c) 1992 Ziff Davis Communications
PC Magazine * Andrew Schulman (June 1992)
*/

#ifdef METAWARE
/* if using with 32-bit code */
#define far _far
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* higher-level functions */

int WindowsClipboard(void);
int Clipserv(void);
int PutClipStrLen(char *str, unsigned len);
int PutClipString(char *str);
char *GetClipString(void);
void FreeClipString(char *str);

/**********************************************************************/

/* lower-level functions */

#define CF_TEXT				1
#define CF_BITMAP			2
#define CF_METAFILEPICT		3
#define CF_SYLK				4
#define CF_DIF				5
#define CF_TIFF				6
#define CF_OEMTEXT			7
#define CF_DSPTEXT			0x81
#define CF_DSPBITMAP		0x82

typedef unsigned short CF_FORMAT;

#pragma pack(1)

typedef struct {
    int           bmType;
    int           bmWidth;
    int           bmHeight;
    int           bmWidthBytes;
    unsigned char bmPlanes;
    unsigned char bmBitsPixel;
    unsigned char far * bmBits;
    unsigned      bmWidDim;
    unsigned      bmHigDim;
    unsigned char BitmapData[1];
    } BITMAP;

typedef struct {
    int           mm;
    int           xExt;
    int           yExt;
    unsigned char MetaFilePictData[1];
  } METAFILEPICT;

unsigned long CompactClipboard(unsigned long size);
unsigned CloseClipboard(void);
unsigned EmptyClipboard(void);
unsigned char far *GetClipboardData(CF_FORMAT format, 
    unsigned char far *buf);
unsigned long GetClipboardDataSize(CF_FORMAT format);
unsigned GetDeviceCaps(unsigned index);
unsigned IdentifyWinOldApVersion(void);
unsigned OpenClipboard(void);
unsigned SetClipboardData(CF_FORMAT format, unsigned char far *buf, 
    unsigned long size);
void Yield(void);

#ifdef __cplusplus
}
#endif

