;********* INCENV.ASM - increases the size of a BASIC program's environment

;Copyright (c) 1991 Ethan Winer


;Syntax: CALL IncreaseEnv(BYVAL BytesLarger%)

;NOTE: This routine will not work in the QB or QBX editor.


.Model Medium, Basic
    Extrn B$SETM:Proc       ;this is BASIC's internal SETMEM function

.Data
    Extrn __aenvseg:Word    ;this is BASIC's internal environment segment
    Extrn b$env_len:Word    ;the length of BASIC's environment, also internal
    Extrn __psp:Word        ;the PSP of the BASIC program

.Code

IncreaseEnv Proc Uses DI SI, Increase:Word

    Mov  BX,__aenvseg   ;get BASIC's environment segment
    Dec  BX             ;look at the segment before (its MCB)
    Mov  ES,BX          ;through ES
    Mov  AX,ES:[3]      ;the size is in the third byte of the MCB

    Mov  BX,Increase    ;see how many bytes larger it is to be
    Mov  CL,4           ;prepare to divide by 16
    Shr  BX,CL          ;convert from bytes to paragraphs
    Inc  BX             ;plus one more in case of an odd number

    Add  AX,BX          ;now AX holds the new size in paragraphs
    Push AX             ;save this for later
    Shl  AX,CL          ;convert the new size from paragraphs to bytes
    Push AX             ;save this for later too

    Add  AX,16          ;bump up an extra paragraph for headroom
    Neg  AX             ;convert to a negative version for SETMEM
    Cwd                 ;now that value is in DX:AX
    Push DX             ;pass it on to SETMEM
    Push AX
    Call B$SETM         ;now we can call DOS to claim memory

    Pop  CX             ;retrieve the new size in bytes (was pushed as AX)
    Pop  BX             ;and retrieve again as paragraphs (also pushed as AX)
    Mov  AH,48h         ;DOS Allocate Memory service
    Int  21h            ;claim memory for the new environment
    Jc   Exit           ;for some reason the memory request failed...

    Mov  b$env_len,CX   ;it worked, show BASIC the new maximum env. length
    Push DS             ;save DS before we trash it below
    
    Mov  ES,AX          ;we'll copy to the newly allocated segment
    Sub  DI,DI          ;all segments start at address zero
    Mov  DS,__aenvseg   ;copy from BASIC's environment
    Sub  SI,SI          ;also starting at address zero
    Cld                 ;copy forward
    Rep  Movsb          ;copy the old environment to the new segment

    Pop  DS             ;retrieve DS so we can get at BASIC's data
    Push DS             ;save it again for a moment
    Mov  __aenvseg,ES   ;show BASIC where it's new environment segment is
    Mov  DS,__psp       ;now load the BASIC program's PSP segment
    Mov  DS:[2Ch],ES    ;and assign the new environment segment there
                        ;  so DOS will know about the relocated environment

    Pop  DS             ;retrieve DS before returning

Exit:
    Ret                 ;return to BASIC and restore the Uses registers

IncreaseEnv Endp
End
