/* ******************************************************************** *

   DEFRAGR 1.00  Copyright (c) 1993, Michael Holmes and Bob Flanders
   First published in PC Magazine, February 23, 1993  Defrag a DOS drive

 * ******************************************************************** *

        Compile this program with Borland C++ 3.x using the
        following command line:

                BCC -O2-i -mc defragr.c

 * ******************************************************************** *

    Things to look at for improvements

        Alternate quick defrag methodology (/A1)

        Dry run of defrag to determine total clusters moved,
            that will make "Left:" be accurate.


    Modifications Log

    1.00 15Nov92 Changed name to DEFRAGR and added bytes/second to
                   the final user report.

 * ******************************************************************** */

#pragma  pack(1)                            /* pack to byte alignment   */
#include <stdio.h>                          /* standard i/o library     */
#include <io.h>                             /* i/o routine headers      */
#include <stdlib.h>                         /* ANSI compatibility       */
#include <direct.h>                         /* directory functions      */
#include <dos.h>                            /* DOS rtn definitions      */
#include <malloc.h>                         /* memory declarations      */
#include <string.h>                         /* string functions         */
#include <ctype.h>                          /* character functions      */
#include <conio.h>                          /* console i/o routines     */
#include <fcntl.h>                          /* file control header      */
#include <sys\stat.h>                       /* file status header       */
#include <memory.h>                         /* memory functions         */
#include <stdarg.h>                         /* argument functions       */

/* #define DEBUG                            /* enable debugging helps   */

#define NOT         !                       /* logical not              */
#define CLEAR(s,c)  memset(s,c,sizeof(s))   /* string clear             */
#define LAST(x)     x[strlen(x) - 1]        /* get last char in string  */
#define UINT        unsigned int            /* unsigned integer type    */
#define UCHAR       unsigned char           /* unsigned character type  */
#define HUGE        char huge               /* shorthand                */
#define BOOT        boot_record             /* boot record shorthand    */
#define MAX_PATH    79                      /* max path length          */
#define DELAY_CNT   36                      /* 2 second timer tick delay*/
#define D_ENTRY     struct dir_entry        /* shorthand for dir entry  */
#define S_ENTRY     struct short_entry      /* short for short dir entry*/
#define S_DIR(z)    (z->s_dir != 0xff)      /* dir entry for subdir     */
#define S_FILE(z)   (z->s_dir == 0xff)      /* ..and one for files      */
#define REV_FAT     struct reverse_fat      /* shorthand for rev_fat    */
#define C_ARRAY     struct cluster_array    /* ..and for cluster buffer */
#define L_ARRAY     struct lru_array        /* ..and for lru sector bufs*/
#define DIR_TEST(z) z->d_eattr & _A_SUBDIR  /* DOS directory for subdir */
#define FILE_TST(z) (NOT (d->d_eattr &      /* DOS directory for file  */\
                      (_A_SUBDIR | _A_VOLID)))
#define INT_PARMS UINT bp, UINT di,         /* interrupt calling conv  */\
            UINT si, UINT ds, UINT es, UINT dx, UINT cx,                 \
            UINT bx, UINT ax, UINT cs, UINT ip, UINT flags


/* ******************************************************************** *
 *      routine definitions                                             *
 * ******************************************************************** */

void    quit_with(char *, ...),             /* quit with error message  */
        keepalive(int),                     /* keepalive messages       */
        initialization(int, char **),       /* init and parse cmd line  */
        drive_check(void),                  /* check drive's validity   */
        get_fat(void),                      /* read FAT into memory     */
        get_dir(void),                      /* build incore dir struct  */
        get_sub_dir(char *, D_ENTRY huge *),/* build subdir dir entries */
        fill_reverse_fat(void),             /* compute target clusters  */
       *read_sector(UINT, UINT),            /* read one directory sector*/
        write_sector(void),                 /* write dir sector back    */
        write_dirty(void),                  /* flush dirty buffers      */
        dirty_sector(void),                 /* show sector altered      */
        load_cluster(UINT, UINT, int,       /* bld cluster buffer entry */
            C_ARRAY huge *),
        move_cluster(C_ARRAY huge *),       /* set up dir entries       */
        search_cluster(UINT),               /* search for stuff to move */
        multi_cluster(int),                 /* multi-cluster read/write */
        multi_update(void),                 /* handle multi-cluster updt*/
        update_fat(UINT, UINT),             /* update FAT w/new entry   */
        re_write_fat(int),                  /* re_write FAT to disk     */
        update_dir(S_ENTRY huge *, UINT),   /* update a directory entry */
        build_s_entry(D_ENTRY huge *,       /* build a short dir entry  */
            UINT, UINT),                    /* ..from a DOS dir entry   */
        rearrange_disk(void),               /* move clusters to target  */
        user_report(void),                  /* give closing user report */
        clear_memory(HUGE *, long),         /* clear area to zero       */
        bit_off(char *, UINT),              /* set bit entry off        */
        check_fat(void),                    /* check FAT status         */
        update_progress(void),              /* user progress with graph */
       *huge_malloc(long),                  /* amount of memory to get  */
        interrupt critical_handler(         /* critical error handler   */
            INT_PARMS);

int     parse_parms(int, char **, int,      /* parse command line       */
            struct cmd_parm *, char ***),
        disk_io(int, long, int, HUGE *),    /* read/write disk sectors  */
        control_break(void),                /* control break handler    */
        bit_on(char *, UINT),               /* set bit entry on         */
        bit_check(char *, UINT),            /* check bit status         */
        check_cluster(UINT),                /* cluster number check     */
        win_test(void);                     /* check if Windows up      */

UINT    follow_dir_chain(UINT,              /* build subdir cluster list*/
                    D_ENTRY huge *),
        to_be_moved(void),                  /* cnt clusters to be moved */
        find_free(void),                    /* find free cluster to use */
        get_next_fat(UINT),                 /* get next FAT in chain    */
        walk_fat(UINT);                     /* find file's next cluster */

char   *pack_name(char *),                  /* fcb name to filename.ext */
       *join_path(char *, char *),          /* join a path and filespec */
       *read_label(void),                   /* read drive label         */
       *translate_name(char *),             /* validate dir name        */
       *graph_string(long, long),           /* build a graph string     */
       *large_fmt(unsigned long, char *);   /* format a large number    */

long    timer_count(void),                  /* get current tick count   */
        logical_sector(UINT);               /* cluster nbr to sector nbr*/


/* ******************************************************************** *
 *      structures                                                      *
 * ******************************************************************** */

struct boot_rec                         /* boot record                  */
    {
    char jmp[3],                            /* jump instruction         */
         oem[8];                            /* OEM name                 */
    UINT bytes;                             /* bytes per sector         */
    char cluster;                           /* sectors per cluster      */
    UINT res_sectors;                       /* reserved sectors         */
    char fats;                              /* number of fats           */
    UINT roots,                             /* nbr of root dir entries  */
         sectors;                           /* total sectors            */
    char media;                             /* media descriptor block   */
    UINT fatsize,                           /* sectors per fat          */
         tracksize,                         /* sectors per track        */
         heads;                             /* number of heads          */
    long hidden,                            /* hidden sectors           */
         sectors_32;                        /* sectors if above 32Mb    */
    } *BOOT;


struct dos_i25                          /* dos interrupt 25/26 block    */
    {
    long sector;                            /* sector to read           */
    int  num_secs;                          /* number of sectors to read*/
    HUGE *read_addr;                        /* address of input area    */
    };


struct media_id                         /* media id block               */
    {
    int  info_level,                        /* information level        */
         serial1,                           /* serial number, part I    */
         serial2;                           /* ..part II                */
    char vol_id[11],                        /* volume label             */
         file_sys[8];                       /* file system id           */
    };


D_ENTRY                                 /* directory entries            */
    {
    char d_efile[8],                        /* filename                 */
         d_eext[3],                         /* ..and extension          */
         d_eattr,                           /* attribute                */
         d_eres[10];                        /* reserved                 */
    UINT d_etime,                           /* file time                */
         d_edate,                           /* ..and date               */
         d_ecluster;                        /* 1st cluster number       */
    long d_esize;                           /* file size                */
    };


S_ENTRY                                 /* working directory entry      */
    {
#ifdef DEBUG
    char s_name[11];                        /* filename  **DEBUG**      */
#endif
    unsigned
    char s_dir;                             /* subdirectory entry flag  */
    UINT s_cluster,                         /* cluster of dir entry     */
         s_index,                           /* ..index within dir entry */
         s_data;                            /* 1st cluster of data      */
    } huge *s_entries,                      /* main list                */
      huge *s_next;                         /* next entry pointer       */


struct  reverse_fat                     /* reverse fat                  */
    {
    UINT   r_target;                        /* target cluster number    */
                                            /*   0 = free               */
                                            /*   1 = unmovable          */
                                            /*  nn = final cluster      */
    UINT   r_diridx;                        /* short dir entry index    */
    } huge *rev_fat;


struct  cluster_array                   /* cluster buffer array         */
    {
    UINT c_from,                            /* from cluster number      */
         c_to;                              /* to cluster number        */
    unsigned
    char c_dir,                             /* directory level flag     */
                                            /*   0 = file's 1st cluster */
                                            /*   n = dir level (s_dir)  */
                                            /*  ff = file not 1st clustr*/
         c_inuse;                           /* entry inuse flag         */
    int  c_type;                            /* type of move             */
                                            /*   0 = final destination  */
                                            /*   1 = temporary move     */
    HUGE *c_buffer;                         /* buffer pointer           */
    } huge *c_array;

struct  lru_array                       /* last used sector array       */
    {
    char l_dirt,                            /* sector dirty flag        */
         l_invalid;                         /* data invalid             */
    long l_number,                          /* sector number            */
         l_time;                            /* time of last use         */
    HUGE *l_buffer;                         /* buffer pointer           */
    } huge *l_array,                        /* lru array of buffers     */
      huge *l_ptr;                          /* last used pointer        */



/* ******************************************************************** *
 *      command line parms and switches                                 *
 * ******************************************************************** */

char    sw_quiet;                           /* quiet switch             */

struct  cmd_parm                            /* command line parms       */
    {
    char cp_ltr,                            /* switch letter            */
         cp_flag,                           /* entry type               */
         *cp_entry;                         /* pointer to data          */
    } parm_table[] =
        {
        { 'Q', 0, &sw_quiet }               /* Q - quiet mode           */
        };
                                            /* nbr of table entries     */
#define PARM_TABLE_CNT  sizeof(parm_table) / sizeof(struct cmd_parm)


/* ******************************************************************** *
 *      globals                                                         *
 * ******************************************************************** */

int     pos_found,                          /* number positionals found */
        init_drive,                         /* startup drive            */
        rc = 1,                             /* errorlevel return code   */
        dir_level,                          /* subdirectory level       */
        walk_rc,                            /* work return code         */
        critical_flag,                      /* critical routine flag    */
        break_request;                      /* ^break in critical rtn   */

UINT    nclusters,                          /* number of clusters       */
        bad_cluster,                        /* bad cluster number       */
        max_cluster,                        /* max cluster number       */
        max_secs,                           /* largest read with int25  */
        bytes_sector,                       /* bytes per sector         */
        sec_cluster,                        /* sectors per cluster      */
        w_cluster,                          /* work cluster number      */
        dir_sector,                         /* dir entries per sector   */
        dir_sectors,                        /* total directory sectors  */
        first_free,                         /* first free cluster       */
        low_level,                          /* starting search cluster  */
        root_length,                        /* size of root directory   */
        remaining,                          /* remaining to be moved    */
        i_remain,                           /* initial remaining count  */
        phase,                              /* cluster movement phase   */
        c_idx,                              /* cluster buffer counter   */
        c_max,                              /* nbr of cluster buffers   */
        l_used,                             /* ..nbr of lru's bufs used */
        l_max,                              /* ..max nbr of buffers     */
        fat_write;                          /* re-write of all FATs flag*/

long    nsectors,                           /* number of sectors on drv */
        cluster_size,                       /* bytes per cluster        */
        c_size,                             /* cluster buffer size      */
        avail_disk,                         /* available bytes on disk  */
        root_sector,                        /* 1st root dir sector nbr  */
        data_sector,                        /* 1st data sector number   */
        s_maxcnt,                           /* max nbr of S_ENTRYs      */
        moved_count,                        /* moved cluster count      */
        temp_moves,                         /* temp area moves          */
        last_read_sector,                   /* last read sector number  */
        init_count,                         /* start up elapsed time    */
        total_ticks,                        /* total elapsed ticks      */
        l_hits,                             /* lru cache hits           */
        l_recycle,                          /* recycled cache buffers   */
        l_forces;                           /* forced cache flushes     */

char  **pos_parms,                          /* positional parms array   */
       *init_path,                          /* startup drive and path   */
        huge *fat,                          /* address of FAT           */
       *fat_flag,                           /* rewrite FAT sector flags */
       *in_use,                             /* in-use bit array         */
        fat_16,                             /* 16 bit FAT entry flag    */
        huge *disk_buffer,                  /* one sector buffer        */
        drive[] = " :\\",                   /* drive and path to check  */
        drive_nbr,                          /* drive nbr (1 = A)        */
        sw_dos,                             /* use dos int 25/26 block  */
        block_1[17],                        /* string of completed blks */
        block_2[17],                        /* ..and not done blocks    */
        block_3[5] =                        /* ..and almost done blocks */
            { 178, 177, 176, 250, 219 },
        bits[] =                            /* bits definitions         */
            { '\x80', '\x40', '\x20', '\x10',
              '\x08', '\x04', '\x02', '\x01' };

FILE   *out;                                /* messages handle          */

struct  SREGS s;                            /* segment registers        */
union   REGS  r;                            /* ..and general registers  */


/* ******************************************************************** *
 *      messages and strings                                            *
 * ******************************************************************** */

char    copyright[]    = "DEFRAGR 1.00 \xfe Copyright (c) 1993, "
                         "Michael Holmes and Bob Flanders\n"
                         "First published in PC Magazine, "
                         "February 23, 1993 "
                         "\xfe Defragment a DOS drive\n\n",
        too_many[]     = "Too many arguments\n",
        bad_op[]       = "Invalid argument %s\n",
        stop_here[]    = "\nStopping at user's request\n",
        multi_error[]  = "DEFRAGR cannot run under %s\n",
       *op_sys[]     = { "Windows/DosShell",
                         "DosShell",
                         "DesqView",
                         "Fastopen" },
        net_drive[]    = "Cannot defrag a network, remote, SUBST'd "
                         "or ASSIGN'd drive\n",
        no_mem[]       = "Insufficient memory available for "
                         "processing\n",
        no_workspace[] = "No free disk available for work space\n",
        dos_error[]    = "Must run with DOS 2.0 or greater\n",
        drive_error[]  = "Drive not ready\n",
        bad_drive[]    = "Invalid drive specified\n",
        full_table[]   = "Insufficient memory for directory entries\n",
        fat_error[]    = "Error reading the File Allocation Table\n",
        boot_error[]   = "Error reading the Boot Record\n",
        dir_read[]     = "Error reading directory information\n",
        read_error[]   = "\nError reading the disk\n",
        write_error[]  = "\nError writing the disk\n",
        fat_write_err[]= "\nError writing the FAT\n",
        int_error[]    = "\nInternal FAT error\n",
        bad_fat[]      = " FAT Problem: %s. Please run CHKDSK /F\n",
       *fat_err[]    = { "Cross-linked files",
                         "Invalid cluster number",
                         "Invalid directory entry",
                         "Lost allocation unit found" },
        serial_nbr[]   = "Serial: %04X-%04X",
        drive_info[]   = "     Drive %c: %s\n"
                         "   Disk Info: %lu Sectors, %u Clusters, "
                         "%lu Clustersize\n"
                         "    Capacity: %s, %s used, %s available\n",
        warning_msg[]  = "     Warning: Free disk space < %s may "
                         "reduce DEFRAGR's efficiency\n",
        all_done[]     = " Cache Stats: %d used, %ld hits, %ld misses,"
                         " %ld forced writes\n"
                         "    Finished: %lu total clusters moved @ %0.1f"
                         " (%s) per second\n"
                         "    Elaspsed: Overall time %d:%02d:%02d\n",
        all_ok[]       = "    Finished: Drive was already optimized\n",
        eligible[]     = " To Be Moved: %u clusters in %ld "
                         "subdirectories and/or files\n"
                         "      Memory: %d cluster buffers (%s) and a "
                         "%d sector directory cache\n",
        working[]      = "\r      Status: %s %4.1f%% %5u"
                         "->final,%6ld->temp  %s  \b",
       *phase_desc[] = { "Search",
                         "  Read",
                         " Write",
                         "Update" },
        clean_up[]     = "\r%79.79s\r",
        help[]         = "     Usage:  DEFRAGR d: [/Q]\n\n"
                         "   Options:  d:  drive to defragment\n"
                         "             /Q  sets quiet mode\n";


/* ******************************************************************** *
 *      main()                                                          *
 * ******************************************************************** */

void    main(int  ac,                       /* DOS cmd line token count */
             char *av[])                    /* ..token strings          */
{

printf(copyright);                          /* give copyright message   */
initialization(ac, av);                     /* init and parse cmd line  */
drive_check();                              /* check version and drive  */
get_fat();                                  /* read FAT into memory     */
get_dir();                                  /* read directory structure */
check_fat();                                /* check dir/FAT structure  */
fill_reverse_fat();                         /* build reverse FAT table  */
rearrange_disk();                           /* move clusters around     */
user_report();                              /* give final report ..     */

}



/* ******************************************************************** *
 *      initialization() -- init interrtupts and parse command line     *
 * ******************************************************************** */

void    initialization(int  ac,             /* DOS cmd line token count */
                       char *av[])          /* ..token strings          */
{
int     i;                                  /* loop counter, work       */
char    *p;                                 /* positional parm pointer  */


timer_count();                              /* init timer mechanism     */

ctrlbrk(control_break);                     /* set up ctrl break and    */
_dos_setvect(0x24, critical_handler);       /* ..DOS critical handlers  */

_dos_getdrive((UINT *) &init_drive);        /* get the default drive    */
drive_nbr = init_drive;                     /* ..set up default drive   */
*drive = init_drive + 'A' - 1;              /* ..nbr and ASCII string   */

if ((pos_found = parse_parms(ac, av,        /* parse switches and       */
        PARM_TABLE_CNT, parm_table,         /* ..positional parameters  */
        &pos_parms)) > 1)                   /* q. too may positionals?  */
    quit_with(too_many);                    /* a. yes .. give err/quit  */

if (pos_found == 1)                         /* q. drive given?          */
    {
    p = *pos_parms;                         /* a. yes .. get pointer    */

    if ((strlen(p) == 2) && p[1] == ':')    /* q. valid size and shape? */
        *drive = *p;                        /* a. yes .. copy in drive  */
     else
        quit_with(bad_drive);               /* else .. give syntax err  */
    }
 else
    quit_with(help);                        /* else .. give help msg    */

drive[0] = toupper(drive[0]);               /* uppercase search drive   */
drive_nbr = drive[0] - 'A' + 1;             /* get drive nbr from string*/
_dos_setdrive(drive_nbr, (UINT *) &i);      /* set up target drive      */

if ((init_path = getcwd(NULL, MAX_PATH))    /* q. get current path ok?  */
             == NULL)
    quit_with(drive_error);                 /* a. no .. drive not ready */

memset(block_1, 0xfa, 16);                  /* set up string of blocks  */
memset(block_2, 0xdb, 16);                  /* ..to show defrag progress*/

out = sw_quiet ? fopen("NUL", "w") : stdout;/* send msgs to nul if quiet*/

}



/* ******************************************************************** *
 *      drive_check() -- check version and drive being local            *
 * ******************************************************************** */

void    drive_check(void)
{


if (_osmajor > 3)                           /* q. check Fastopen safely?*/
    {                                       /* a. yes .. proceed        */
    r.x.ax = 0x122a;                        /* ax = Fastopen check      */
    r.x.bx = 1;                             /* bx = get entry point     */
    r.x.si = 0xffff;                        /* si = invalid entry       */
    int86(0x2f, &r, &r);                    /* issue multiplex call     */

    if (r.x.cflag)                          /* q. Fastopen installed?   */
        quit_with(multi_error, op_sys[3]);  /* a. yes .. give err & die */
    }

if (win_test())                             /* q. Windows up?           */
    quit_with(multi_error, op_sys[0]);      /* a. yes .. give error     */

r.x.ax = 0x4b03;                            /* ax = tasker check        */
r.x.bx = r.x.di = 0;                        /* bx & di = zero for call  */
s.es = 0;                                   /* es = zero for check call */
r.x.cx = 0xd055;                            /* cx = init value          */
int86x(0x2f, &r, &r, &s);                   /* issue multiplex call     */

if (r.x.bx != 0)                            /* q. multitasking active?  */
    quit_with(multi_error, op_sys[1]);      /* a. yes .. give err & die */

r.x.cx = 'DE';                              /* cx = DE of DESQ          */
r.x.dx = 'SQ';                              /* dx = SQ of DESQ          */
r.x.ax = 0x2b01;                            /* ax = set date function   */
int86(0x21, &r, &r);                        /* call DOS                 */

if (r.h.al != 0xff)                         /* q. DesqView active?      */
    quit_with(multi_error, op_sys[2]);      /* a. yes .. give err & die */

if (_osmajor < 2)                           /* q. pre-DOS 2.00?         */
    quit_with(dos_error);                   /* a. yes .. can't run it   */

if (strcmp(drive,                           /* q. real name different?  */
            translate_name(drive)))
        quit_with(net_drive);               /* a. yes .. error          */

if ((_osmajor == 3 && _osminor >= 1) ||     /* q. DOS 3.1 or higher?    */
            (_osmajor > 3))                 /* a. yes .. more checks    */
    {
    r.x.ax = 0x4409;                        /* ah = ioctl, local test   */
    r.h.bl = drive_nbr;                     /* bl = drive to test       */
    int86(0x21, &r, &r);                    /* test drive               */

    if (r.x.cflag)                          /* q. bad drive?            */
        quit_with(bad_drive);               /* a. yes .. error          */

    if (r.x.dx & 0x9200)                    /* q. network/remote/subst? */
        quit_with(net_drive);               /* a. yes .. error          */
    }

sw_dos |= (_osmajor >= 4) ||                /* use extended interrupt   */
           ((_osmajor == 3) &&              /* ..for DOS 3.31 and better*/
                   (_osminor == 31));

}



/* ******************************************************************** *
 *      get_fat() -- read boot record and FAT into memory               *
 * ******************************************************************** */

void    get_fat(void)
{
long    rev_size;                           /* length of reverse FAT    */
char    strings[3][10];                     /* temporary strings        */


r.h.ah = 0x36;                              /* ah = get freespace       */
r.h.dl = drive_nbr;                         /* get drive                */
int86(0x21, &r, &r);                        /* r.x.cx = bytes/sector    */

BOOT = (struct boot_rec *)                  /* get memory for boot rec  */
            huge_malloc(r.x.cx);

bytes_sector = BOOT->bytes = r.x.cx;        /* set up nbr bytes/sector  */
avail_disk = (long) r.x.bx;                 /* ..nbr of avail clusters  */

max_secs = (UINT) ((65536L - 16) /          /* set max sectors per read */
            bytes_sector);

if (disk_io(0, 0L, 1, (HUGE *) BOOT))       /* q. read boot sector ok?  */
    quit_with(boot_error);                  /* a. no .. give err msg    */

nsectors = (BOOT->sectors ?                 /* compute ..               */
            (long) BOOT->sectors :          /* ..nbr of sectors on      */
            BOOT->sectors_32);              /* ..logical DOS drive      */

nclusters = (unsigned) ((long)((nsectors    /* ..nbr of DOS clusters    */
            - (BOOT->res_sectors
            + (BOOT->fatsize * BOOT->fats)
            + ((BOOT->roots * 32) / bytes_sector)))
            / BOOT->cluster));

fat_16 = nclusters > 4086;                  /* set if 16bit FAT table   */
max_cluster = nclusters + 2;                /* ..max cluster number     */
bad_cluster = fat_16 ? 0xfff7 : 0xff7;      /* ..and the bad cluster nbr*/

sec_cluster = BOOT->cluster;                /* ..sectors per cluster    */
cluster_size = sec_cluster * bytes_sector;  /* ..bytes per cluster      */
avail_disk *= cluster_size;                 /* ..available bytes        */
dir_sector = (UINT) (bytes_sector /         /* ..dir entries per sector */
            sizeof(D_ENTRY));

root_sector = BOOT->res_sectors +           /* get sector number of..   */
            (BOOT->fatsize * BOOT->fats);   /* ..the root directory     */

root_length = BOOT->roots /                 /* ..and length in sectors  */
            (bytes_sector / sizeof(struct dir_entry));

data_sector = root_sector + root_length;    /* sector nbr of cluster two*/

fprintf(out, drive_info, drive[0],          /* give standard information*/
        read_label(), nsectors,             /* ..about logical volume   */
        nclusters, cluster_size,            /* ..and format out disk    */
        large_fmt(nclusters * cluster_size, /* ..volume size            */
                strings[0]),
        large_fmt(nclusters * cluster_size  /* ..and total used         */
                - avail_disk, strings[1]),
        large_fmt(avail_disk, strings[2])); /* ..and available size     */

/*
 *  Allocate space for FAT and reverse FAT
 */

fat = (HUGE *) huge_malloc((long)           /* get memory for a FAT     */
            BOOT->fatsize * (long) bytes_sector);

if (disk_io(0, (long) BOOT->res_sectors,    /* q. read FAT in?          */
            BOOT->fatsize, (char *) fat))
    quit_with(fat_error);                   /* a. no .. give error msg  */

fat_flag = (char *) huge_malloc(            /* get memory for re-write  */
            (long) BOOT->fatsize);          /* ..FAT sector flags       */
memset(fat_flag, 0, BOOT->fatsize);         /* ..then clear flag array  */

rev_size = (long) sizeof(struct             /* determine size of the    */
            reverse_fat) *                  /* ..reverse FAT table      */
            (long) (max_cluster + 1);

rev_fat = (struct reverse_fat *)            /* get memory for reverse   */
            huge_malloc(rev_size);          /* ..FAT and directory ptr  */

clear_memory((HUGE *) rev_fat, rev_size);   /* ..then init to zeros     */

/*
 *  Start building in-use bit array to mirror FAT
 */

in_use = (char *) huge_malloc(              /* one bit per cluster to   */
            (max_cluster + 7) / 8);         /* ..track inuse or free    */
memset(in_use, 0, (max_cluster + 7) / 8);   /* ..then clear bit array   */

bit_on(in_use, 0);                          /* show cluster one and     */
bit_on(in_use, 1);                          /* ..cluster two in use     */

}



/* ******************************************************************** *
 *      get_dir() -- build directory structure                          *
 * ******************************************************************** */

void    get_dir(void)
{
int     i;                                  /* loop control             */
C_ARRAY huge *c;                            /* cluster buffer pointer   */
L_ARRAY huge *l;                            /* last used sector pointer */
HUGE    *b;                                 /* work character pointer   */
long    mem,                                /* memory available         */
        dir_cache,                          /* subdir cache size        */
        c_entry,                            /* size of one cluster entry*/
        l_entry;                            /* ..and of one lru entry   */


disk_buffer = huge_malloc(bytes_sector);    /* memory for one sector    */

s_maxcnt = coreleft();                      /* find out how much memory */
s_entries = s_next = (S_ENTRY huge *)       /* ..then get it all for    */
            huge_malloc(s_maxcnt);          /* ..the short dir entries  */
s_maxcnt /= sizeof(S_ENTRY);                /* ..and set max count      */

get_sub_dir(drive, 0);                      /* handle root as a subdir  */

s_maxcnt = ((HUGE *) s_next -               /* get active nbr of entries*/
            (HUGE *) s_entries) / sizeof(S_ENTRY);

if (NOT s_maxcnt)                           /* q. anything to move?     */
    user_report();                          /* a. no .. quit here       */

s_entries = (S_ENTRY huge *)                /* free unused short ..     */
            farrealloc(s_entries,           /* ..directory entries      */
            (HUGE *) s_next - (HUGE *) s_entries);

s_next = &s_entries[s_maxcnt];              /* compute end of array ptr */

/*
 *  Allocate cluster cache
 */

c_entry = sizeof(C_ARRAY) + cluster_size;   /* compute size of one entry*/

mem = coreleft();                           /* amount of free memory    */
dir_cache = dir_sectors * bytes_sector;     /* max amt for subdir cache */

mem -= (mem / 5) > dir_cache ?              /* allow for either required*/
            dir_cache : (mem / 5);          /* ..cache size or 1/5 total*/

c_max = (int) (mem / c_entry);              /* get max nbr of buffers   */

if (NOT c_max)                              /* q. no buffers available? */
    quit_with(no_mem);                      /* a. yes .. quit with msg  */

c_array = (C_ARRAY huge *)                  /* ..then get it enough for */
            huge_malloc(c_max * c_entry);   /* ..the cluster buffers    */

c_size = c_max * cluster_size;              /* cluster buffer size      */

b = (HUGE *) c_array +                      /* determine start of bufs  */
            (sizeof(C_ARRAY) * c_max);

for (i = 0, c = c_array; i < c_max;         /* loop thru cluster        */
            i++, c++, b += cluster_size)    /* ..buffers array          */
    c->c_buffer = b;                        /* ..and set up buf pointers*/

/*
 *  Allocate sector level cache
 */

l_entry = sizeof(L_ARRAY) + bytes_sector;   /* compute size of one entry*/

if (coreleft() < sizeof(L_ARRAY))           /* q. down pretty low?      */
    quit_with(no_mem);                      /* a. yes .. quit with msg  */

l_max = (int) ((coreleft() -                /* ..and how many we can get*/
            sizeof(L_ARRAY)) / l_entry);    /* ..besides one from before*/

if (NOT l_max)                              /* q. no buffers available? */
    quit_with(no_mem);                      /* a. yes .. quit with msg  */

l_array = (L_ARRAY huge *)                  /* allocate a bunch of      */
            huge_malloc((l_max * l_entry)   /* ..sector buffers         */
            + sizeof(L_ARRAY));

b = (HUGE *) l_array +                      /* determine start of bufs  */
            (sizeof(L_ARRAY) * ++l_max);

l_array->l_buffer = disk_buffer;            /* re-use old buffer        */

for (i = 1, l = &l_array[i]; i < l_max;     /* loop thru last used      */
            i++, l++, b += bytes_sector)    /* ..sector buffers array   */
    {
    l->l_buffer = b;                        /* set up buf pointers      */
    l->l_dirt = 0;                          /* ..and clear dirty flag   */
    }

}




/* ******************************************************************** *
 *      get_sub_dir() -- read in subdirectory entries                   *
 * ******************************************************************** */

#pragma option -N
void    get_sub_dir(char *base,             /* base directory           */
                    D_ENTRY huge *sub_d)    /* sub directory entry      */
{
UINT    pass,                               /* pass control             */
        i, j,                               /* loop counter             */
        c,                                  /* current cluster number   */
        c_start,                            /* dir entry's 1st cluster  */
        e;                                  /* directory entry number   */
char    quit = 0,                           /* loop control flag        */
        name[MAX_PATH];                     /* subdirectory name        */
D_ENTRY huge *d;                            /* work dir entry pointer   */


strcpy(name, join_path(base,                /* build current directory  */
            pack_name((char *)              /* ..to base path           */
                    sub_d->d_efile)));      /* ..from directory entry   */

c_start = sub_d ? sub_d->d_ecluster : 0;    /* get 1st cluster number   */
dir_level++;                                /* ..and count dir levels   */

for (pass = 0; pass < 2; pass++)            /* process directory twice  */
    {
    c = c_start;                            /* set up 1st dir cluster   */

    for (quit = 0; NOT quit;)               /* loop thru clusters ..    */
        {                                   /* ..finding dir entries    */
        i = c ? sec_cluster                 /* determine nbr of sectors */
                : root_length;              /* ..in this cluster        */

        for (e = 0; NOT quit && i--;)       /* loop thru cluster..      */
            {
            d = (D_ENTRY *)                 /* read in the directory    */
                    read_sector(c, e);      /* ..sector and bump        */
            dir_sectors++;                  /* ..the dir sector count   */

            for (j = dir_sector;            /* for each directory entry */
                    j-- && NOT quit;        /* ..in the sector check    */
                    d++, e++)               /* ..both files and subdirs */
                {
                switch ((UCHAR) *d->d_efile)/* based on 1st char of name*/
                    {
                    case 0:                 /* never used entry?        */
                        quit = 1;           /* set quit flag            */

                    case '.':               /* subdir . or .. files?    */
                    case 0xe5:              /* ..or deleted entry?      */
                        continue;           /* bypass this entry;       */
                    }

                if (NOT pass &&             /* q. 1st pass?             */
                            FILE_TST(d))    /* ..and a file entry?      */
                    build_s_entry(d, c, e); /* a. yes .. bld short entry*/

                 else if (pass &&           /* q. 2nd pass?             */
                            DIR_TEST(d))    /* ..and subdirectory entry?*/
                    {
                    build_s_entry(d, c, e); /* a. yes .. bld short entry*/
                    get_sub_dir(name, d);   /* ..then walk down dir tree*/
                    read_sector(c, e);      /* ..and re-read dir sector */
                    }
                }
            }

        if (NOT (c = walk_fat(c)))          /* q. end of FAT chain?     */
            quit = 1;                       /* a. yes .. exit loop      */

        }
    }

dir_level--;                                /* show exit of this level  */

}



/* ******************************************************************** *
 *      build_s_entry() -- build a short directory entry                *
 * ******************************************************************** */

#pragma option -N-
void    build_s_entry(D_ENTRY huge *d,      /* DOS directory entry      */
                      UINT entry_cluster,   /* dir entry cluster number */
                      UINT entry_number)    /* ..and index              */
{
UINT    cluster;                            /* work cluster number      */


keepalive(0);                               /* keep user occupied       */

if (NOT (cluster = d->d_ecluster) ||        /* q. empty file?           */
            (d->d_eattr &                   /* ..or a system or         */
            (_A_HIDDEN | _A_SYSTEM)) &&     /* ..hidden file?           */
            NOT (d->d_eattr & _A_SUBDIR))   /* ..and not a subdir?      */
    {
    while (cluster)                         /* mark each as unmovable   */
        {
        rev_fat[cluster].r_target = 1;      /* ..by using cluster nbr 1 */

        if (bit_on(in_use, cluster))        /* q. bit already on?       */
            quit_with(bad_fat, fat_err[0]); /* a. yes .. must be error  */

        cluster = walk_fat(cluster);        /* ..then find next cluster */
        }

    return;                                 /* ..then return to caller  */
    }

#ifdef DEBUG
memcpy(s_next->s_name,                      /* **DEBUG**                */
            (char *) d->d_efile, 11);       /* **DEBUG**                */
#endif

s_next->s_dir = (d->d_eattr & _A_SUBDIR)    /* set up subdirectory flag */
            ? dir_level : 0xff;
s_next->s_data = d->d_ecluster;             /* ..user's 1st data cluster*/
s_next->s_cluster = entry_cluster;          /* dir entry's cluster      */
s_next->s_index = entry_number;             /* ..and index number       */

s_next++;                                   /* move to next short entry */

if (NOT --s_maxcnt)                         /* q. out of space?         */
    quit_with(full_table);                  /* a. yes .. quit w/message */

}



/* ******************************************************************** *
 *      fill_reverse_fat() -- fill reverse FAT entries                  *
 * ******************************************************************** */

void    fill_reverse_fat(void)
{
UINT    pass,                               /* loop control             */
        entry,                              /* dir_entry index          */
        c,                                  /* current cluster number   */
        next = 2;                           /* next cluster number      */
S_ENTRY huge *s;                            /* short dir entry pointer  */


for (pass = 1; pass < 3; pass++)            /* make two passes..        */
    {
    for (s = s_entries, entry = 0;          /* loop thru short directory*/
                s < s_next; s++, entry++)   /* ..entries walking the fat*/
        {
        keepalive(0);                       /* give user a keepalive    */

        if ((pass == 1 && S_DIR(s)) ||      /* q. 1st pass and subdir   */
                (pass == 2 && S_FILE(s)))   /* ..or 2nd pass and file?  */
            {
            for (c = s->s_data; c;)         /* a. yes .. walk its FAT   */
                {
                for (;                      /* search reverse FAT       */
                    rev_fat[next].r_target  /* ..for an available entry */
                    == 1; next++);          /* ..either alloc'd or free */

                rev_fat[c].r_target =       /* save new target          */
                        (c == next) ? 1     /* ..if it needs to be moved*/
                        : next++;

                rev_fat[c].r_diridx = entry;/* ..and directory entry nbr*/

                c = walk_fat(c);            /* get next file allocation */
                }
            }
        }

    keepalive(1);                           /* clean up messages        */

    }

first_free = next;                          /* save 1st free cluster    */

if (next >= max_cluster)                    /* q. out of space?         */
    quit_with(no_workspace);                /* a. yes .. give err & quit*/

i_remain = remaining = to_be_moved();       /* determine initial counts */

if (i_remain)                               /* q. moving something?     */
    {
    fprintf(out, eligible,                  /* a. yes .. give user info */
            i_remain,                       /* ..initial clusters       */
            s_maxcnt, c_max,                /* ..and cluster buffers    */
            large_fmt(c_size, 0), l_max);   /* ..and sector cache       */

    if (c_max > (max_cluster - first_free)) /* q. more bufs than disk?  */
        fprintf(out, warning_msg,           /* a. yes .. issue warning  */
            large_fmt((long) (c_max *       /* ..message about how we   */
            cluster_size), 0));             /* ..will be impaired       */
    }
}



/* ******************************************************************** *
 *      rearrange_disk() -- move clusters to their targets              *
 * ******************************************************************** */

void    rearrange_disk(void)
{


init_count = timer_count();                 /* save start up time       */

if (remaining)                              /* q. gonna do something?   */
    fat_write = 1;                          /* a. yes .. set rewrite flg*/

while (remaining)                           /* loop 'til all moved      */
    {
    search_cluster(remaining);              /* search for stuff to move */
    multi_cluster(0);                       /* read multiple clusters   */
    multi_cluster(1);                       /* ..then write multiples   */
    multi_update();                         /* ..finally update FAT/dirs*/
    }

fprintf(out, clean_up, "");                 /* clear last status message*/

}



/* ******************************************************************** *
 *      search_cluster() -- search for a cluster to move                *
 * ******************************************************************** */

void    search_cluster(UINT w)              /* working count            */
{
UINT    i,                                  /* loop control             */
        dest,                               /* destination cluster      */
        free_avail,                         /* free clusters avail flag */
        first_cycle;                        /* first cycle flag         */
REV_FAT huge *p, huge *q;                   /* reverse fat pointers     */
C_ARRAY huge *c;                            /* cluster buffer pointer   */


free_avail = first_cycle = 1;               /* set free and cycle flags */
phase = 0;                                  /* set up for first phase   */
update_progress();                          /* update user w/progress   */

i = low_level;                              /* starting cluster to check*/
p = &rev_fat[i];                            /* start of reverse FAT     */
q = &rev_fat[max_cluster];                  /* end of reverse FAT       */

for (c_idx = 0, c = c_array;                /* loop while there are     */
        p <= q; p++, i++)                   /* ..clusters to be queued  */
    {
    if (p->r_target > 1)                    /* q. need to be moved?     */
        {                                   /* a. yes .. check it out   */
        dest = p->r_target;                 /* get destination cluster  */

        if (first_cycle)                    /* q. 1st cluster to move   */
            {
            first_cycle = 0;                /* a. yes .. clear flag     */
            low_level = i;                  /* ..and save start point   */
            }

        if (NOT rev_fat[dest].r_target)     /* q. destination free?     */
            {
            w--;                            /* a. yes .. keep counter   */
            load_cluster(i, dest, 0, c++);  /* ..and queue data         */
            }
         else
            {
            if (i >= first_free)            /* q. going to be used?     */
                continue;                   /* a. no .. don't move      */

            if (free_avail &&               /* q. still have free?      */
                    (dest = find_free())    /* ..and find a free        */
                    != 0)                   /* ..block to move to?      */
                load_cluster(i, dest,       /* a. yes .. queue data     */
                        1, c++);
             else
                free_avail = 0;             /* else .. show no free     */
            }

        if (c_idx == c_max ||               /* q. out of buffers?       */
                NOT w)                      /* ..or out of work?        */
            break;                          /* a. yes .. exit loop      */
        }
    }
}



/* ******************************************************************** *
 *      load_cluster() -- read cluster into cluster buffer              *
 * ******************************************************************** */

void    load_cluster(UINT from,             /* source cluster number    */
                     UINT to,               /* destination cluster nbr  */
                     int  type,             /* 0 = final, 1 = temp      */
                     C_ARRAY huge *c)       /* cluster buffer entry     */
{
S_ENTRY huge *s;                            /* short dir entry          */


c->c_from = from;                           /* save source              */
c->c_to = to;                               /* ..and destination        */
c->c_type = type;                           /* ..and type               */
c->c_inuse = 1;                             /* ..and set inuse flag     */

if (type)                                   /* q. moving to temp area?  */
    {
    rev_fat[to].r_target                    /* a. yes .. set up as a    */
            = rev_fat[from].r_target;       /* ..temporary move         */
    rev_fat[to].r_diridx                    /* ..with origin's cluster's*/
            = rev_fat[from].r_diridx;       /* ..final destination info */
    }
 else
    rev_fat[to].r_target = 1;               /* else .. show perm locat'n*/

s = &s_entries[rev_fat[from].r_diridx];     /* get addr of dir entry    */

c->c_dir = (S_DIR(s)) ? s->s_dir            /* subdir use dir level     */
            : (s->s_data == from)           /* files use 0 if 1st clustr*/
            ? 0 : 0xff ;                    /* ..and 0xff if not        */

c_idx++;                                    /* bump cluster index       */

}



/* ******************************************************************** *
 *      multi_cluster() -- do multiple cluster read and writes          *
 * ******************************************************************** */

void    multi_cluster(int rw_flag)          /* read/write flag          */
{
int     i;                                  /* loop control             */
UINT    init,                               /* multi-cluster init flag  */
        count,                              /* clusters to read|write   */
        nbr;                                /* 1st of multi-cluster i/o */
HUGE    *b;                                 /* buffer pointer           */
C_ARRAY huge *c;                            /* cluster buffer entry     */


phase = 1 + rw_flag;                        /* set phase to read|write  */
init = 1;                                   /* ..and 1st time flag      */
update_progress();                          /* ..and set up user display*/

for (i = c_idx, c_idx = 0, c = c_array;     /* loop thru cluster buffers*/
        c_idx < i; c_idx++, c++)            /* ..reading/writing disk   */
    {
    keepalive(-1);                          /* update user twirly bar   */

    if (init)                               /* q. init needed?          */
        {
        init = 0;                           /* a. yes .. clear flag     */
        count = sec_cluster;                /* ..set minimum count      */
        nbr = rw_flag ? c->c_to : c->c_from;/* ..and 1st cluster number */
        b = c->c_buffer;                    /* ..and buffer address     */
        }

    if ((c_idx + 1) < i &&                  /* q. more entries later?   */
            (rw_flag ?                      /* ..and the next entry is  */
            (c->c_to + 1) == c[1].c_to :    /* ..immediately after the  */
            (c->c_from + 1) == c[1].c_from))/* ..current one?           */
        {
        count += sec_cluster;               /* a. yes .. bump count     */
        continue;                           /* ..and continue loop      */
        }

    if (disk_io(rw_flag,                    /* q. multi-cluster rd/wr   */
            logical_sector(nbr), count, b)) /* ..work ok?               */
        quit_with(read_error);              /* a. no .. give err msg    */

    init = 1;                               /* reset init needed flag   */
    }
}



/* ******************************************************************** *
 *      multi_update() -- handle multiple cluster updating              *
 * ******************************************************************** */

void    multi_update(void)
{
int     i, j;                               /* loop control             */
long    from_1, from_2, to_1, to_2;         /* invalidation ranges      */
C_ARRAY huge *c, huge *s;                   /* cluster buffer entry ptrs*/
L_ARRAY huge *l;                            /* lru cache entry pointer  */


phase = 3;                                  /* show world we're updating*/
update_progress();                          /* ..and redisplay line     */

for (i = 0, c = c_array; i < c_idx;         /* go thru cluster array and*/
            i++, c++)                       /* ..invalidate sector cache*/
    {
    from_1 = logical_sector(c->c_from);     /* set up from sector nbr   */
    from_2 = from_1 + sec_cluster;          /* ..and set up range       */

    to_1 = logical_sector(c->c_to);         /* set up to sector number  */
    to_2 = to_1 + sec_cluster;              /* ..and set up range       */

    for (j = 0, l = l_array; j < l_used;    /* now loop thru sector     */
            j++, l++)                       /* ..and invalidate sectors */
        {
        if ((l->l_number >= from_1 &&       /* q. cached sector just    */
                l->l_number <= from_2) ||   /* ..get moved in a cluster */
                (l->l_number >= to_1 &&     /* ..move?                  */
                l->l_number <= to_2))
            l->l_invalid = 1;               /* a. yes .. set invalid flg*/
        }
    }

for (i = 0, c = c_array; i < c_idx;         /* go thru cluster array and*/
            i++, c++)                       /* ..set up FAT pointers    */
    update_fat(c->c_to,                     /* chain in new entry       */
            get_next_fat(c->c_from));

critical_flag = 1;                          /* starting critical section*/
re_write_fat(0);                            /* rewrite chg'd FAT sectors*/

for (j = c_idx; j; j--)                     /* loop 'til all done       */
    {
    for (i = 0, c = c_array, s = 0;         /* loop thru cluster array  */
            i < c_idx; i++, c++)            /* ..updating FAT and dirs  */
        {
        if (c->c_inuse)                     /* q. entry inuse?          */
            {                               /* a. yes .. check it out   */
            if (NOT s ||                    /* q. haven't selected one? */
                    c->c_dir > s->c_dir)    /* ..or better one avail?   */
                s = c;                      /* a. yes .. use it         */
            }
        }

    move_cluster(s);                        /* update FAT and subdirs   */
    keepalive(-1);                          /* ..and the user too       */
    }

write_dirty();                              /* flush all subdir changes */
re_write_fat(0);                            /* rewrite chg'd FAT sectors*/

critical_flag = 0;                          /* show critical stuff done */

if (break_request)                          /* q. was a break requested?*/
    quit_with("");                          /* a. yes .. then quit      */

}



/* ******************************************************************** *
 *      move_cluster() -- move cluster to destination                   *
 * ******************************************************************** */

void    move_cluster(C_ARRAY huge *c)       /* cluster array entry      */
{
UINT    next_c,                             /* next cluster pointer     */
        prev_c;                             /* previous cluster in chain*/
S_ENTRY huge *s, huge *w;                   /* source short dir entry   */
D_ENTRY *d;                                 /* directory entry pointer  */


moved_count++;                              /* tally moved clusters     */
s = &s_entries[rev_fat[c->c_from].r_diridx];/* get our short dir entry  */

if (S_DIR(s))                               /* q. subdirectory entry?   */
    for (w = s; ++w < s_next &&             /* a. yes .. loop thru rest */
                s->s_dir < w->s_dir;)       /* ..of subordinate entries */
        {
        if (w->s_cluster == c->c_from)      /* q. rooted in current dir?*/
            w->s_cluster = c->c_to;         /* a. yes .. update dir ptr */

        if (s->s_data == c->c_from &&       /* q. moving 1st cluster of */
                S_DIR(w) &&                 /* ..parent dir and a subdir*/
                w->s_dir == (s->s_dir + 1)) /* ..and rooted in this dir?*/
            {
            d = (D_ENTRY *)                 /* get 1st cluster of subdir*/
                read_sector(w->s_data, 0);  /* ..then find 1st dir entry*/

            if (*(++d)->d_efile == '.')     /* q. find .. file?         */
                {
                d->d_ecluster = c->c_to;    /* a. yes .. setup new ptr  */
                dirty_sector();             /* ..show sector updated    */
                }
            }
        }

update_fat(c->c_to,                         /* rechain new entry in     */
            get_next_fat(c->c_from));       /* ..case old entry changed */

if (s->s_data == c->c_from)                 /* q. need to update dir?   */
    update_dir(s, c->c_to);                 /* a. yes .. point at "to"  */

 else
    {
    prev_c = s->s_data;                     /* get 1st FAT cluster nbr  */
    next_c = 0;                             /* ..and set up search      */

    while (1)                               /* loop thru FAT chain      */
        {
        if ((next_c = walk_fat(prev_c))     /* q. find previous entry   */
                    == c->c_from)           /* ..to the "from" cluster? */
            {
            update_fat(prev_c, c->c_to);    /* a. yes .. point at dest  */
            break;                          /* ..then exit from loop    */
            }
         else
            if (prev_c == next_c)           /* q. messed up FAT chain?  */
                quit_with(int_error);       /* a. yes .. quit quickly   */
             else
                prev_c = next_c;            /* set for next call        */
        }
    }

update_fat(c->c_from, 0);                   /* free old cluster         */
rev_fat[c->c_from].r_target = 0;            /* ..from all tables        */

if (c->c_type)                              /* q. temporary move?       */
    temp_moves++;                           /* a. yes .. tally another  */
 else
    remaining--;                            /* else .. decrement total  */

c->c_inuse = 0;                             /* clear inuse flag         */

}



/* ******************************************************************** *
 *      update_dir() -- fill FAT with new cluster nbr and write disk    *
 * ******************************************************************** */

void    update_dir(S_ENTRY huge *s,         /* short dir entry          */
                   UINT new)                /* new 1st cluster number   */
{
int     i;                                  /* loop control             */
D_ENTRY *d;                                 /* directory entry pointer  */
C_ARRAY huge *c;                            /* cluster buffer array ptr */


if (S_DIR(s))                               /* q. subdirectory entry?   */
    {                                       /* a. yes .. update the .\  */
    d = (D_ENTRY *) read_sector(new, 0);    /* get 1st cluster of subdir*/

    if (*d->d_efile == '.')                 /* q. find . file?          */
        {
        d->d_ecluster = new;                /* a. yes .. setup new ptr  */
        dirty_sector();                     /* ..show updated sector    */
        }

    if (s->s_cluster)                       /* q. rooted in root dir?   */
        for (i = 0, c = c_array;            /* a. no .. loop thru array */
                i < c_idx; i++, c++)        /* ..and see if parent moved*/
            if (c->c_from == s->s_cluster)  /* q. find parents cluster? */
                {
                s->s_cluster = c->c_to;     /* a. yes .. update table   */
                break;                      /* ..and exit loop          */
                }
    }

d = (D_ENTRY *)                             /* get directory sector     */
            read_sector(s->s_cluster,       /* ..for this file/subdir   */
            s->s_index);

d[s->s_index %                              /* ..update 1st cluster ptr */
            dir_sector].d_ecluster = new;   /* ..within directory entry */

dirty_sector();                             /* then flag as sector chg'd*/

s->s_data = new;                            /* update short dir entry   */

}



/* ******************************************************************** *
 *      update_fat() -- fill FAT with new cluster nbr                   *
 * ******************************************************************** */

void    update_fat(UINT cluster,            /* cluster number           */
                   UINT new)                /* new pointer number       */
{
UINT    huge *p,                            /* work pointer             */
        s_offset,                           /* sector offset into fat   */
        length;                             /* sectors to update        */
long    c_offset;                           /* character offset         */


if (fat_16)                                 /* q. 16 bit FAT entries?   */
    {
    p = &((UINT huge *) fat)[cluster];      /* a. yes .. get FAT addr   */
    *p = new;                               /* store new next pointer   */
    }

 else
    {
    p = (UINT huge *) &fat[((cluster << 1)  /* get address of cluster   */
            + cluster) >> 1];               /* ..entry requested        */

    if (cluster & 1)                        /* q. need to do shift?     */
        {
        *p &= 0x000f;                       /* a. yes .. clear old entry*/
        *p |= (new << 4);                   /* ..shift and "or" in value*/
        }
     else
        {
        *p &= 0xf000;                       /* just clear old entry     */
        *p |= new;                          /* ..and "or" in new value  */
        }
    }

if (new)                                    /* q. putting cluster inuse?*/
    bit_on(in_use, cluster);                /* a. yes .. set bit on     */
 else
    bit_off(in_use, cluster);               /* else .. set bit entry off*/

c_offset = ((HUGE *) p - (HUGE *) &fat[0]); /* byte offset into FAT and */
s_offset = (UINT) (c_offset / bytes_sector);/* ..sector offset in FAT   */

length = ((c_offset % bytes_sector)         /* nbr of sectors to write  */
            == (bytes_sector - 1)) ? 2 : 1; /* ..for 12bit FATs         */

for (; length--;)                           /* loop thru and flag all   */
    fat_flag[s_offset++] = 1;               /* ..fat sectors to re-write*/

}



/* ******************************************************************** *
 *      re_write_fat() -- update changed FAT sectors                    *
 * ******************************************************************** */

void    re_write_fat(int flag)              /* TRUE = re-write all FATs */
{
UINT    i,                                  /* work variable            */
        init,                               /* multi-cluster init flag  */
        count,                              /* clusters to read|write   */
        nbr;                                /* 1st of multi-cluster i/o */
char   *p;                                  /* flag pointer             */
long    fs;                                 /* FAT starting sector      */
HUGE    *b;                                 /* buffer pointer           */


fs = BOOT->res_sectors;                     /* 1st FAT sector number    */

if (flag)                                   /* q. write them all?       */
    {
    for (i = 0; i < BOOT->fats;             /* a. yes .. set up for ..  */
                i++, fs += BOOT->fatsize)   /* ..write of all FATs      */
        if (disk_io(1, fs, BOOT->fatsize,   /* q. write ok for new      */
                        fat))               /* ..copy of the FAT?       */
            quit_with(fat_error);           /* a. no .. give error msg  */
    }
 else
    for (i = 0, p = fat_flag, init = 1;     /* else .. rewrite changed  */
                i < BOOT->fatsize; i++, p++)/* ..FAT sectors only       */
        {
        if (*p)                             /* q. sector need writing?  */
            {                               /* a. yes .. check for a run*/
            *p = 0;                         /* clear FAT sector flag    */

            if (init)                       /* q. init needed?          */
                {
                init = 0;                   /* a. yes .. clear flag     */
                count = 1;                  /* ..set count              */
                nbr = i;                    /* ..and 1st sector number  */
                b = &fat[i * bytes_sector]; /* ..and buffer address     */
                }
             else
                count++;                    /* else .. just bump count  */

            if ((i + 1) < BOOT->fatsize)    /* q. more sectors in table?*/
                continue;                   /* a. yes .. continue       */
            }

        if (NOT init)                       /* q. started to set up?    */
            {                               /* a. yes .. write a bunch  */
            init = 1;                       /* reset flag               */

            if (disk_io(1, fs + nbr,        /* q. write FAT ok?         */
                        count, b))
                quit_with(fat_error);       /* a. no .. give error msg  */
            }
        }
}



/* ******************************************************************** *
 *      update_progress() -- update progress of defrag                  *
 * ******************************************************************** */

void    update_progress(void)
{
UINT    moved;                              /* total moved              */
float   pct;                                /* percentage complete      */


keepalive(-1);                              /* keep user informed       */

if (sw_quiet)                               /* q. quiet mode?           */
    return;                                 /* a. yes .. just return    */

moved = i_remain - remaining;               /* total clusters moved     */
pct = ((float) moved / i_remain) * 100.;    /* calculate percentage done*/

printf(working, graph_string((long) moved,  /* display crude completion */
            (long) i_remain), pct,          /* ..graph of done and not  */
            moved, temp_moves,              /* ..done, and percent done */
            phase_desc[phase]);             /* ..and clusters moved     */

}



/* ******************************************************************** *
 *      find_free() -- find a free cluster                              *
 * ******************************************************************** */

UINT    find_free(void)
{
UINT    i, j;                               /* loop control             */
REV_FAT huge *p, huge *q;                   /* reverse fat pointer      */
char   *s;                                  /* work string pointer      */


i = (first_free / 8) * 8;                   /* starting w/1st available */
p = &rev_fat[i],                            /* ..cluster above the free */
s = &in_use[i / 8];                         /* ..cluster line           */

for (; i < max_cluster;                     /* loop thru to find the    */
            i += 8, p += 8, s++)            /* ..first available cluster*/
    if ((unsigned char) *s != 0xff)         /* q. find free one or two? */
        {
        for (j = 0, q = p; j < 8; j++, q++) /* a. yes .. now which bit  */
            if (NOT bit_check(s, j) &&      /* q. this bit off?         */
                    q->r_target == 0)       /* ..and unwanted?          */
                break;                      /* a. yes .. exit loop      */

        if (j < 8)                          /* q. find one?             */
            {
            i += j;                         /* a. yes .. update index   */
            return((i < max_cluster)        /* return w/cluster or zero */
                    ? i : 0);
            }
        }

return(0);                                  /* when all else fails..    */

}



/* ******************************************************************** *
 *      to_be_moved() -- count clusters yet to be moved                 *
 * ******************************************************************** */

UINT    to_be_moved(void)
{
UINT    counter = 0,                        /* accumulator              */
        i;                                  /* loop control             */
REV_FAT huge *p = rev_fat;                  /* reverse fat pointer      */


for (i = 0; i <= max_cluster; i++, p++)     /* loop thru reverse fat..  */
    if (p->r_target > 1)                    /* q. still to be moved?    */
        counter++;                          /* a. yes .. count it       */

return(counter);                            /* return to be moved count */

}



/* ******************************************************************** *
 *      get_next_fat() -- get the next FAT entry in chain               *
 * ******************************************************************** */

UINT    get_next_fat(UINT n)                /* cluster number           */
{
UINT    nc;                                 /* next cluster number      */


if (fat_16)                                 /* q. 16 bit FAT entries?   */
    nc = ((UINT huge *) fat)[n];            /* a. yes .. get FAT entry  */

 else
    {
    nc = *(UINT huge *)                     /* get raw next cluster nbr */
            &fat[((n << 1) + n) >> 1];

    if (n & 1)                              /* q. need to do shift?     */
        nc >>= 4;                           /* a. yes .. shift by 4 bits*/
     else
        nc &= 0x0fff;                       /* else .. strip upper bits */

    }

return(nc);                                 /* return w/next cluster nbr*/

}



/* ******************************************************************** *
 *      check_cluster() -- check for valid cluster number               *
 * ******************************************************************** */

int     check_cluster(UINT nc)              /* cluster number           */
{


if (nc == 1)                                /* q. invalid cluster?      */
    walk_rc = 0;                            /* a. yes .. show in rtn cd */

 else if (nc == 0)                          /* q. free cluster?         */
    walk_rc = 2;                            /* a. yes .. mark free      */

 else if (nc <= max_cluster)                /* q. allocated cluster?    */
    walk_rc = 3;                            /* a. yes .. show allocated */

 else if (nc == bad_cluster)                /* q. bad cluster?          */
    walk_rc = 5;                            /* a. yes .. show status    */

 else if (nc > bad_cluster)                 /* q. EOF cluster?          */
    walk_rc = 4;                            /* else .. set up as EOF    */

 else                                       /* else ..                  */
    walk_rc = 0;                            /* ..cluster nbr is invalid */


return(walk_rc);                            /* return w/error code      */

}



/* ******************************************************************** *
 *      walk_fat() -- get next cluster in FAT chain                     *
 * ******************************************************************** */

UINT    walk_fat(UINT n)                    /* current cluster number   */
                                            /* walk_rc set as follows   */
                                            /*  0 = invalid cluster nbr */
                                            /*  2 = free                */
                                            /*  3 = allocated           */
                                            /*  4 = last in chain       */
                                            /*  5 = bad cluster         */
{
UINT    nc;                                 /* next cluster value       */


if (NOT n || (n > max_cluster))             /* q. invalid cluster nbr?  */
    {
    walk_rc = 0;                            /* a. yes .. set up return  */
    return(0);                              /* ..code and rtn to caller */
    }

nc = get_next_fat(n);                       /* get next entry in chain  */

return(check_cluster(nc) == 3 ? nc : 0);    /* return w/next cluster    */
                                            /* ..or zero for error      */

}



/* ******************************************************************** *
 *      bit_on() -- turn a bit in a bit array on                        *
 * ******************************************************************** */

int     bit_on(char *s,                     /* string of bits           */
               UINT n)                      /* entry number to turn on  */
{

s += (n / 8);                               /* get to proper byte       */
n %= 8;                                     /* ..and idx for proper bit */

if (*s & bits[n])                           /* q. bit already on?       */
    return(1);                              /* a. yes .. return TRUE    */

*s |= bits[n];                              /* show we've been here     */
return(0);                                  /* ..and return bit was off */

}



/* ******************************************************************** *
 *      bit_off() -- turn a bit in a bit array off                      *
 * ******************************************************************** */

void    bit_off(char *s,                    /* string of bits           */
                UINT n)                     /* entry number to turn on  */
{

s += (n / 8);                               /* get to proper byte       */
*s &= ~bits[n % 8];                         /* clear bit entry          */

}



/* ******************************************************************** *
 *      bit_check() -- check if bit turn a bit in a bit array off                      *
 * ******************************************************************** */

int     bit_check(char *s,                  /* string of bits           */
                  UINT n)                   /* entry number to turn on  */
{

s += (n / 8);                               /* get to proper byte       */
return(*s & bits[n % 8]);                   /* return w/status of bit   */

}



/* ******************************************************************** *
 *      check_fat() -- check FAT for cross-linked clusters              *
 * ******************************************************************** */

void    check_fat(void)
{
UINT    c;                                  /* cluster number           */
S_ENTRY huge *s;                            /* short dir entry pointer  */


for (s = s_entries; s < s_next; s++)        /* loop thru short directory*/
    {
    if (check_cluster(c = s->s_data) != 3)  /* q. 1st cluster nbr valid?*/
        quit_with(bad_fat, fat_err[2]);     /* a. yes .. quit here      */

    for (; c;)                              /* walk this entries FAT    */
        {
        if (bit_on(in_use, c))              /* q. bit already on?       */
            quit_with(bad_fat, fat_err[0]); /* a. yes .. must be error  */

        c = walk_fat(c);                    /* get next file allocation */

        if (walk_rc == 0)                   /* q. invalid fat pointer?  */
            quit_with(bad_fat, fat_err[1]); /* a. yes .. quit here      */
        }
    }

for (c = 2; c <= max_cluster; c++)          /* walk thru FAT ..         */
    {
    walk_fat(c);                            /* get next file allocation */

    if (walk_rc == 5)                       /* q. bad cluster?          */
        {
        rev_fat[c].r_target = 1;            /* a. yes .. mark unmovable */
        bit_on(in_use, c);                  /* ..and set bit in FAT     */
        }
     else if (walk_rc != 2)                 /* q. not free?             */
        {                                   /* a. no .. part of a file? */
        if (NOT bit_check(in_use, c))       /* q. lost cluster?         */
            quit_with(bad_fat, fat_err[3]); /* a. yes .. quit w/err msg */
        }
    }

}



/* ******************************************************************** *
 *      pack_name() -- build a filename from an FCB                     *
 * ******************************************************************** */

char    *pack_name(char *name)              /* dir entry name field     */
{
int     i;                                  /* loop control             */
char    *p, *q;                             /* work pointers            */
static
char    work[13];                           /* returned work area       */


if (NOT name)                               /* q. root directory entry? */
    return("");                             /* a. yes .. then a null str*/

p = work;                                   /* initialize string pointer*/
q = name;                                   /* ..and filename pointer   */

for (i = 0; (i < 8) && (*q != ' '); i++)    /* move fname w/o blanks*/
    *p++ = *q++;

q = &name[8];                               /* get to extension         */

if (*q != ' ')                              /* q. extension blank?      */
    {
    *p++ = '.';                             /* a. no .. add the dot     */

    for (i = 0; (i < 3) && (*q != ' '); i++)/* add extension w/o blanks */
        *p++ = *q++;
    }

*p = 0;                                     /* terminate string w/null  */
return(work);                               /* return string to caller  */

}



/* ******************************************************************** *
 *      read_label() -- get the volume 's label, if available           *
 * ******************************************************************** */

char    *read_label(void)
{
char    *p, *q;                             /* work pointers            */
struct  find_t dir;                         /* directory entry          */
struct  media_id media;                     /* media id block           */
static
char    work[33] = { " :\\*.*" } ;          /* directory to check       */


work[0] = drive[0];                         /* set up for search string */

if (_osmajor == 2)                          /* q. DOS 2.x?               */
   return("");                              /* a. yes .. just return     */

if (_dos_findfirst(work, _A_VOLID, &dir))   /* q. error on label get?   */
    work[0] = 0;                            /* a. yes .. then no label  */

 else
    {
    for(p = work, q = dir.name; *q; q++)    /* copy name w/o middle dot */
        if (*q != '.')                      /* q. is this char a dot?   */
            *p++ = *q;                      /* a. no .. copy it         */

    *p = 0;                                 /* make null terminated and */
    strcat(work, "  ");                     /* ..ready for serial number*/
    }


if (_osmajor >= 4)                          /* q. serial nbr available? */
    {
    media.info_level = 0;                   /* a. maybe .. set up call  */
    r.x.bx = drive_nbr;                     /* set up drive number..    */
    r.x.cx = 0x866;                         /* ..sub function code      */
    s.ds   = FP_SEG(&media);                /* ..work area segment      */
    r.x.dx = FP_OFF(&media);                /* ..and offset pointers    */
    r.x.ax = 0x440d;                        /* ..lastly function code   */
    int86x(0x21, &r, &r, &s);               /* issue dos call           */

    if (NOT r.x.cflag)                      /* q. complete ok?          */
        sprintf(&work[strlen(work)],        /* a. yes .. format into msg*/
            serial_nbr, media.serial2,
            media.serial1);
    }

return(work);                               /* ..return string          */

}



/* ******************************************************************** *
 *      quit_with() -- give an error message, then return to DOS        *
 * ******************************************************************** */

void    quit_with(char *msg, ...)           /* string to print          */
{
va_list list;                               /* variable list            */
UINT    i;                                  /* work variable            */


if (fat_write)                              /* q. need to write out FAT?*/
    {
    fat_write = 0;                          /* a. yes .. clear flag 1st */
    re_write_fat(1);                        /* ..and write the FATs     */
    }

r.h.ah = 0xd;                               /* ah = reset drive         */
int86(0x21, &r, &r);                        /* issue DOS call           */

_dos_setdrive(init_drive, &i);              /* reset the default drive  */

if (init_path)                              /* q. init path captured?   */
    {
    chdir(drive);                           /* a. yes .. backup to root */
    chdir(init_path);                       /* ..then restore it        */
    }

va_start(list, msg);                        /* set up variable list     */
vprintf(msg, list);                         /* give error message ..    */
exit(rc);                                   /* ..and then quit          */

}



/* ******************************************************************** *
 *      keepalive() -- put out a keepalive blip to the user             *
 * ******************************************************************** */

void    keepalive(int flag)                 /* -1 = next blip, no kbhit */
                                            /* 0  = put out next blip   */
                                            /* 1  = clean up blips      */
{
static
UINT    b_cnt = 0,                          /* blip counter             */
        b_call = 0,                         /* raw counter              */
        far *timer = MK_FP(0x40, 0x6c);     /* BIOS timer tick counter  */
static
char    blips[] = "|/-\\",                  /* progress blips           */
        blip_fmt[]     = "%c\b",            /* message format           */
        blip_clean[]   = " \b";             /* clean up message         */


if (flag == 1)                              /* q. clean up call?        */
    {
    fprintf(stderr, blip_clean);            /* a. yes .. erase blip..   */
    b_call = 0;                             /* ..and reset counter      */
    }

 else
    if (b_call < *timer)                    /* q. timer expire?         */
        {
        b_call = *timer + 6;                /* a. yes .. set nxt timeout*/

        fprintf(stderr, blip_fmt,           /* put out next spoke on the*/
            blips[b_cnt++ & 3]);            /* ..simulated wheel        */

        if (flag == 0)                      /* q. ok to do check status?*/
            kbhit();                        /* a. yes .. check keyboard */
        }
}



/* ******************************************************************** *
 *      parse_parms() -- parse command line parms                       *
 * ******************************************************************** */

int     parse_parms(int  ac,                /* argument count           */
                    char *av[],             /* command line arguments   */
                    int  n,                 /* parse table entries      */
                    struct cmd_parm *t,     /* cmd line parse table     */
                    char ***parms_array)    /* positional parms array   */
{
int     i, j,                               /* loop counter             */
        parms_fnd = 0,                      /* positional parms found   */
        slash_fnd = 0;                      /* slash found in token     */
char    *p, *q,                             /* character pointer        */
        c;                                  /* work character           */


*parms_array = (char **) huge_malloc(       /* set up for max nbr tokens*/
            sizeof(char *) * ac);

for (i = 1; i < ac; i++)                    /* for each cmd line token  */
    {
    p = av[i];                              /* set up pointer to token  */

    while (*p)                              /* process token            */
        {
        if (*p == '/' || slash_fnd)         /* q. option?               */
            {
            if (NOT slash_fnd)              /* q. embedded slash?       */
                p++;                        /* a. no .. bump past slash */

            c = toupper(*p);                /* get char and upcase it   */
            slash_fnd = 0;                  /* reset switch             */

            if (c == '?')                   /* q. help request?         */
                quit_with(help);            /* a. yes .. give help ..   */

            for (j = 0; j < n; j++)         /* check each table entry   */
                if (c == t[j].cp_ltr)       /* q. find match?           */
                    break;                  /* a. yes .. exit loop      */

            if (j == n)                     /* q. no matches?           */
                {
                if ((q = strchr(p, '/'))    /* q. any more switches?    */
                         != 0)
                    *q = 0;                 /* a. yes .. isolate bad one*/

                quit_with(bad_op, --p);     /* give error message & quit*/
                }

            if (t[j].cp_flag)               /* q. keyword parm w/data?  */
                {
                *(char **) t[j].cp_entry = ++p; /* a. yes .. save token */

                if (*(p += strcspn(p, "/")))/* q. any switches left?    */
                    {
                    *p++ = 0;               /* a. yes .. make a string  */
                    slash_fnd = 1;          /* ..show nxt char a switch */
                    }
                }

             else
                {
                (*t[j].cp_entry)++;         /* show slash parm used     */
                p++;                        /* ..and point at next one  */
                }
            }
         else
            {
            (*parms_array)[parms_fnd++] = p;/* save positional string   */

            if (*(p += strcspn(p, "/")))    /* q. any switches left?    */
                {
                *p++ = 0;                   /* a. yes .. make a string  */
                slash_fnd = 1;              /* ..show nxt char a switch */
                }
            }
        }
    }

*parms_array = (char **) farrealloc(        /* readjust array size      */
            *parms_array,                   /* ..for what was found     */
            sizeof(char *) * parms_fnd);

return(parms_fnd);                          /* rtn w/nbr of positionals */

}



/* ******************************************************************** *
 *      large_fmt() -- handle formatting of disk storage numbers        *
 * ******************************************************************** */

char    *large_fmt(unsigned long nbr,       /* number to be converted   */
                   char *s)                 /* destination string or 0  */
{
int     g_flag = 0;                         /* gigabyte range flag      */
static
char    work[10];                           /* return string            */


if (s == 0)                                 /* q. sent a null pointer?  */
    s = work;                               /* a. yes .. use our own    */

if (nbr < 1000)                             /* q. less than 1k?         */
    sprintf(s, "%u bytes", nbr);            /* a. yes .. then use bytes */

 else
    {
    nbr /= 1000;                            /* make number in kilobytes */

    if (nbr < 1000)                         /* q. only in the kb range? */
        sprintf(s, "%ukb", nbr);            /* a. yes .. format as kb   */

     else
        {
        nbr /= 100;                         /* get mb or gb w/1 decimal */

        if (nbr > 10000)                    /* q. gigabyte range?       */
            {
            g_flag++;                       /* a. yes .. show as gb     */
            nbr /= 1000;                    /* ..and make in gigabytes  */
            }

        sprintf(s, "%lu.%lu%s",             /* format number            */
            nbr / 10, nbr % 10,
            g_flag ? "gb" : "mb");
        }
    }

return(s);                                  /* then give user the result*/

}



/* ******************************************************************** *
 *      huge_malloc() -- local malloc w/error handling                  *
 * ******************************************************************** */

void    *huge_malloc(long size)             /* amount of memory to get  */
{
void    *p;                                 /* temporary pointer        */


if (NOT (p = (void *) _fmalloc(size)))      /* q. enough memory?        */
    quit_with(no_mem, size);                /* a. no .. give error msg  */

return(p);                                  /* else .. return w/address */

}



/* ******************************************************************** *
 *      read_sector() -- read one directory sector                      *
 * ******************************************************************** */

void   *read_sector(UINT cluster,           /* cluster number           */
                    UINT entry_nbr)         /* directory entry nbr      */
{
int     i;                                  /* loop control             */
long    work;                               /* work area                */
L_ARRAY huge *l_old;                        /* work pointer for lru bufs*/


work = logical_sector(cluster)              /* determine sector to read */
            + entry_nbr / dir_sector;       /* ..this time around       */

if (NOT l_max)                              /* q. before allocation?    */
    {                                       /* a. yes .. use only one   */
    if (disk_io(0, work, 1, disk_buffer))   /* q. read a dir sector ok? */
        quit_with(dir_read);                /* a. no .. quit w/err msg  */

    return(disk_buffer);                    /* else .. return w/buffer  */
    }

for (i = 0, l_ptr = l_old = l_array;        /* loop thru available buf  */
            i < l_used; i++, l_ptr++)       /* ..pool for a used one    */
    {
    if (l_ptr->l_number == work)            /* q. find a used buffer?   */
        {                                   /* a. yes .. check it out   */
        if (l_ptr->l_invalid == 0)          /* q. still valid?          */
            break;                          /* a. yes .. continue       */
         else
            {
            if (disk_io(0, work, 1,         /* q. read sector ok?       */
                    l_ptr->l_buffer))
                quit_with(dir_read);        /* a. no .. quit w/err msg  */

            l_ptr->l_invalid = 0;           /* show buffer valid again  */
            break;                          /* ..finally exit loop      */
            }
        }

    if (l_old->l_time > l_ptr->l_time)      /* q. older buffer?         */
        l_old = l_ptr;                      /* a. yes .. save its addr  */
    }

if (i == l_used)                            /* q. need to pick a new 1? */
    {                                       /* a. yes .. all used yet?  */
    if (l_used < l_max)                     /* q. used all one time?    */
        l_used++;                           /* a. no .. used next one   */
     else
        {
        l_ptr = l_old;                      /* else .. just use oldest  */
        l_recycle++;                        /* ..and count as a recycle */

        if (l_ptr->l_dirt)                  /* q. dirty?                */
            {
            write_sector();                 /* a. yes .. then write it  */
            l_forces++;                     /* ..and count forced writes*/
            }
        }

    l_ptr->l_number = work;                 /* save new sector number   */
    l_ptr->l_invalid = 0;                   /* ..and clear invalid bit  */

    if (disk_io(0, work, 1,                 /* q. read sector ok?       */
            l_ptr->l_buffer))
        quit_with(dir_read);                /* a. no .. quit w/err msg  */
    }

 else
    l_hits++;                               /* tally a cache hit        */

l_ptr->l_time = timer_count();              /* save current time        */
return(l_ptr->l_buffer);                    /* finally, rtn w/the goods */

}



/* ******************************************************************** *
 *      write_sector() -- write one directory sector                    *
 * ******************************************************************** */

void    write_sector(void)
{


if (disk_io(1, l_ptr->l_number,             /* q. write the dir sector  */
            1, l_ptr->l_buffer))            /* ..back ok?               */
    quit_with(dir_read);                    /* a. no .. quit w/err msg  */

l_ptr->l_dirt = 0;                          /* clear dirty flag         */

}



/* ******************************************************************** *
 *      dirty_sector() -- flag current sector as dirty                  *
 * ******************************************************************** */

void    dirty_sector(void)
{


l_ptr->l_dirt = 1;                          /* set dirty flag           */

}



/* ******************************************************************** *
 *      write_dirty() -- write outstanding buffers                      *
 * ******************************************************************** */

void    write_dirty(void)
{
int     i;                                  /* loop control             */


for (i = 0, l_ptr = l_array;                /* loop thru available buf  */
            i < l_used; i++, l_ptr++)       /* ..pool for a used one    */
    if (l_ptr->l_dirt &&                    /* q. dirty?                */
            NOT l_ptr->l_invalid)           /* ..and not invalid        */
        write_sector();                     /* a. yes .. then write it  */
     else
        l_ptr->l_dirt = 0;                  /* else .. clear dirty flag */

}



/* ******************************************************************** *
 *      logical_sector() -- convert cluster number to sector number     *
 * ******************************************************************** */

long    logical_sector(UINT cluster)        /* cluster number           */
{

return(cluster ? ((long)(cluster - 2) *     /* convert cluster to sector*/
            sec_cluster) + data_sector      /* ..for regular clusters   */
            : root_sector);                 /* or give root dir sector  */

}



/* ******************************************************************** *
 *      disk_io() -- absolute disk read/write by sector                 *
 * ******************************************************************** */

int     disk_io(int  rw_flag,               /* read/write flag,         */
                                            /*   0=read, 1=write        */
                long start,                 /* starting sector number   */
                int  count,                 /* count of sectors         */
                HUGE *buffer)               /* disk buffer              */
{
UINT    read_secs;                          /* nbr sectors this read    */
struct  dos_i25 d_i25;                      /* dos interrupt 25/26 blk  */


if (sw_dos)                                 /* q. can we read lots?     */
    {                                       /* a. yes .. set up loop    */
    while (count)                           /* do until count expired   */
        {
        r.x.cx = -1;                        /* cx = 0xffff, alt method  */

        d_i25.sector = start;               /* next sector number       */
        d_i25.read_addr = buffer;           /* ..and disk buffer        */

        count -=                            /* size of next read ...    */
            (d_i25.num_secs =               /* ..size of this read      */
                   min(max_secs, count));   /* ..smaller of max, num    */

        start += d_i25.num_secs;            /* next sector nbr          */
        buffer += (long) d_i25.num_secs *   /* ..buffer address         */
                        bytes_sector;

        r.x.bx = FP_OFF(&d_i25);            /* bx = offset of parm block*/
        s.ds   = FP_SEG(&d_i25);            /* ds = segment of block    */
        r.h.al = drive_nbr - 1;             /* al = drive number        */

        int86x(0x25 + rw_flag, &r, &r, &s); /* read/write disk          */
        }
    }

 else
    {
    while (count)
        {
        read_secs = min(max_secs, count);   /* update remaining count   */

        r.x.cx = read_secs;                 /* cx = number of sectors   */
        r.x.dx = (UINT) start;              /* dx = starting sector     */
        r.x.bx = FP_OFF(buffer);            /* bx = offset of buffer    */
        s.ds   = FP_SEG(buffer);            /* ds = segment of buffer   */

        count -= read_secs;                 /* down count on sectors    */
        start += read_secs;                 /* up count on sector nbr   */
        buffer += read_secs * bytes_sector; /* ..and buffer address     */
        r.h.al = drive_nbr - 1;             /* al = drive number        */
        int86x(0x25 + rw_flag, &r, &r, &s); /* read/write disk          */
        }
    }

return(r.x.cflag);                          /* return TRUE for error    */

}



/* ******************************************************************** *
 *      win_test() -- check if Windows up and running                   *
 * ******************************************************************** */

int     win_test(void)                      /* rtn TRUE if Windows up   */
{


r.x.ax = 0x1600;                            /* ax = enhanced mode check */
int86(0x2f, &r, &r);                        /* issue multiplex call     */

if (r.h.al != 0 && r.h.al != 0x80)          /* q. enhanced mode?        */
    return(1);                              /* a. yes .. return TRUE    */

r.x.ax = 0x4680;                            /* ax = std/real mode check */
int86(0x2f, &r, &r);                        /* issue multiplex call     */

return(r.x.ax == 0);                        /* rtn TRUE if in std/real  */

}



/* ******************************************************************** *
 *      clear_memory() -- initialize big blocks to zero                 *
 * ******************************************************************** */

void    clear_memory(HUGE *cp,              /* area to clear            */
                     long size)             /* length                   */
{
long    clr_size = 0;                       /* max size per pass        */


for (; size; size -= clr_size)              /* clear in big chunks      */
    {
    clr_size = min(size, (65536L - 16));    /* clear some of the block  */

    memset((char *) cp, 0, (UINT) clr_size);/* clear to block to null   */
    cp += clr_size;                         /* point to next block      */
    }
}



/* ******************************************************************** *
 *      timer_count() -- get current tick count                         *
 * ******************************************************************** */

long    timer_count(void)
{
static
long    far *timer = MK_FP(0x40, 0x6c),     /* BIOS timer tick counter  */
        start = -1,                         /* start tick count         */
        last = 0,                           /* last time gotten         */
        midnight = 0;                       /* midnight offset amount   */


if (start == -1)                            /* q. first call?           */
    {
    last = start = *timer;                  /* a. yes .. get start cnts */
    return(0);                              /* ..and return zero        */
    }

if (last > *timer)                          /* q. pass midnight?        */
    midnight += 1573041L;                   /* a. yes .. adjust counter */

last = *timer;                              /* get current tick count   */
return(last - start + midnight);            /* ..and rtn elapsed ticks  */

}



/* ******************************************************************** *
 *      translate_name() -- translate a DOS directory name              *
 * ******************************************************************** */

char    *translate_name(char *name)         /* name to translate        */
{
static
char    work[65];                           /* work/return area         */


r.h.ah = 0x60;                              /* ah = translate           */
r.x.si = FP_OFF(name);                      /* set ptr to input name    */
s.ds = FP_SEG(name);                        /* ..and segment            */
r.x.di = FP_OFF(work);                      /* set ptr to output area   */
s.es = FP_SEG(work);                        /* ..and segment            */
int86x(0x21, &r, &r, &s);                   /* translate the name       */

return(r.x.cflag ? NULL : work);            /* return workarea or null  */

}



/* ******************************************************************** *
 *      user_report() -- give user final report                         *
 * ******************************************************************** */

void    user_report(void)
{
long    m_secs,                             /* movement time in seconds */
        e_mins, e_secs;                     /* elapsed time             */
char    s[10];                              /* work string              */


m_secs = ((timer_count() - init_count)      /* elapsed re-org time      */
            * 10.) / 182.;

if (NOT m_secs)                             /* q. zero seconds?         */
    m_secs = 1;                             /* a. yes .. force one sec  */

init_count = (timer_count() * 10.) / 182.;  /* total elapsed time in sec*/
e_secs = init_count % 60;                   /* peel off just seconds    */
e_mins = init_count / 60;                   /* ..and just minutes       */
rc = 0;                                     /* show successful operation*/

large_fmt( ((moved_count * cluster_size)    /* calculate bytes/sec      */
            / m_secs), s);

if (moved_count)                            /* q. anything done?        */
    quit_with(all_done,                     /* a. yes .. give summary   */
        l_used, l_hits, l_recycle,          /* ..cache statistics       */
        l_forces, moved_count,              /* ..total clusters moved   */
        ((float) moved_count / m_secs),     /* ..avg moved rate         */
        s,                                  /* ..also in bytes/sec      */
        (int)(e_mins / 60),                 /* ..and elapsed time       */
        (int)(e_mins % 60), (int)(e_secs)); /* ..in hours, mins, & sec  */
 else
    quit_with(all_ok);                      /* else .. give no work msg */

}



/* ******************************************************************** *
 *      join_path() -- join a path and filespec together                *
 * ******************************************************************** */

char    *join_path(char *path,              /* path name                */
                   char *filespec)          /* ..and filespec           */
{
static
char    out_string[MAX_PATH];               /* output string            */


sprintf(out_string, "%s%s%s", path,         /* format output string     */
            LAST(path) == '\\' ? "" : "\\",
            filespec);

return(out_string);                         /* return w/concat'd string */

}



/* ******************************************************************** *
 *      graph_string() -- build graph string to show progress           *
 * ******************************************************************** */

char   *graph_string(long w,                /* number to show           */
                     long max)              /* max to graph n against   */
{
UINT    n,                                  /* not done count of blocks */
        d;                                  /* done count of blocks     */
char    p;                                  /* work pointer             */
static
char    mask[] = "%-*.*s%c%*.*s",           /* format string            */
        s[17];                              /* return work area         */


w <<= 6;                                    /* scale number up by 64    */
d = (int) (w / max);                        /* determine 64ths not done */
p = block_3[w ? d & 3 : 4];                 /* pick up last block type  */
d >>= 2;                                    /* scale back to 16ths      */
d = min(d, 15);                             /* limit length of string   */
n = 15 - d;                                 /* determine len of not done*/

sprintf(s, mask, d, d, block_1,             /* build crude graph to     */
            p, n, n, block_2);              /* ..show relative progress */

return(s);                                  /* finally return the string*/

}



/* ******************************************************************** *
 *      control_break() -- control break intercept routine              *
 * ******************************************************************** */

int     control_break(void)
{


rc = 0;                                     /* clear return code        */

if (critical_flag)                          /* q. interruptible?        */
    {                                       /* a. no, but handle anyway */
    if (++break_request == 1)               /* q. first time?           */
        printf(stop_here);                  /* a. yes .. give message   */

    return(1);                              /* ..then return & continue */
    }

quit_with(stop_here);                       /* quit with abort msg      */
return(0);                                  /* ..then return            */

}



/* ******************************************************************** *
 *      critical_handler() -- DOS critical error handler                *
 * ******************************************************************** */

#pragma argsused                    /* hold unused argument messages    */
#pragma option -O2-b-e              /* no global register allocation    */
                                    /* ..or dead code elimination       */

void    interrupt critical_handler(INT_PARMS)
{


if (ax & 0x800)                             /* q. fail allowed?         */
   ax = (ax & 0xff00) | 3;                  /* a. yes .. fail request   */
else
   ax = (ax & 0xff00) | 2;                  /* else .. abort request    */

}
