@ECHO OFF
REM WITH.BAT
:* Initialization done?  If yes, go to count.
IF '%!%'=='%0' GOTO Count
:* Any command present on command line?  If not, give error.
IF '%4'==''    GOTO syntax
:* In secondary command processor?  If yes, do initialize.
:* Else start secondary processor.
IF '%1'=='*'   GOTO Init
:* Store command and its parameters to temporary file $.BAT
ECHO %4 %5 %6 %7 %8 %9 > $.BAT
:* Load secondary command processor and re-invoke this batch file, so
:* that all e-vars and recursion stack are cleared upon termination.
:* Param * (asterisk) causes jump to label Init on re-invocation.
%COMSPEC% /c %0 * %1 %2 %3 
:* Delete the temporary file $.BAT
DEL $.BAT
GOTO end

:===== Init ========
:* Initialize environment variables.  Note: Previous re-invocation of
:* batch file using * (asterisk) as the 1st param has pushed ename,
:* m and n parameters into the 2nd, 3rd, and 4th parameter slots.
:* Set e-var & (ampersand) to param 4 (stop count) plus ampersand.
SET &=%4&
:* Set e-var n$ to param 4 (stop count).
SET n$=%4
:* Set e-var m$ to param 3 (start count).
SET m$=%3
:* Set e-var # (number sign) to param 2 (counter variable).
SET #=%2
:* Set e-var ! (exclamation point) to name of this batch file.
SET !=%0
:* Leading 0? If leftmost digit of m$ (start ct) = 0 but m$ not = 0,
:* set @ (leading zero flag) to 0.
IF NOT '%m$%'=='0' FOR %%a IN (/%m$%z) DO IF '%%a'=='0' SET @=0
:* Re-invoke WITH w/o params - this time it jumps to label Count.
%!%

:===== Count =======
:* E-var & initially contains stop count plus ampersand.  Each recursion
:* clips the initial character.  When only & is left, goto Process
IF '%&%'=='&' GOTO Process
:* Clip the first character from e-var &.
FOR %%a IN (/%&%) DO SET &=%%a

:===== Recurse =====
:* (1st time here results from last Init statement which invokes
:* WITH, passing no params.  E-var + set to null, below, in that case.)
:* 1st param of a nested call?  Set + to 1st param to find out.
SET +=%1
:* If %1=0, yes -- set + to value of lead 0 flag, @. Else, + remains set
:* to 1st param. (@ is 0 if start count has leading zeros, null else.)MDNM.
IF '%1'=='0' SET +=%@%
:* Re-invoke batch file.  Prefix each unit digit (0 - 9) of count w/the
:* count's leftmost digits, held in e-var +.MDNM
:*  For binary counting, truncate CALL %!% statement starting at %+%2.
:*  For hexadecimal, add %+%A to %+%F.
CALL %!% %+%0 %+%1 %+%2 %+%3 %+%4 %+%5 %+%6 %+%7 %+%8 %+%9
:* process next parameter
SHIFT
IF NOT '%1'=='' GOTO Recurse
:* append an ampersand to e-var & (now a re-nesting flag).MDNM
SET &=%&%&
GOTO end

:===== Process =====
:* So $.bat can access it, store 1st param (number being processed)
:* into the count variable. (E-var # holds count var's name.)MDNM
SET %#%=%1
:* Set e-var ^ to $ when the start count is reached.  For it and
:* all numbers to stop count, $.BAT will be executed.
IF '%1'=='%m$%' SET ^=$
CALL %^%
:* If reached stop count, exit secondary command processor,MDNM
:* ending all recursion and clearing all variables.
IF '%1'=='%n$%' EXIT
SHIFT
:* Process next command line parameter
IF NOT '%1'=='' GOTO Process
GOTO end

:===== syntax ======
ECHO      Syntax: WITH ename=m,n command [p1 p2 ... p5]MDNM
ECHO          - command can be internal, COM, .EXE, or .BAT
ECHO          - if with leading zeros, n and m must have same no. of digits
ECHO          - ename is any variable, usable in p1, p2, etc. as %%ename%%MDNM

:===== end =========
