PROGRAM TstMatch;
USES WinDos, Strings,
{$IFDEF Windows} WinCrt, WinTypes, WinProcs;
{$ELSE}
  {$IFNDEF DPMI} Requires BP7's protected mode target
  {$ENDIF}
Crt, WinApi;
{$ENDIF}
TYPE MatchFunc = FUNCTION(Mask, Name : pChar) : boolean;
VAR
  hLibrary : tHandle;
  Matches  : MatchFunc;
  pGraf    : PChar;

  PROCEDURE TestMatch(P1, P2 : PChar; wid : Integer);
  BEGIN
    Write(P2:wid, ' <-> ', P1, '':wid-StrLen(P1), ' match=');
    WriteLn(Matches(P1, P2));
  END;

BEGIN
  ClrScr;
  hLibrary := LoadLibrary('match.dll');
  IF hLibrary < 32 THEN
    BEGIN
      WriteLn('Cannot load library MATCH.DLL');
      Halt;
    END;
  TFarProc(@Matches) := GetProcAddress(hLibrary, 'Matches');
  IF TFarProc(@Matches) = NIL THEN
    BEGIN
      FreeLibrary(hLibrary);
      WriteLn('Cannot locate function "Matches"');
      Halt;
    END;
  TestMatch('P*C***M*A*G', 'PEACEMAKING', 15);
  TestMatch('*E*D*C*E', 'HEADACHE', 15);
  TestMatch('?E?D?C?E', 'HEADACHE', 15);
  TestMatch('*E*D*C*E', 'EDCE', 15);
  TestMatch('?E?D?C?E', 'EDCE', 15);
  TestMatch('*E*D*C*E', 'EDC', 15);
  TestMatch('H??D*', 'HEADACHE', 15);
  TestMatch('H??D*', 'HEAD', 15);
  TestMatch('H??D????', 'HEADACHE', 15);
  TestMatch('H??D????', 'HEAD', 15);
  WriteLn;
  TestMatch('*A*E*I*O*U*Y*', 'FACETIOUSLY', 15);
  TestMatch('*A*E*I*O*U*Y*', 'ABSTEMIOUSLY', 15);
  WriteLn;
  TestMatch('C*D.*M', 'COMMAND.COM', 15);
  TestMatch('CO*OM', 'COMMAND.COM', 15);
  WriteLn;
  TestMatch('*', 'Anything At All', 15);
  WriteLn;
  TestMatch('*the tide*',
    '"Just the place for a snark!", the Bellman cried,'^M^J+
    'As he landed his crew with care,'^M^J+
    'Supporting each man on the top of the tide'^M^J+
    'By a finger entwined in his hair.'^M^J, 0);
  FreeLibrary(hLibrary);
END.
