; INC.SC                                     Paradox for DOS
; Script to allow increment or decrement of a field by pressing
; the [+] or [-] key.
;
; This script will work with any of the following field types:
;    N - Numeric
;    S - Short Integer
;    $ - Currency
;    D - Date
;
; Use the SETKEY command to bind this script to the + and - keys
; and to assign the increment value. For example, in a script use
; the following commands:
;
;  SetKey 43 Inc.n = 1 Play "Inc"         ; [+] key
;  SetKey 45 Inc.n = -1 Play "Inc"        ; [-] key
;
;  This script will test for the following conditions:
;    - There must be a display image of the workspace
;        (Table view or form view)
;    - The current field must be a valid type to increment
;    - The user must be in EDIT or COEDIT mode
;    - The user can't be in FieldView mode
;    - The current field can't be blank
;    - The variable Inc.n must have a value of 1 or -1
;
; An Error Procedure is defined to capture errors that could be
; caused 'after the fact'. For example, incrementing a field beyond
; a HIGH or LOW Valcheck setting will cause an error.
;
; Tested with Paradox For DOS 4.0
;
Proc IncError.u()
   private Err.n

   Err.n = ErrorCode()

   Switch
      Case Err.n = 23 :
         Beep
         Message "Value Is Out Of Valcheck Bounds"
         Sleep 1000
         Return 1
      Case Err.n = 20 :
         Beep
         Message "No Table Is On The Workspace"
         Sleep 1000
         Return 1
   Endswitch
Endproc

Proc Inc.u()
   private Quit.l,
   Errorproc

   Quit.l = False
   Errorproc = "IncError.u"

   Switch
      Case ImageType() <> "Display"                   : Quit.l = True
      Case Search(Substr(FieldType(),1,1),"SN$D") < 1 : Quit.l = True
      Case Search("EDIT",Upper(Sysmode())) < 1        : Quit.l = True
      Case IsFieldView()                              : Quit.l = True
      Case Isblank([])                                : Quit.l = True
      Case Not Isassigned(Inc.n)                      : Quit.l = True
      Case Abs(Inc.n) <> 1                            : Quit.l = True
   Endswitch

   If Quit.l Then
      Beep
      Quit
   Endif

   [] = [] + Inc.n
EndProc

Inc.u()
