/*---------------------------------------
   DIBPEN.C -- DIB Pen Demo
               (c) Charles Petzold, 1994
  ---------------------------------------*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char szClass [] = "DibPen" ;
char szTitle [] = "DibPen: DIB Pen Demo" ;

PVOID LoadDib (PSZ szFilename)
     {
     BITMAPFILEHEADER   bmfh ;
     FILE             * file ;
     PVOID              pDib ;

     if (NULL == (file = fopen (szFilename, "rb")))
          return NULL ;

     fread (&bmfh, sizeof (BITMAPFILEHEADER), 1, file) ;

     bmfh.bfSize -= sizeof (BITMAPFILEHEADER) ;

     if (NULL == (pDib = malloc (bmfh.bfSize)))
          {
          fclose (file) ;
          return NULL ;
          }

     fread (pDib, bmfh.bfSize, 1, file) ;
     fclose (file) ;

     return pDib ;
     }

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     char     szFilename [MAX_PATH] ;
     LOGBRUSH lb ;
     PVOID    pDib ;

     GetWindowsDirectory (szFilename, MAX_PATH) ;

     strcat (szFilename, "\\") ;
     strcat (szFilename, "marble.bmp") ;

     if (NULL == (pDib = LoadDib (szFilename)))
          {
          MessageBeep (0) ;
          return ;
          }

     SetMapMode (hdc, MM_ANISOTROPIC) ;
     SetWindowExtEx (hdc, 100, 100, NULL) ;
     SetViewportExtEx (hdc, cxArea, cyArea, NULL) ;

     lb.lbStyle = BS_DIBPATTERNPT ;
     lb.lbColor = DIB_RGB_COLORS ;
     lb.lbHatch = (LONG) pDib ;

     SelectObject (hdc,
          ExtCreatePen (PS_GEOMETRIC | PS_SOLID, 25, &lb, 0, NULL)) ;

     Ellipse (hdc, 25, 25, 75, 75) ;

     DeleteObject (
          SelectObject (hdc,
               GetStockObject (BLACK_PEN))) ;

     free (pDib) ;
     }
