Option Explicit
' NumSlices can range from 5 to 14.  If a given pie would have more
' than this many slices, the smallest ones are lumped into "OTHER"
' so as to keep the total down to NumSlices.
Global NumSlices%

' The main form sets Dir2Use before initializing a child form; the
' child form initializes in one of four ways depending on Dir2Use.
Global Dir2Use$

' SaveSettings has the same value as mnu_Options(0).Checked; it exists
' solely for convenience.
Global SaveSettings%

' SliceColors holds the color of each of the 16 possible ColorData
' colors except 0 (black) and 15 (white).
Global SliceColors&(1 To 14)

' NumOpenWindows is incremented by each child window that opens and
' decremented by each that closes.  It's used to keep from having
' more than nine pie windows open at once.
Global NumOpenWindows%

' NextWindow is used during the shutdown process.  The child windows
' use it to determine which [Window n] section to write to in the INI
' file, and the main window uses it to determine how many child
' windows there were.
Global NextWindow%

Global Const Pi# = 3.14159268356

' Global variables and a constant for MsgBox calls
Global Msg$
Global MsgType%
Global Const MsgTitle$ = "DISKPIE Message"

' Declare Windows API functions for INI file management
Declare Function GetPrivateProfileInt% Lib "Kernel" (ByVal lpApplicationName$, ByVal lpKeyName$, ByVal nDefault%, ByVal lpFileName$)
Declare Function GetPrivateProfileString% Lib "Kernel" (ByVal lpApplicationName$, ByVal lpKeyName As Any, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%, ByVal lpFileName$)
Declare Function WritePrivateProfileString% Lib "Kernel" (ByVal lpApplicationName$, ByVal lpKeyName$, ByVal lpString$, ByVal lpFileName$)
Declare Function WritePrivateProfileStringByNum% Lib "Kernel" Alias "WritePrivateProfileString" (ByVal lpApplicationName$, ByVal lpKeyName&, ByVal lpString&, ByVal lpFileName$)

' Declare Windows API functions for using WinHelp
Declare Function WinHelpByNum% Lib "User" Alias "WinHelp" (ByVal hWnd%, ByVal lpHelpFile$, ByVal wCommand%, ByVal dwData&)
Declare Function WinHelp% Lib "User" (ByVal hWnd%, ByVal lpHelpFile$, ByVal wCommand%, ByVal dwData$)

Function GPPI% (ByVal Sec$, ByVal Key$, ByVal Def%)
  ' A "wrapper" function that simply helps keep program lines shorter
  GPPI = GetPrivateProfileInt(Sec, Key, Def, "DISKPIE.INI")
End Function

Function GPPS% (ByVal S$, ByVal K$, ByVal D$, V$, ByVal nSize%)
  ' A "wrapper" function that helps keep program lines shorter and
  ' takes care of allocating buffer space.
  V = String$(nSize + 1, 0)
  GPPS = GetPrivateProfileString(S, K, D, V, Len(V), "DISKPIE.INI")
  V = Left$(V, InStr(V, Chr$(0)) - 1)
End Function

Sub NewPie ()
  ' The calling routine must *first* set the variable Dir2Use.  This
  ' variable controls the way the new pie window initializes.  If it
  ' is "GETCOLORS", the new pie window will grab the 14 slice colors.
  ' If it's a number from 0 to 8, the pie window will initialize
  ' itself from DISKPIE.INI.  If it's a directory name preceded by
  ' "T", you get a directory pie; preceded by "E" you get an
  ' extension pie.
  If NineAlready() Then Exit Sub
  Dim NewPieWin As New Child
  Dim Cap$
  ' If the new pie was closed before completion, the line setting
  ' its caption is an error.  The On Error statement avoids trouble.
  On Error GoTo Skip
  Cap = NewPieWin.Caption
  If (Cap = "ERROR") Or (Cap = "Get Colors") Then
    Unload NewPieWin
  Else
    NewPieWin.Show
  End If
Skip:
  Exit Sub
End Sub

Function NineAlready% ()
  If NumOpenWindows >= 9 Then
    Msg = "DiskPie will maintain up to 9 pie windows.  Please "
    Msg = Msg + "close an existing window before opening another."
    MsgType = MB_ICONINFORMATION
    MsgBox Msg, MsgType, MsgTitle
    NineAlready = True
  Else
    NineAlready = False
  End If
End Function

Sub Share_Help_Click (ByVal Index%)
  ' Shared by the Help menu of the main and child forms
  ' WinHelp and WinHelpByNum are declared in DISKPIE.BAS.  VB programs
  ' have automatic context-sensitive help, but they need these API
  ' functions for menu-selected help.
  Dim Success%, hW%, Hlp$
  hW = MdiForm1.hWnd
  Hlp = App.HelpFile
  Select Case Index
    Case 0
      Success = WinHelpByNum(hW, Hlp, HELP_CONTENTS, 0)
    Case 1
      Success = WinHelp(hW, Hlp, HELP_PARTIALKEY, "")
    Case 2
      Success = WinHelpByNum(hW, Hlp, HELP_HELPONHELP, 0)
    Case 4
      DisplayAboutBox MdiForm1, "Disk Pie", 1#, 1994, "Neil J. Rubenking", "First published in PC Magazine", "U.S. Edition, April 26, 1994", 0, False, 0, 0
  End Select
End Sub

Sub Share_Window_Click (ByVal Index%)
  ' Shared by the Window menu of the main and child forms, but
  ' only for the New Dir Window and New Ext Window choices.
  If NineAlready() Then Exit Sub
  Load Form1
  Form1.Show MODAL
  Dir2Use = Form1.Tag
  Unload Form1
  If Dir2Use = "" Then Exit Sub
  Select Case Index
    Case 4
      Dir2Use = "T" + Dir2Use
    Case 5
      Dir2Use = "E" + Dir2Use
  End Select
  NewPie
End Sub

Function WPPS% (ByVal Sec$, ByVal Key$, ByVal Valu$)
  ' A "wrapper" function that simply helps keep program lines shorter
  WPPS = WritePrivateProfileString(Sec, Key, Valu, "DISKPIE.INI")
End Function

