/*----------------------------------------
   FONTOUT.C -- Paths for Outlining Fonts
                (c) Charles Petzold, 1994
  ----------------------------------------*/

#include <windows.h>
#include <string.h>
#include "ezfont.h"

char szClass [] = "FontOut" ;
char szTitle [] = "FontOut: Paths for Outlining Fonts" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     static char szString [] = "Outline" ;
     HFONT       hFont ;
     SIZE        size ;

     hFont = EzCreateFont (hdc, "Times New Roman", 1440, 0, 0, TRUE) ;

     SelectObject (hdc, hFont) ;

     GetTextExtentPoint (hdc, szString, strlen (szString), &size) ;

     BeginPath (hdc) ;
     TextOut (hdc, (cxArea - size.cx) / 2, (cyArea - size.cy) / 2,
              szString, strlen (szString)) ;

     EndPath (hdc) ;

     StrokePath (hdc) ;

     SelectObject (hdc, GetStockObject (SYSTEM_FONT)) ;
     DeleteObject (hFont) ;
     }
