/*----------------------------------------
   FONTROT.C -- Rotated Fonts
                (c) Charles Petzold, 1994
  ----------------------------------------*/

#include <windows.h>
#include <string.h>
#include <math.h>
#include "ezfont.h"

#define TWO_PI (2 * 3.14159)

char szClass [] = "FontRot" ;
char szTitle [] = "FontRot: Rotated Fonts" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     static char szString [] = "  Rotate" ;
     HFONT       hFont ;
     int         iAngle ;
     XFORM       xform ;

     hFont = EzCreateFont (hdc, "Times New Roman", 540, 0, 0, TRUE) ;

     SelectObject (hdc, hFont) ;

     SetBkMode (hdc, TRANSPARENT) ;
     SetTextAlign (hdc, TA_BASELINE) ;
     SetGraphicsMode (hdc, GM_ADVANCED) ;

     for (iAngle = 0 ; iAngle < 360 ; iAngle += 36)
          {
          xform.eM11 = (FLOAT)  cos (TWO_PI * iAngle / 360) ;
          xform.eM12 = (FLOAT)  sin (TWO_PI * iAngle / 360) ;
          xform.eM21 = (FLOAT) -sin (TWO_PI * iAngle / 360) ;
          xform.eM22 = (FLOAT)  cos (TWO_PI * iAngle / 360) ;
          xform.eDx  = (FLOAT) (cxArea / 2) ;
          xform.eDy  = (FLOAT) (cyArea / 2) ;

          SetWorldTransform (hdc, &xform) ;

          TextOut (hdc, 0, 0, szString, strlen (szString)) ;
          }

     SelectObject (hdc, GetStockObject (SYSTEM_FONT)) ;
     DeleteObject (hFont) ;
     }
