#ifndef __BUTTONS2_H_
#define __BUTTONS2_H_

//////////////////////////////////////
// Resource IDs

#define IDB_OPEN        100
#define IDB_SAVE        101

#define IDM_OPEN        110
#define IDM_SAVE        111
#define IDM_OPTIONS     112
#define IDM_EXIT        113

#define IDD_ENABLEOPEN  120
#define IDD_DISABLEOPEN 121
#define IDD_ENABLESAVE  122
#define IDD_DISABLESAVE 123

//////////////////////////////////////
// The CMainWindow class

class CMainWindow : public CFrameWnd
{
public:
    CBitmapButton m_OpenButton;
    CBitmapButton m_SaveButton;

    CMainWindow ();
        
    afx_msg int OnCreate (LPCREATESTRUCT);
    afx_msg void OnPaint ();
    afx_msg void OnOpen ();
    afx_msg void OnSave ();
    afx_msg void OnOptions ();
    afx_msg void OnExit ();
        
    DECLARE_MESSAGE_MAP ()
};

//////////////////////////////////////
// The COptionsDlg class

class COptionsDlg : public CModalDialog
{
private:
    CBitmapButton m_OKButton;
    CBitmapButton m_CancelButton;

public:
    // Constructor
    COptionsDlg (CWnd* pWndParent) :
        CModalDialog ("Options", pWndParent)
    {}
    
    BOOL OnInitDialog ();
    afx_msg void OnOK ();
    
    DECLARE_MESSAGE_MAP ()
};

//////////////////////////////////////
// The CMyApp class

class CMyApp : public CWinApp
{
public:
    BOOL InitInstance ();
};

#endif // __BUTTONS2_H_
