VERSION 2.00
Begin Form frmScrSave 
   BackColor       =   &H00000000&
   BorderStyle     =   0  'None
   Caption         =   "GUIToons"
   ClientHeight    =   1200
   ClientLeft      =   1650
   ClientTop       =   1755
   ClientWidth     =   5340
   Height          =   1725
   Icon            =   GUITOONS.FRX:0000
   Left            =   1590
   LinkTopic       =   "Form1"
   ScaleHeight     =   1200
   ScaleWidth      =   5340
   Top             =   1290
   Width           =   5460
   Begin PictureBox picLoader 
      Height          =   855
      Left            =   3600
      ScaleHeight     =   825
      ScaleWidth      =   825
      TabIndex        =   3
      Top             =   180
      Width           =   855
   End
   Begin PictureBox picScreenCap 
      Height          =   855
      Left            =   2490
      ScaleHeight     =   825
      ScaleWidth      =   825
      TabIndex        =   2
      Top             =   180
      Width           =   855
   End
   Begin PictureBox picWorkSpace 
      Height          =   855
      Left            =   1350
      ScaleHeight     =   825
      ScaleWidth      =   825
      TabIndex        =   1
      Top             =   180
      Width           =   855
   End
   Begin PictureBox picPicture 
      Height          =   855
      Index           =   0
      Left            =   240
      ScaleHeight     =   825
      ScaleWidth      =   825
      TabIndex        =   0
      Top             =   180
      Width           =   855
   End
   Begin Timer Timer1 
      Enabled         =   0   'False
      Interval        =   55
      Left            =   4680
      Top             =   180
   End
End
DefInt A-Z
Option Explicit
Dim JustAMoment%
'  Upon receiving a bad password or cancel, Unload sets
'  JustAMoment to TRUE. The timer sets it to FALSE on its
'  next event. In between, the screen saver ignores events
'  like the mouse-up from the cancel button

Sub Form_Click ()

  If Not JustAMoment Then Unload Me

End Sub

Sub Form_KeyPress (KeyAscii As Integer)

  If Not JustAMoment Then Unload Me

End Sub

Sub Form_Load ()
  Randomize Timer
  JustAMoment = False
    '-- Setup screen?
  If InStr(Command$, "/c") Then
    frmSetup.Show 1
    Me.Visible = False
    Exit Sub
  End If

  Dim Success%

'-- Read setup data from the CONTROL.INI file

    '-- NumBitmaps
  NumBitmaps = ReadInt("NumBitmaps", 0)
  If NumBitmaps = 0 Then
    MsgBox "No bitmaps have been selected. Press Ok to set up", 16, "GUIToons"
    frmSetup.Show 1
    End
  End If
    
    '-- Hide the cursor
  HideCursor

    '-- MoveSpeed
  MoveSpeed = ReadInt("MoveSpeed", 10)
  If MoveSpeed < 1 Then MoveSpeed = 10

  Dim Interval&, i%

    '-- Animation Interval
  Interval = ReadInt("Interval", 1)
  If Interval < 1 Then Interval = 1
  Timer1.Interval = Interval& * 56
  
    '-- Background
  ClearScreen% = ReadInt("ClearScreen", False)

    '-- Load pictures controls and redim's an array to hold
    '   Device Context handles.
  For i = 1 To NumBitmaps - 1
    Load picPicture(i)
  Next
  ReDim DC(0 To NumBitmaps - 1) As DCType

    '-- Initialize the Picture Loader Control
  picLoader.AutoRedraw = True
  picLoader.Visible = False
  picLoader.Left = Screen.Width + 1
  picLoader.BorderStyle = 0

    '-- Grab the screen's DC
  ScreenDC = CreateDC("DISPLAY", "", "", "")

  Dim FileName$, KeyName$
    '-- Load the first bitmap to determine the size of the picture
    '   controls (including the MoveSpeed).
  FileName$ = ReadString$("Bitmap1")
  If Len(FileName$) Then
    On Error Resume Next
    picLoader.Picture = LoadPicture(FileName$)
    picLoader.AutoSize = True
    If Err Then
      Beep
      Success = ShowCursor(True)
      MsgBox "Error Loading Bitmap File: " & UCase$(FileName$), 0, "GUIToons"
      End
    End If
  End If

  Dim realbWidth!, realbHeight!, twipWidth&, twipHeight&
    '-- Determine Width and Height variables
  picLoader.ScaleMode = 3
  realbWidth = picLoader.ScaleWidth
  realbHeight = picLoader.ScaleHeight
  bWidth = realbWidth + (MoveSpeed * 2)
  bHeight = realbHeight + (MoveSpeed * 2)
  twipWidth = bWidth * Screen.TwipsPerPixelX
  twipHeight = bHeight * Screen.TwipsPerPixelY

    '-- Set up the WorkSpace picture
  picWorkSpace.Height = twipHeight
  picWorkSpace.Width = twipWidth
  picWorkSpace.AutoRedraw = True
  picWorkSpace.Visible = False
  picWorkSpace.BorderStyle = 0
  picWorkSpace.Left = Screen.Width + 1
  WorkDC = picWorkSpace.hDC

    '-- Set up the ScreenCap picture
  picScreenCap.Visible = False
  picScreenCap.Left = Screen.Width + 1
  If ClearScreen% Then
    ' don't bother setting up to save the screen
  Else
    picScreenCap.Height = Screen.Height
    picScreenCap.Width = Screen.Width
    picScreenCap.AutoRedraw = True
    picScreenCap.BorderStyle = 0
    ScreenCapDC = picScreenCap.hDC
  End If


  Dim LoaderDC%, BColor&, OldColor&, TempBMP%, TempDC%, OldBMP%, Dummy%

    '-- Load Bitmaps
  For i = 0 To NumBitmaps - 1

        '-- Hide the animation picture controls.
        '-- Set Hidden picture controls' AutoRedraw True.
        '   They will not hold their pictures' data in memory
        '   if you do not set AutoRedraw True.
    picPicture(i).AutoRedraw = True
    picPicture(i).Visible = False
    picPicture(i).Left = Screen.Width + 1
    picPicture(i).AutoSize = False
    picPicture(i).Width = twipWidth
    picPicture(i).Height = twipHeight
    picPicture(i).BorderStyle = 0

        '-- Load the next file.
    KeyName$ = "Bitmap" & LTrim$(Str$(i + 1))
    FileName$ = ReadString$(KeyName$)
    If Len(FileName$) = 0 Then
      Beep
      Success = ShowCursor(True)
      MsgBox "No Bitmaps Specified. You must set up the screen saver with the Control Panel's 'Desktop' applet", 16, "GUIToons"
      End
    End If
    On Error Resume Next
    picLoader.Picture = LoadPicture(FileName$)
    DoEvents
    If Err Then
      Beep
      Success = ShowCursor(True)
      MsgBox "Screen Saver Error - Cannot Find Bitmap File: " & UCase$(FileName$), 16, "GUIToons"
      End
    End If

        '-- DC(x) is an array of DC values (integer array)
    DC(i).IntPicDC = picPicture(i).hDC
    LoaderDC = picLoader.hDC

        '-- The Background color of the DC must be set to the same as
        '   the upper-left hand pixel color in order to create the mask.
    BColor& = GetPixel&(LoaderDC, 0, 0)
    OldColor& = SetBkColor&(DC(i).IntPicDC, BColor&)
    picPicture(i).BackColor = BColor&
    picPicture(i).Refresh

        '-- Copy the image from the picLoader control to the picPicture
        '   control for this frame
    DC(i).IntPicDC = picPicture(i).hDC
    Success = BitBlt(DC(i).IntPicDC, MoveSpeed, MoveSpeed, realbWidth, realbHeight, LoaderDC, 0, 0, SRCCOPY)

        '-- Create mask from the picture:

        '-- Create the mask DC, and a bitmap to go in it.
    DC(i).IntMaskDC = CreateCompatibleDC(ScreenDC)
    DC(i).intMaskBmp = CreateCompatibleBitmap(ScreenDC, bWidth, bHeight)

        '-- Move the bitmap into the Mask DC
    DC(i).intOldMaskBmp = SelectObject(DC(i).IntMaskDC, DC(i).intMaskBmp)

        '-- Create a monochrome bitmap that will be the mask bitmap.
    TempBMP = CreateBitmap(bWidth, bHeight, 1, 1, 0&)

        '-- Create a temporary DC, and put the mask bitmap into it
    TempDC = CreateCompatibleDC(ScreenDC)
    OldBMP = SelectObject(TempDC, TempBMP)

        '-- Copy the picture into the temporary compatible DC
    Success = BitBlt(TempDC, 0, 0, bWidth, bHeight, DC(i).IntPicDC, 0, 0, SRCCOPY)
        '-- Copy the compatible DC into the mask (mono) DC
    Success = BitBlt(DC(i).IntMaskDC, 0, 0, bWidth, bHeight, TempDC, 0, 0, SRCCOPY)

        '-- Clean up
    TempBMP = SelectObject(TempDC, OldBMP)
    Dummy = DeleteObject(TempBMP)
    Dummy = DeleteDC(TempDC)

  Next

    '-- Set up the form.
  Me.ScaleMode = 3
  Me.Width = Screen.Width
  Me.Height = Screen.Height
  Me.Top = 0
  Me.Left = 0
  Me.AutoRedraw = True
  pixWidth = Me.ScaleWidth
  pixHeight = Me.ScaleHeight
  DisplayDC = Me.hDC
  
  ResetMoveX 1
  ResetMoveY 1

    '-- Set up the background image, if needed
  If ClearScreen% Then
    ' don't bother saving the screen
  Else
      '-- Copy from the Screen to the DisplayDC (main form) with the
      '   desired effect
    Success = SetStretchBltMode(ScreenDC, 2)
        '-- Copy the screen to the form
    Success = BitBlt(DisplayDC, 0, 0, pixWidth, pixHeight, ScreenDC, 0, 0, SRCCOPY)
      '-- Copy the screen to the picScreenCap picture control.
    Success = BitBlt(ScreenCapDC, 0, 0, pixWidth, pixHeight, DisplayDC, 0, 0, SRCCOPY)
  End If
    
    '-- Show the form
  Me.Show
  Me.AutoRedraw = False

    '-- Bring it to the top
  Me.ZOrder

    '-- Get the DC again.
  DisplayDC = Me.hDC

''''    '-- Hide the cursor
''''  HideCursor

    '-- Enable the Timer
  Timer1.Enabled = True
  Success = SystemParametersInfo%(SPI_SETSCREENSAVEACTIVE, 0, 0, 0)
  JustAMoment = True


    '-- At this point the Timer will fire every (Interval). The actual
    '   animation takes place in the Timer1_Timer event procedure.

End Sub

Sub Form_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
  If JustAMoment Then Exit Sub
  Static Once
  If Once Then
    Unload Me
    Once = False
  Else
    Once = True
  End If

End Sub

Sub Form_Unload (Cancel As Integer)
  Dim Success%, i%, Dummy%

    '-- Setup screen?
  If InStr(Command$, "/c") Then
    End
  End If

    '-- If the user doesn't type in the right
    '   password, resume
  If ReadInt("PWProtected", 0) = 1 Then
    If Len(ReadPassword$()) Then
      If GetPassword() = False Then
        Cancel = True
        JustAMoment = True
        Exit Sub
      End If
    End If
  End If

    '-- Show the cursor
  Success = ShowCursor(True)

    '-- Disable the timer
  Timer1.Enabled = False

    '-- Delete mask bitmaps and Device Contexts
  For i = 0 To NumBitmaps - 1
    DC(i).intMaskBmp = SelectObject(DC(i).IntMaskDC, DC(i).intOldMaskBmp)
    Dummy = DeleteObject(DC(i).intMaskBmp)
    Dummy = DeleteDC(DC(i).IntMaskDC)
  Next

    '-- Delete the screen DC
  Success = DeleteDC(ScreenDC)

    '-- Goom-bye
  Success = SystemParametersInfo%(SPI_SETSCREENSAVEACTIVE, 1, 0, 0)
  End

End Sub

Sub ResetMoveX (Direction)
    
  If Direction = -1 Then
    MoveX = GetRandomNumber(-MoveSpeed, 1)
  Else
    MoveX = GetRandomNumber(1, MoveSpeed)
  End If
  
End Sub

Sub ResetMoveY (Direction)
  
  If Direction = -1 Then
    MoveY = GetRandomNumber(-MoveSpeed, 1)
  Else
    MoveY = GetRandomNumber(1, MoveSpeed)
  End If
  
End Sub

Sub Timer1_Timer ()

' *FIGURE 7 begin*
  Static Frame, Direction, X, Y, BeenHere

  If BeenHere = False Then
        '-- Initialize (first time only)
    Frame = 0        '-- Frame is the Frame number
    X = -MoveSpeed   '-- Remember MoveSpeed = Margin
    Y = -MoveSpeed
    Direction = True '-- True = Foreward, False = Backwards
    BeenHere = True
  End If

    '-- Pick the next bitmap. The bitmaps are
    '   circulated {0,1,2,3,4,3,2,1,REPEAT}

  If Direction Then   '-- Foreward
    If Frame < NumBitmaps - 1 Then
      Frame = Frame + 1
      If Frame > NumBitmaps - 1 Then Frame = 0
    Else
      Direction = False
      Frame = Frame - 1
      If Frame = -1 Then Frame = 0
    End If
  Else                '-- Backwards
    If Frame > 0 Then
      Frame = Frame - 1
      If Frame = -1 Then Frame = 0
    Else
      Direction = True
      Frame = Frame + 1
      If Frame > NumBitmaps - 1 Then Frame = 0
    End If
  End If

    '-- Pick an X coordinate for the bitmap
  X = X + MoveX
  Do
    If X >= pixWidth - bWidth + MoveSpeed Then
      ResetMoveX -1
      X = X + MoveX
    ElseIf X <= -MoveSpeed Then
      ResetMoveX 1
      X = X + MoveX
    Else
      Exit Do
    End If
    DoEvents
  Loop

    '-- Pick a Y coordinate for the bitmap
  Y = Y + MoveY
  Do
    If Y >= pixHeight - bHeight + MoveSpeed Then
      ResetMoveY -1
      Y = Y + MoveY
    ElseIf Y <= -MoveSpeed Then
      ResetMoveY 1
      Y = Y + MoveY
    Else
      Exit Do
    End If
    DoEvents
  Loop
' *FIGURE 7 end*

  Dim Success%
' *FIGURE 5 begin*
'-- Draw the next Frame at the next x and y coordinates

  If ClearScreen% Then
      
      '-- Copy the mask to the workspace, exchanging white and black
    Success = BitBlt(WorkDC, 0, 0, bWidth, bHeight, DC(Frame).IntMaskDC, 0, 0, NOTSRCCOPY)
      
      ' Copy the bitmap to the workspace with AND
    Success = BitBlt(WorkDC, 0, 0, bWidth, bHeight, DC(Frame).IntPicDC, 0, 0, SRCAND)

  Else

      '-- Copy the target area from picScreenCap to picWorkspace
    Success = BitBlt(WorkDC, 0, 0, bWidth, bHeight, ScreenCapDC, X, Y, SRCCOPY)

      '-- Copy the bitmap from picPicture to picWorkSpace with XOR
    Success = BitBlt(WorkDC, 0, 0, bWidth, bHeight, DC(Frame).IntPicDC, 0, 0, SRCINVERT)

      '-- Copy the mask from the Mask DC to picWorkSpace with AND
    Success = BitBlt(WorkDC, 0, 0, bWidth, bHeight, DC(Frame).IntMaskDC, 0, 0, SRCAND)

      '-- Copy the bitmap again to picWorkSpace with XOR
    Success = BitBlt(WorkDC, 0, 0, bWidth, bHeight, DC(Frame).IntPicDC, 0, 0, SRCINVERT)

  End If
    '-- Copy the entire frame from picWorkspace to the Display (main form).
  Success = BitBlt(DisplayDC, X, Y, bWidth, bHeight, WorkDC, 0, 0, SRCCOPY)
' *FIGURE 5 end*
  JustAMoment = False
End Sub

