DefInt A-Z
Option Explicit

Declare Sub SetSysModalWindow Lib "User" (ByVal hWnd%)
Declare Function GetPrivateProfileString% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%, ByVal lpFileName$)
Declare Function GetPrivateProfileInt% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal nDefault%, ByVal lpFileName$)
Declare Sub WritePrivateProfileString Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpString$, ByVal lpFileName$)
Declare Function ShowCursor% Lib "User" (ByVal bShow%)

Global EnteredCorrectPassword
Global Password$

Const Heading$ = "Screen Saver.GUIToons"
Const ControlIni$ = "CONTROL.INI"

Sub EncryptString (Source$)
' *Figure 8 includes whole routine
    ' Encrypt a string the same way the standard screen saver
    ' library does it. The result is based on the XOR operation,
    ' but it's guaranteed to produce a string containing
    ' valid characters (no control characters, no non-printable
    ' characters, etc.)
  Dim Strg$, StrgLg%, StrgPt%, TheByte%

  StrgLg = Len(Source$)
  If StrgLg = 0 Then Exit Sub
    ' Convert string to uppercase
  Strg = UCase$(Source$)

    ' Process characters from first to last
  For StrgPt = 0 To StrgLg - 1
    TheByte = Asc(Mid$(Strg, StrgPt + 1, 1))
    EXor StrgLg, TheByte     'Xor byte with password length
    If StrgPt = 0 Then
      EXor &H2A, TheByte     'Xor first byte with constant
    Else
      EXor StrgPt, TheByte   'Xor with position
      EXor Asc(Mid$(Strg, StrgPt, 1)), TheByte  'Xor with prev char
    End If
    Mid$(Strg, StrgPt + 1, 1) = Chr$(TheByte)
  Next

  If StrgLg = 1 Then Exit Sub

    ' Process characters from last to first
  For StrgPt = StrgLg - 1 To 0 Step -1
    TheByte = Asc(Mid$(Strg, StrgPt + 1, 1))
    EXor StrgLg, TheByte     ' Xor byte with password length
    If StrgPt = StrgLg - 1 Then
      EXor &H2A, TheByte     'Xor first byte with constant
    Else
      EXor StrgPt, TheByte   'Xor with position
      EXor Asc(Mid$(Strg, StrgPt + 2, 1)), TheByte 'Xor with next char
    End If
    Mid$(Strg, StrgPt + 1, 1) = Chr$(TheByte)
  Next
  Source$ = Strg

End Sub

Sub EXor (X1, X2)
' *Figure 8 includes whole routine
  Select Case X2 Xor X1
    Case &H0 To &H20, &H7F To &H90, &H93 To &H9F, &H3D, &H5B, &H5D
    Case Else
      X2 = X2 Xor X1
  End Select
End Sub

Function GetPassword ()
'-- Displays the Get Password Dialog Box.
'   Returns True if the correct password
'   was selected.

    '-- Assume False
  EnteredCorrectPassword = False

    '-- Read the correct password
  Password$ = ReadPassword$()

    '-- If there is a password...
  If Len(Password$) Then
            '-- Load the frmGetPW form into memory
    Load frmGetPW
            '-- SYSTEM MODAL windows do not allow ANYTHING
            '   to happen until the user closes the window.
    SetSysModalWindow frmGetPW.hWnd
            '-- Show the Window Modally (Waiting until it is closed)
    frmGetPW.Show 1
            '-- Return the result
    GetPassword = EnteredCorrectPassword
  End If

End Function

Sub HideCursor ()

  Do
  Loop Until ShowCursor(False) = -1

End Sub

Function ReadInt (Variable$, nDefault%)

  ReadInt = GetPrivateProfileInt(Heading$, Variable$, nDefault%, ControlIni)

End Function

Function ReadPassword$ ()

    '-- Reads an encrypted password string
    '   from the CONTROL.INI file.

  Dim BufferSize%, Buffer$, NumChars%
  BufferSize = 20
  Buffer$ = Space$(BufferSize)
  NumChars = GetPrivateProfileString("ScreenSaver", "Password", "", Buffer$, BufferSize, ControlIni$)
  If NumChars Then
    ReadPassword$ = Left$(Buffer$, NumChars)
  Else
    ReadPassword$ = ""
  End If

End Function

Function ReadString$ (Variable$)

  Dim Buffer$, L%
  Buffer$ = Space$(256)
  L = GetPrivateProfileString(Heading$, Variable$, "", Buffer$, 256, ControlIni$)
  If L Then
    ReadString$ = Left$(Buffer$, L)
  End If

End Function

Sub WriteInt (Variable$, ByVal Value%)
  WriteString Variable$, Format$(Value)
End Sub

Sub WritePassword (PW$)

    '-- Writes an encrypted password string
    '   to the CONTROL.INI file.

  WritePrivateProfileString "ScreenSaver", "Password", PW$, ControlIni$

End Sub

Sub WriteString (Variable$, St$)

  WritePrivateProfileString Heading$, Variable$, St$, ControlIni$

End Sub

