/*
   HACCESS.C -- DLL to record track of help file accesses.

   Copyright 1995, Jim Mischel and Pete Davis
*/
#include <windows.h>
#include <malloc.h>
#include <time.h>
#include "helpdll.h"
#include "haccess.rh"

#define TEMPORARY_FILE "access.hlp"
#define ACCESS_BAGFILE "access.log"

// DLL instance handle
static HINSTANCE HInstance;
static char FileToModify[128];
static int AccessFlag = 0;
static int ModFlag = 0;

int _far _pascal _export LibMain (HINSTANCE hInst, WORD wDataSeg,
  WORD cbHeap, LPSTR lpchCmdLine) {

  HInstance = hInst;
  return TRUE;
}

static void FillListbox (HWND hDlg) {
  HFS hfs;
  HF hf;
  char *filename;
  char *Buffer;
  char *c;
  long FileSize;
  int Counter;
  HWND hwndListbox = GetDlgItem (hDlg, IDC_LISTBOX1);

  filename = LGetHPath (LGetCurrHWnd ());
  // try to open the help file
  if ((hfs = HFSOpenSz (filename, fFSOpenReadOnly)) == 0)
    return;
  free (filename);

  // try to open the bag file
  if ((hf = HFOpenHFS (hfs, ACCESS_BAGFILE, fFSOpenReadOnly)) == 0)
    goto CloseHFS;

  // get file size and allocate buffer
  FileSize = LCBSizeHF (hf);
  Buffer = malloc (FileSize);

  // Read file into buffer
  LCBReadHF (hf, (LPBYTE)Buffer, FileSize);

  // now add each string to the list box
  c = Buffer;
  Counter = 0;
  while (Counter < FileSize) {
    SendMessage (hwndListbox, LB_ADDSTRING, 0, (LPARAM)c);
    Counter += lstrlen (c)+1;
    c += lstrlen (c)+1;
  }
  free (Buffer);
  RCCloseHF (hf);
CloseHFS:
  RCCloseHFS (hfs);

}

LRESULT FAR PASCAL DisplayDlgProc (HWND hDlg, WORD message,
  WPARAM wParam, LPARAM lParam) {
  switch (message) {
    case WM_INITDIALOG :
      FillListbox (hDlg);
      return TRUE;

    case WM_COMMAND :
      switch (wParam) {
        case IDOK :
          EndDialog (hDlg, IDOK);
          break;
      }
      break;
  }
  return FALSE;
}

void _far _pascal _export ShowAccess (void) {
  DLGPROC dlgproc;

  // get the name
  dlgproc = (DLGPROC)MakeProcInstance ((FARPROC)DisplayDlgProc, HInstance);
  DialogBox (HInstance, "DisplayDlg", LGetCurrHWnd (), dlgproc);
  FreeProcInstance ((FARPROC)dlgproc);
}

static char AccessString[61];

LRESULT FAR PASCAL NameDlgProc (HWND hDlg, WORD message,
  WPARAM wParam, LPARAM lParam) {
  switch (message) {
    case WM_INITDIALOG : {
      HWND EditBox = GetDlgItem (hDlg, IDC_EDIT1);
      // Clear the input box and set the maximum text length
      SetWindowText (EditBox, "");
      SendMessage (EditBox, EM_LIMITTEXT, 30, 0L);
      return TRUE;
    }

    case WM_COMMAND :
      switch (wParam) {
        case IDOK :
          GetDlgItemText (hDlg, IDC_EDIT1, AccessString, 30);
          EndDialog (hDlg, IDOK);
          break;
      }
      break;
  }
  return FALSE;
}

void _far _pascal _export AddAccess (void) {
  char *c;
  DLGPROC dlgproc;
  time_t ttime;

  if (AccessFlag) {
    AccessFlag = 0;
    return;
  }

  // get the name
  dlgproc = (DLGPROC)MakeProcInstance ((FARPROC)NameDlgProc, HInstance);
  DialogBox (HInstance, "AccessDlg", LGetCurrHWnd (), dlgproc);
  FreeProcInstance ((FARPROC)dlgproc);

  // append the date and time
  lstrcat (AccessString, "  ");
  ttime = time (NULL);
  lstrcat (AccessString, asctime (localtime (&ttime)));
  // remove the newline character
  AccessString[lstrlen(AccessString)-1] = '\0';

  c = LGetHPath (LGetCurrHWnd ());
  lstrcpy (FileToModify, c);
  free (c);
  AccessFlag = 1;
  ModFlag = 1;
  FApi (TEMPORARY_FILE, HELP_FORCEFILE, 0L);
}

static void UpdateAccess (char *Filename) {
  HFS hfs;
  HF hf;

  if (ModFlag--)
    return;

  // try to open the help file
  if ((hfs = HFSOpenSz (Filename, fFSOpenReadWrite)) == 0)
    return;
  // try to open the bag file
  if ((hf = HFOpenHFS (hfs, ACCESS_BAGFILE, fFSOpenReadWrite)) == 0) {
    // it doesn't exist, create it.
    hf = HFCreateFileHFS (hfs, ACCESS_BAGFILE, fFSOpenReadWrite);
  }
  // seek to the end of the file
  LSeekHF (hf, 0, wFSSeekEnd);
  // and write the string
  LCBWriteHF (hf, (LPBYTE)AccessString, lstrlen (AccessString)+1);
  RCCloseHF (hf);
CloseHFS:
  RCCloseHFS (hfs);
}

/* LDLLHandler -- Respond to WinHelp messages */
long _far _pascal _export LDLLHandler (
  WORD wMsg, LONG lParam1, LONG lParam2) {

  switch (wMsg) {
    /*
      Return value indicates the types of messages that
      you want to receive.
    */
    case DW_WHATMSG :
      return (DC_CALLBACKS | DC_INITTERM | DC_JUMP);

    /* Get callback addresses */
    case DW_CALLBACKS :
      GetWinHelpCallbacks ((VPTR)lParam1, lParam2);
      return TRUE;
    case DW_INIT :
      return TRUE;
    /* Received immediately before the DLL is unloaded */
    case DW_TERM :
      EndWinHelpDLL (NULL);
      return TRUE;
    /* Received after a jump is completed */
    case DW_ENDJUMP :
      if (AccessFlag) {
        UpdateAccess (FileToModify);
        FApi (FileToModify, HELP_FORCEFILE, 0);
      }
      return TRUE;
    /* Ignore any other messages */
    default :
      return FALSE;
  }
}

