//***************************************************************************
//
//  SBDemo2.c
//
//***************************************************************************

#include <windows.h>
#include <commctrl.h>
#include "SBDemo2.h"

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM);
BOOL GetModifiedClientRect (HWND, HWND, LPRECT);
void InitStatusBar (HWND);
void PositionPanes (HWND, HWND);

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
    static char szWndClass[] = "SBDemo2";
    WNDCLASS wc;
    HWND hwnd;
    MSG msg;

    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = (WNDPROC) WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
    wc.lpszMenuName = "MainMenu";
    wc.lpszClassName = szWndClass;

    RegisterClass (&wc);

    hwnd = CreateWindow (szWndClass, "Status Bar Demo 2",
        WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, HWND_DESKTOP, NULL, hInstance, NULL);

    ShowWindow (hwnd, nCmdShow);
    UpdateWindow (hwnd);

    while (GetMessage (&msg, NULL, 0, 0)) {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }
    return msg.wParam;
}

LRESULT CALLBACK WndProc (HWND hwnd, UINT message, WPARAM wParam,
                          LPARAM lParam)
{
    HDC hdc;
    HMENU hMenu;
    PAINTSTRUCT ps;
    static HINSTANCE hInstance;
    static HWND hwndStatusBar;
    UINT uItem, fuFlags;
    char szHelpText[64];
    int nHeight;
    RECT rect;
    
    switch (message) {
    
    case WM_CREATE:
        //
        // Create and initialize the status bar.
        //
        hInstance = ((LPCREATESTRUCT) lParam)->hInstance;

        InitCommonControls ();
        hwndStatusBar = CreateStatusWindow (WS_CHILD | WS_VISIBLE,
            NULL, hwnd, IDC_STATUS_BAR);

        InitStatusBar (hwndStatusBar);
        return 0;

    case WM_SIZE:
        //
        // Echo WM_SIZE messages to the status bar and reposition the
        // status bar's panes.
        //
        SendMessage (hwndStatusBar, WM_SIZE, wParam, lParam);
        PositionPanes (hwnd, hwndStatusBar);
        return 0;

    case WM_PAINT:
        //
        // Repaint the window's interior.
        //
        hdc = BeginPaint (hwnd, &ps);
        GetModifiedClientRect (hwnd, hwndStatusBar, &rect);
        DrawEdge (hdc, &rect, EDGE_SUNKEN, BF_RECT);
        EndPaint (hwnd, &ps);
        return 0;

    case WM_MENUSELECT:
        //
        // Update the status bar as the user browses the menus.
        //
        uItem = LOWORD (wParam);
        fuFlags = HIWORD (wParam);

        if ((fuFlags == 0xFFFF) && (lParam == 0))
            SendMessage (hwndStatusBar, SB_SETTEXT, SBT_NOBORDERS,
                (LPARAM) "Ready");

        else if ((uItem >= IDM_FILE_NEW) && (uItem <= IDM_HELP_ABOUT)) {
            LoadString (hInstance, uItem, szHelpText, sizeof (szHelpText));
            SendMessage (hwndStatusBar, SB_SETTEXT, SBT_NOBORDERS,
                (LPARAM) szHelpText);
        }

        else
            SendMessage (hwndStatusBar, SB_SETTEXT, SBT_NOBORDERS,
                (LPARAM) "");

        return 0;

    case WM_KEYDOWN:
        //
        // Update the status bar if Caps Lock, Num Lock, or Scroll Lock was
        // pressed.
        //
        switch (wParam) {

        case VK_CAPITAL:
            SendMessage (hwndStatusBar, SB_SETTEXT, 1,
                (GetKeyState (VK_CAPITAL) & 0x01) ? (LPARAM) "\tCaps" :
                (LPARAM) "");
            return 0;

        case VK_NUMLOCK:
            SendMessage (hwndStatusBar, SB_SETTEXT, 2,
                (GetKeyState (VK_NUMLOCK) & 0x01) ? (LPARAM) "\tNum" :
                (LPARAM) "");
            return 0;

        case VK_SCROLL:
            SendMessage (hwndStatusBar, SB_SETTEXT, 3,
                (GetKeyState (VK_SCROLL) & 0x01) ? (LPARAM) "\tScrl" :
                (LPARAM) "");
            return 0;
        }
        break;

    case WM_COMMAND:
        //
        // Process menu selections.
        //
        switch (LOWORD (wParam)) {

        case IDM_VIEW_STATUS_BAR:
            //
            // Display or hide the status bar.
            //
            hMenu = GetMenu (hwnd);

            if (IsWindowVisible (hwndStatusBar)) {
                ShowWindow (hwndStatusBar, SW_HIDE);
                CheckMenuItem (hMenu, IDM_VIEW_STATUS_BAR, MF_UNCHECKED);
            }
            else { // Not visible
                ShowWindow (hwndStatusBar, SW_SHOW);
                CheckMenuItem (hMenu, IDM_VIEW_STATUS_BAR, MF_CHECKED);
            }           

            // Fix up the bottom window border
            GetWindowRect (hwndStatusBar, &rect);
            nHeight = rect.bottom - rect.top;
            GetClientRect (hwnd, &rect);
            rect.top = rect.bottom - nHeight - 8;
            InvalidateRect (hwnd, &rect, TRUE);
            return 0;
        }
        break;
    
    case WM_DESTROY:
        //
        // Terminate the application.
        //
        PostQuitMessage (0);
        return 0;
    }
    return DefWindowProc (hwnd, message, wParam, lParam);
}

BOOL GetModifiedClientRect (HWND hwnd, HWND hwndStatusBar, LPRECT pRect)
{
    RECT rect;

    if (!GetClientRect (hwnd, pRect))
        return FALSE;

    if (IsWindowVisible (hwndStatusBar)) {
        GetWindowRect (hwndStatusBar, &rect);
        pRect->bottom -= (rect.bottom - rect.top);
    }
    return TRUE;
}

void InitStatusBar (HWND hwndStatusBar)
{
    BYTE byKeyState[256];
    static int nPos[4] = { 0, 0, 0, 0 };

    SendMessage (hwndStatusBar, SB_SETPARTS, 4, (LPARAM) nPos);
    SendMessage (hwndStatusBar, SB_SETTEXT, SBT_NOBORDERS,
        (LPARAM) "Ready");

    GetKeyboardState (byKeyState);
    if (byKeyState[VK_CAPITAL] & 0x01)
        SendMessage (hwndStatusBar, SB_SETTEXT, 1, (LPARAM) "\tCaps");
    if (byKeyState[VK_NUMLOCK] & 0x01)
        SendMessage (hwndStatusBar, SB_SETTEXT, 2, (LPARAM) "\tNum");
    if (byKeyState[VK_SCROLL] & 0x01)
        SendMessage (hwndStatusBar, SB_SETTEXT, 3, (LPARAM) "\tScrl");
}

void PositionPanes (HWND hwnd, HWND hwndStatusBar)
{
    RECT rect;
    HFONT hFont, hOldFont;
    HDC hdc;
    int nPos[4];
    TEXTMETRIC tm;

    GetWindowRect (hwndStatusBar, &rect);

    hFont = (HFONT) SendMessage (hwndStatusBar, WM_GETFONT, 0, 0);
    if (hFont == NULL)
        hFont = (HFONT) GetStockObject (SYSTEM_FONT);

    hdc = GetDC (hwnd);
    hOldFont = (HFONT) SelectObject (hdc, hFont);
    GetTextMetrics (hdc, &tm);
    SelectObject (hdc, hOldFont);
    ReleaseDC (hwnd, hdc);

    nPos[3] = (rect.right - rect.left) - (tm.tmAveCharWidth * 4);
    nPos[2] = nPos[3] - (tm.tmAveCharWidth * 7);
    nPos[1] = nPos[2] - (tm.tmAveCharWidth * 7);
    nPos[0] = nPos[1] - (tm.tmAveCharWidth * 7);

    SendMessage (hwndStatusBar, SB_SETPARTS, 4, (LPARAM) nPos);
}
