// vblisctl.cpp : Implementation of the CVBListCtrl OLE control class.

#include "stdafx.h"
#include "vblist.h"
#include "vblisctl.h"
#include "vblisppg.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CVBListCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CVBListCtrl, COleControl)
	//{{AFX_MSG_MAP(CVBListCtrl)
	// NOTE - ClassWizard will add and remove message map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CVBListCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CVBListCtrl)
	DISP_FUNCTION(CVBListCtrl, "GetHead", GetHead, VT_BSTR, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "GetTail", GetTail, VT_BSTR, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "RemoveHead", RemoveHead, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "RemoveTail", RemoveTail, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "RemoveAll", RemoveAll, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "GetNext", GetNext, VT_BSTR, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "GetPrev", GetPrev, VT_BSTR, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "Count", Count, VT_I2, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "IsEmpty", IsEmpty, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "AddHead", AddHead, VT_EMPTY, VTS_BSTR)
	DISP_FUNCTION(CVBListCtrl, "AddTail", AddTail, VT_EMPTY, VTS_BSTR)
	DISP_FUNCTION(CVBListCtrl, "GotoHead", GotoHead, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "GotoTail", GotoTail, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "GetCurrent", GetCurrent, VT_BSTR, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "SetCurrent", SetCurrent, VT_EMPTY, VTS_BSTR)
	DISP_FUNCTION(CVBListCtrl, "RemoveCurrent", RemoveCurrent, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "GetCurrentIndex", GetCurrentIndex, VT_I2, VTS_NONE)
	DISP_FUNCTION(CVBListCtrl, "FindFromCurrent", FindFromCurrent, VT_BOOL, VTS_BSTR)
	DISP_FUNCTION(CVBListCtrl, "FindFromStart", FindFromStart, VT_BOOL, VTS_BSTR)
	DISP_FUNCTION(CVBListCtrl, "InsertBefore", InsertBefore, VT_EMPTY, VTS_BSTR)
	DISP_FUNCTION(CVBListCtrl, "InsertAfter", InsertAfter, VT_EMPTY, VTS_BSTR)
	DISP_FUNCTION(CVBListCtrl, "SetCurrentIndex", SetCurrentIndex, VT_EMPTY, VTS_I2)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CVBListCtrl, COleControl)
	//{{AFX_EVENT_MAP(CVBListCtrl)
	// NOTE - ClassWizard will add and remove event map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CVBListCtrl, 1)
	PROPPAGEID(CVblistPropPage::guid)
END_PROPPAGEIDS(CVBListCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CVBListCtrl, "VBLIST.VBListCtrl.1",
	0x7f609160, 0x21eb, 0x11cf, 0xae, 0x93, 0x80, 0xec, 0xfd, 0xc0, 0x0, 0x0)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CVBListCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DVBList =
		{ 0x7f609161, 0x21eb, 0x11cf, { 0xae, 0x93, 0x80, 0xec, 0xfd, 0xc0, 0x0, 0x0 } };
const IID BASED_CODE IID_DVBListEvents =
		{ 0x7f609162, 0x21eb, 0x11cf, { 0xae, 0x93, 0x80, 0xec, 0xfd, 0xc0, 0x0, 0x0 } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwVBListOleMisc =
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CVBListCtrl, IDS_VBLIST, _dwVBListOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CVBListCtrl::CVBListCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CVBListCtrl

BOOL CVBListCtrl::CVBListCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_VBLIST,
			IDB_VBLIST,
			FALSE,                      //  Not insertable
			_dwVBListOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CVBListCtrl::CVBListCtrl - Constructor

CVBListCtrl::CVBListCtrl()
{
	InitializeIIDs(&IID_DVBList, &IID_DVBListEvents);

	// Reset the current position pointer for the list to NULL
	m_CurrentPosition = NULL;
}


/////////////////////////////////////////////////////////////////////////////
// CVBListCtrl::~CVBListCtrl - Destructor

CVBListCtrl::~CVBListCtrl()
{
}


/////////////////////////////////////////////////////////////////////////////
// CVBListCtrl::OnDraw - Drawing function

void CVBListCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	// TODO: Replace the following code with your own drawing code.
	pdc->FillRect(rcBounds, CBrush::FromHandle((HBRUSH)GetStockObject(WHITE_BRUSH)));
	pdc->Ellipse(rcBounds);
}


/////////////////////////////////////////////////////////////////////////////
// CVBListCtrl::DoPropExchange - Persistence support

void CVBListCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.

}


/////////////////////////////////////////////////////////////////////////////
// CVBListCtrl::OnResetState - Reset control to default state

void CVBListCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}

/////////////////////////////////////////////////////////////////////////////
// CVBListCtrl message handlers

void CVBListCtrl::AddHead(LPCTSTR Value) 
{
	m_CurrentPosition = m_StringList.AddHead(Value);
}

void CVBListCtrl::AddTail(LPCTSTR Value) 
{
	m_CurrentPosition = m_StringList.AddTail(Value);
}

BSTR CVBListCtrl::GetHead() 
{
	CString s = m_StringList.GetHead();
	GotoHead();
	return s.AllocSysString();
}

BSTR CVBListCtrl::GetTail() 
{
	CString s = m_StringList.GetTail();
	GotoTail();
	return s.AllocSysString();
}

void CVBListCtrl::RemoveHead() 
{
	m_StringList.RemoveHead();
	GotoHead();
}

void CVBListCtrl::RemoveTail() 
{
	m_StringList.RemoveTail();
	GotoTail();
}

void CVBListCtrl::RemoveAll() 
{
	m_StringList.RemoveAll();
	m_CurrentPosition = NULL;
}

BSTR CVBListCtrl::GetNext() 
{
	CString s = "";
	if (m_CurrentPosition != NULL)
		s = m_StringList.GetNext(m_CurrentPosition);
	return s.AllocSysString();
}

BSTR CVBListCtrl::GetPrev() 
{
	CString s = "";
	if (m_CurrentPosition != NULL)
		s = m_StringList.GetPrev(m_CurrentPosition);
	return s.AllocSysString();
}

short CVBListCtrl::Count() 
{
	return m_StringList.GetCount();
}

BOOL CVBListCtrl::IsEmpty() 
{
	return m_StringList.IsEmpty();
}

void CVBListCtrl::GotoHead()
{
	m_CurrentPosition = m_StringList.GetHeadPosition();
}

void CVBListCtrl::GotoTail()
{
	m_CurrentPosition = m_StringList.GetTailPosition();
}

BSTR CVBListCtrl::GetCurrent() 
{
	CString s = "";
	if (m_CurrentPosition != NULL)
		s = m_StringList.GetAt(m_CurrentPosition);	
	return s.AllocSysString();
}

void CVBListCtrl::SetCurrent(LPCTSTR Value) 
{
	if (m_CurrentPosition != NULL)
		m_StringList.SetAt(m_CurrentPosition, Value);
}

void CVBListCtrl::RemoveCurrent() 
{
	if (m_CurrentPosition != NULL)
		m_StringList.RemoveAt(m_CurrentPosition);
}

// Return a 0-based index to the current position in the list
short CVBListCtrl::GetCurrentIndex() 
{
	short iIndex = -1;
	POSITION posCurrent = m_CurrentPosition;

	while (posCurrent != NULL) {
		iIndex++;
		(void) m_StringList.GetPrev(posCurrent);
	}

	return iIndex;
}

// Try to find SearchValue in the list from the current position. If successful, set the 
// current position to the desired element
BOOL CVBListCtrl::FindFromCurrent(LPCTSTR SearchValue) 
{
	if (m_CurrentPosition != NULL)
		if ((m_CurrentPosition = m_StringList.Find(SearchValue, m_CurrentPosition)) != NULL)
			return TRUE;
	return FALSE;
}

// Try to find SearchValue in the list from the start of the list. If successful, set the 
// current position to the desired element
BOOL CVBListCtrl::FindFromStart(LPCTSTR SearchValue) 
{	
	if (m_CurrentPosition != NULL)
		if ((m_CurrentPosition = m_StringList.Find(SearchValue, NULL)) != NULL)
			return TRUE;
	return FALSE;
}

// Insert new element before the current element in the list. Fails if there are no elements
// in the list, or we are not at a current element in the list.
void CVBListCtrl::InsertBefore(LPCTSTR Value) 
{
	if (m_CurrentPosition != NULL)
		m_StringList.InsertBefore(m_CurrentPosition, Value);
}

// Insert new element after the current element in the list. Fails if there are no elements
// in the list, or we are not at a current element in the list.
void CVBListCtrl::InsertAfter(LPCTSTR Value) 
{
	if (m_CurrentPosition != NULL)
		m_StringList.InsertAfter(m_CurrentPosition, Value);
}

// Set the current position pointer to the element in the list specified by Index. Fails if
// there are not enough elements in the list to accomodate Index.
void CVBListCtrl::SetCurrentIndex(short Index) 
{
	short iCount = Index;
	POSITION posCurrent = m_StringList.GetHeadPosition();

	if (Index < m_StringList.GetCount()) {
		while (Index > 0) {
			(void) m_StringList.GetNext(posCurrent);
			Index--;
		}
		m_CurrentPosition = posCurrent;
	}
}
