/* MCI REXX Sample #5 */
/* this script shows you how to determine where the output of CD music*/
/* goes.  It also illustrates how to poll the CD device to determine  */
/* when it reaches a desired position                                 */
/* The user specifies the track they wish to play and how long within */
/* the track and we take care of the rest.                            */

signal on error /* When commands fail, call "error" routine. */

  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

/* retrieve command line arguments for stream.cmd */
parse arg arg1 arg2

If (arg1='') Then
   do
   /* users must send the track they wish to play */

   say 'Stream example command uses two parameters'
   say 'stream TRACK [time]'
   say 'TRACK specifies the track to play and is required.'
   say 'time is option and specifies the amount of time in the track to play'
   exit 1
   End
ELSE
   do
   track = arg1
   END

/* Convert seconds into milliseconds (which we use for time calculations) */

If (arg2='') Then
   do
   maxtime = 10000
   End
ELSE
   do
   maxtime = arg2 * 1000
   END

/* Initialize multimedia functions */

rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
rc = RXFUNCADD('mciRxGetErrorString','MCIAPI','mciRxGetErrorString')

InitRC = mciRxInit()

/* Open the CD */

rc = mciRxSendString("open cdaudio alias supercd wait", 'Retst', '0', '0')

/* Ensure that the user has a CD in the drive */

rc = mciRxSendString("status supercd media present wait", 'Retst', '0', '0')
If Retst <> 'TRUE' then
     do
     say 'Must have CD inserted to run this command file'
     say 'Please insert'
     rc = mciRxSendString("status supercd media present wait", 'Retst', '0', '0')

       do while Retst <> 'TRUE'
         rc = mciRxSendString("status supercd media present wait", 'Retst', '0', '0')
       End
     End


rc = mciRxSendString("status supercd number of tracks wait", 'Retst', '0', '0')
If track > Retst then
    do
      say 'CD only has ' Retst ' tracks'
      rc = mciRxSendString("close supercd wait", 'Retst', '0', '0')
      exit 1
    End

/* ask the user if they want digital transfer */

say 'Use Digital Transfer (Y/N)'

quit = FALSE

do while quit <> 'TRUE'
   keyin = SysGetKey('NOECHO')
   IF keyin = 'Y' | keyin = 'y'
     THEN
       do
       quit = TRUE
       digital = 1
       /* Ask the device if it supports digital transfer   */
       /* Its always been to ask BEFORE rather than hoping */
       /* it will work in the future.                      */

       rc = mciRxSendString("capability supercd can stream wait", 'Retst', '0', '0')


       If Retst = 'TRUE' THEN
          do

          /* This command enables digital transfer (if it is supported ) */
          rc = mciRxSendString("connector supercd enable type cd stream wait", 'Retst', '0', '0')

          /* make sure the command works */

          IF rc <> 0 THEN
             do
             /* mciRxGetErrorString  takes an error and returns an error message */

             frc = mciRxGetErrorString(rc, 'errstr')
             say 'Digital Transfer error was : ' errstr
             say 'Using normal playback instead'
             END
          ELSE
            say 'Digital Transfer enabled for ' maxtime / 1000 ' seconds'
   
           END
        END
       ELSE
         say "this drive doesn't support digital transfer--sorry"
   IF keyin = 'n' | keyin = 'n'
     THEN
       do
       quit = TRUE
       digital = 1
       say 'Normal playback in use for 'maxtime / 1000' seconds'
       END

END

/* we will set the time format to track oriented, then seek to the desired */
/* track.  When you are in track-minutes-seconds-frames format, its easy   */
/* to perform track oriented manipulations.                                */

rc = mciRxSendString("set supercd time format tmsf wait", 'Retst', '0', '0')
seekcommand = 'seek supercd to' track ' wait'
rc = mciRxSendString(seekcommand, 'Retst', '0', '0')

/* calculate time offsets from the beginning of the track                  */
/* use milliseconds since its easier to determine time offsets in this     */
/* rather than converting a track offset into a time unit                  */

rc = mciRxSendString("set supercd time format ms wait", 'Retst', '0', '0')
rc = mciRxSendString("status supercd position wait", 'time', '0', '0')

rc = mciRxSendString("play supercd ", 'Retst', '0', '0')

maxtime = maxtime + time

/* loop until the desire number of milliseconds have passed */

do while time < maxtime
  rc = mciRxSendString("status supercd position wait", 'time', '0', '0')
  END


rc = mciRxSendString("close supercd wait", 'Retst', '0', '0')

say 'Finished SuperCD streaming example'
exit


error:
   say 'Error' ErrRC 'at line' sigl ', sourceline:' sourceline(sigl)
   say 'Terminating'
   mciRxSendString("close supercd wait", 'Retst', '0', '0')
   mciRxExit()               /* Tell the DLL we're going away */
   exit ErrRC                /* exit, tell caller things went poorly */

halt:
/*
 * Close all device alias's, in case we previously killed
 * this batch file in the same process.
 */
   say 'Terminating'
  mciRxSendString("close supercd wait", 'Retst', '0', '0')
exit

