/* MCI REXX Sample #8 */
/* Sample REXX Script */
/* this script shows you how to gracefully recover from Invalid media */
/* type errors (these occur when the wrong media (or file) is loaded  */
/* into the driver.                                                   */

rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
InitRC = mciRxInit()

/* Open the wave driver */

rc = mciRxSendString("open waveaudio alias error shareable wait", 'Retst', '0', '0')
rc = mciRxSendString("load error d:\mmos2\movies\macaw.avi wait", 'Retst', '0', '0')
if ( rc <> 0 ) then
   do
   /* the upper 16-bits of an multimedia error is the device id--remove it
   * since we only care about the lower 16-bits.                            */
   if rc > 65536 then
     do
     temp = rc - 65536
     rc = temp
     end
   /* Invalid media type error is 5051 */
   if rc = 5051 then
     say "Wave driver can't play this file format"
   else
     do
     rc = mciRxGetErrorString(rc, 'errstr')
     say 'errstr is ' errstr
     end
   END
rc = mciRxSendString("close rexxtracks wait", 'Retst', '0', '0')
say 'Finished invalid media type example example'
exit

