//***************************************************************************
//
//  App4Lib counts instances of App4 that are running.
//
//***************************************************************************

#include <windows.h>

__declspec (dllexport) LONG GetInstanceCount (void);
__declspec (dllexport) LONG IncrementInstanceCount (void);
__declspec (dllexport) LONG DecrementInstanceCount (void);

BOOL WINAPI DllMain (HINSTANCE, DWORD, LPVOID);

/////////////////////////////////////////////////////////////////////////////
// Shared global data
//
// IMPORTANT: This DLL must be linked with a /SECTION:Shared,RWS switch
// so "Shared" will be a shared data segment

#pragma data_seg ("Shared")
LONG    g_lInstanceCount = 0;
#pragma data_seg ()

/////////////////////////////////////////////////////////////////////////////
// DllMain

BOOL WINAPI DllMain (HINSTANCE hInstance, DWORD dwReason, LPVOID lpvReserved)
{
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// Exported functions

__declspec (dllexport) LONG GetInstanceCount (void)
{
    return g_lInstanceCount;
}

__declspec (dllexport) LONG IncrementInstanceCount (void)
{
    InterlockedIncrement (&g_lInstanceCount);
    return g_lInstanceCount;
}

__declspec (dllexport) LONG DecrementInstanceCount (void)
{
    InterlockedDecrement (&g_lInstanceCount);
    return g_lInstanceCount;
}
