VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "PageCount"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' The Viper Page Counter component.
' Copyright(C) 1997 John Lam
'
' This component is based on the Receipt sample in the Viper
' (Microsoft Transaction Server) documentation.
'
' This component implements a stateful Page Counter. The component's state
' is stored between calls to the GetPageCount function using the SharedPropertyManager.
'
' This component reserves a range of page counts in the Counter table within the
' IUnknown database. This is where the persistent state is stored.
'
' When this component detects that it has run out of page counts, it goes back
' to the Counter table to reserve an additional block of page counts. While this
' doesn't guarantee accuracy in the event of server failure, it will at least
' guarantee that we are within +/-100 per server failure.

Option Explicit
Private Const ERROR_NUMBER = vbObjectError + 0 ' we always return the same error number

Public Function GetPageCount() As Long
    
    ' get object context
    Dim ctxObject As ObjectContext
    Set ctxObject = GetObjectContext()
        
    On Error GoTo ErrorHandler
    
    ' if Shared property does not already exist it will be initialized
    Dim spmMgr As SharedPropertyGroupManager
    Set spmMgr = CreateObject("MTxSpm.SharedPropertyGroupManager.1")

    Dim spmGroup As SharedPropertyGroup
    Dim bResult As Boolean
    Set spmGroup = spmMgr.CreatePropertyGroup("Counter", LockSetGet, Process, bResult)

    Dim spmPropNextCount As SharedProperty
    Set spmPropNextCount = spmGroup.CreateProperty("Next", bResult)

    Dim spmPropMaxNum As SharedProperty
    Set spmPropMaxNum = spmGroup.CreateProperty("MaxNum", bResult)
  
    Dim objCounterUpdate As ViperCounter.UpdatePageCount
    If spmPropNextCount.Value >= spmPropMaxNum.Value Then
    
        ' We must update the counter value in SQL Server
        Set objCounterUpdate = ctxObject.CreateInstance("ViperCounter.UpdatePageCount")
        spmPropNextCount.Value = objCounterUpdate.Update
        spmPropMaxNum.Value = spmPropNextCount.Value + 100
        
    End If

    ' Get the next page count number and update property
    spmPropNextCount.Value = spmPropNextCount.Value + 1

    ' Tell Viper that we are no longer holding onto significant state, and that
    ' it can destroy us if it wants
    GetPageCount = spmPropNextCount.Value
    ctxObject.SetComplete
   
    Exit Function
    
ErrorHandler:

    ' An error condition occured within this function. Report that an error
    ' occurred by returning -1, and flag to Viper that it can destroy us
    GetPageCount = -1            ' indicate that an error occured
    ctxObject.SetAbort
    
End Function

