VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "UpdatePageCount"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' The Viper Page Counter component. Based on the Receipt sample in the
' Viper documentation. This component now uses ADO as opposed to RDO.
'
' Copyright(C) 1997 John Lam

Option Explicit

Private Const ERROR_NUMBER = vbObjectError + 0 ' we always return the same error number

' Note that this contains the connect string. The user id and password are
' intentionally omitted ...
Private Const strConnect = "DSN=SQL Server;UID=;PWD=;"

Public Function Update() As Long
    
    ' Get object context
    Dim ctxObject As ObjectContext
    Set ctxObject = GetObjectContext()
    
    ' Assume that if there is an rdo error then the receipt
    ' table does not exist
    On Error GoTo ErrorCreateTable
    
    ' setup ADO connection
    Dim adoConn As New ADODB.Connection
    adoConn.ConnectionTimeout = 15
    adoConn.CommandTimeout = 30
    adoConn.Open strConnect
    
    ' setup ADO command object
    Dim adoCommand As New ADODB.Command
    adoCommand.CommandText = "SELECT * FROM Counter2"
    adoCommand.CommandType = adCmdText
    Set adoCommand.ActiveConnection = adoConn
    
    ' setup ADO recordset
    Dim lngNextCount As Long
    Dim adoRecordset As New ADODB.Recordset
    
TryAgain:
    adoRecordset.Open adoCommand, , adOpenKeyset, adLockOptimistic
    
    ' Reset the Error handler to handle any further errors
    On Error GoTo ErrorHandler
    
    ' Retrieve the next receipt and update the receipt within the context of a
    ' transaction
    lngNextCount = adoRecordset("NextCount")
    adoRecordset.Close
    
    ' Perform an update query from within the context of the transaction to
    ' update our page counter numbers
    Dim adoCommand2 As New ADODB.Command
    adoCommand2.CommandText = "UPDATE Counter2 SET NextCount = " & (lngNextCount + 100)
    adoCommand2.CommandType = adCmdText
    Set adoCommand2.ActiveConnection = adoConn
    adoCommand2.Execute
    
    adoConn.Close
    
    ' Tell MTS that we are done
    ctxObject.SetComplete
    Update = lngNextCount
  
    Exit Function

ErrorCreateTable:

    On Error GoTo ErrorHandler
   
    ' create the receipt table
    Dim objCreateTable As CreateTable
    Set objCreateTable = CreateObject("ViperCounter.CreateTable")
    objCreateTable.CreateCounterTable
      
    GoTo TryAgain
    
ErrorHandler:

    If Not adoConn Is Nothing Then
        adoConn.Close
    End If
    
    ctxObject.SetAbort
    Update = -1
    
End Function

