;INSTALL.COM for the IBM Personal Computer - 1987 by Jeff Prosise
;
code          segment para public 'code'
              assume cs:code
              org 100h
begin:        jmp install                   ;skip data area
;
tsr_count          dw 0                     ;number of TSR's installed
segment_table      dw 64 dup (?)            ;wedge program segments
vector_table       db 1024 dup (?)          ;vector table storage area
first_call         db 0                     ;INSTALL status flag
old1Ah             label dword              ;storage for interrupt 1Ah vector
old1Ah_vector      dw 2 dup (?)
errmsg             db 13,10,'No room for more',13,10,'$'
;
copyright          db 'Copyright 1987 Ziff-Davis Publishing Co.'
author             db 'Jeff Prosise'
;
;------------------------------------------------------------------------------
;NEW1AH routine intercepts calls to interrupt 1Ah.  If the function code in AH
;is 44h, then the Installation Data Table (IDT) segment is returned in ES.
;------------------------------------------------------------------------------
new1Ah        proc near
              sti                           ;enable interrupts
              cmp ah,44h                    ;is the function code 44h?
              je new1Ah1                    ;yes, then handle the call here
              jmp old1Ah                    ;jump to the real int 1Ah handler
new1Ah1:      push cs                       ;place current code segment in ES
              pop es
              dec bh                        ;decrement BH to verify call
              iret                          ;return to calling routine
new1Ah        endp
;
;------------------------------------------------------------------------------
;INSTALL routine saves pertinent data needed for deinstallation.
;------------------------------------------------------------------------------
install       proc near
              assume ds:code
;
;Begin by determining if this is the first call to INSTALL.
;
              mov ah,44h                    ;call int 1Ah, function 44h
              xor bh,bh                     ;zero BH
              int 1Ah
              cmp bh,0FFh                   ;BH=0FFh?
              je install1                   ;yes, then INSTALL is resident
              mov first_call,1              ;no, then this is the first call
;
;See if there is room to record the installation of another TSR.
;
install1:     mov di,offset tsr_count       ;point DI to installation count
              cmp word ptr es:[di],32       ;still room for more TSR's?
              jb install2                   ;yes, then continue
              mov ah,9                      ;no, then print error message
              lea dx,errmsg
              int 21h
              ret                           ;terminate
;
;Increment the count of TSR's installed and record current PSP and environment
;block segment values.
;
install2:     mov ax,es:[di]                ;get TSR count in AX
              inc word ptr es:[di]          ;increment count
              mov cl,2                      ;multiply by 4
              shl ax,cl
              add ax,offset segment_table   ;complete offset address
              mov di,ax                     ;transfer to DI
              mov es:[di],cs                ;save current code segment value
              mov ax,cs:[2Ch]               ;get env block segment from PSP
              mov es:[di+2],ax              ;store it
;
;Copy the interrupt vector table from low memory into storage.
;
              push ds                       ;save DS
              xor ax,ax                     ;point DS:SI to int vector table
              mov ds,ax
              assume ds:nothing
              xor si,si
              push cs                       ;point ES:DI to storage area
              pop es
              lea di,vector_table
              mov cx,512                    ;512 words to move
              cld                           ;clear DF
              cli                           ;suspend interrupts during move
              rep movsw                     ;copy vector table
              sti                           ;restore interrupts
              pop ds                        ;restore DS
              assume ds:code
;
;If INSTALL hasn't been called once before, reset the interrupt 1Ah vector.
;
              cmp first_call,0              ;is this the first call?
              je install3                   ;no, then skip ahead
              mov ax,351Ah                  ;get old interrupt 1Ah vector
              int 21h
              mov old1Ah_vector,bx          ;store it
              mov old1Ah_vector[2],es
              mov ah,25h                    ;point vector to NEW16H routine
              lea dx,new1Ah
              int 21h
;
;Terminate-but-stay-resident.
;
install3:     mov dx,offset install         ;point DX to end
              int 27h                       ;terminate-but-stay-resident
install       endp
;
code          ends
              end begin
