PROGRAM Delete;

VAR
  ioCode : Byte;
  FileVar : FILE;
  FileName : STRING[255];

  PROCEDURE ioError(ioCode : Byte);
  BEGIN
    Write(#7, 'I/O result of ', ioCode, ' (decimal) ', #26, ' ');
    CASE ioCode OF
      $01 : WriteLn('Filename not found.');
      $20 : WriteLn('Illegal operation for a logical device.');
      $F3 : WriteLn('Too many files open.');
    ELSE WriteLn('Unknown I/O error.');
    END;
  END;

BEGIN
  Write('Delete file : ');
  ReadLn(FileName);
  Assign(FileVar, FileName);
  {$I-} Erase(FileVar);       {$I+}
  ioCode := IOResult;
  IF ioCode <> 0 THEN ioError(ioCode)
  ELSE WriteLn('File deleted.')
END.
