        title   TRYFTRIG --- Demo of FTRIG routines
        page    55,132

; TRYFTRIG.ASM --- Interactive Demo of FTRIG routines
;
; To exit from the program, push <Enter>
; alone at the "Enter a number" prompt.
;
; (C) 1989 Ray Duncan
;
; Build with:   MASM FTOA;
;               MASM ATOF;
;               MASM FTRIG;
;               MASM FALOG;
;               MASM INIT87;
;               MASM TRYFTRIG;
;               LINK TRYFTRIG+FTOA+ATOF+FTRIG+FALOT+INIT87;
;

cr      equ     0dh                     ; ASCII carriage return
lf      equ     0ah                     ; ASCII line feed

stdin   equ     0                       ; standard input handle
stdout  equ     1                       ; standard output handle

DGROUP  group   _DATA,STACK

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT,ds:DGROUP

        extrn   ATOF:near               ; ASCII to floating point
        extrn   FTOA:near               ; floating point to ASCII
        extrn   FSIN:near               ; 80x87 sine
        extrn   FCOS:near               ; 80x87 cosine
        extrn   FTAN:near               ; 80x87 tangent
        extrn   INIT87:near             ; initialize numeric coprocessor

main    proc    near

        mov     ax,DGROUP               ; make our data segment
        mov     ds,ax                   ; addressable...
        mov     es,ax
        
        mov     ax,03ffh                ; initialize coprocessor
        call    init87                  ; rounding = nearest or even
                                        ; precision = 64 bits
                                        ; mask all exceptions

        jz      main1                   ; jump, coprocessor present

        mov     dx,offset errmsg        ; coprocessor absent,
        mov     cx,err_len              ; display error message
        call    pmsg                    ; and terminate program
        jmp     main3

main1:  mov     dx,offset signon        ; display sign-on message
        mov     cx,so_len
        call    pmsg

main2:  mov     dx,offset prompt1       ; display prompt
        mov     cx,p1_len
        call    pmsg                   

        mov     dx,offset inbuff        ; read keyboard entry
        mov     cx,80                   ; from the user...
        mov     bx,stdin                ; standard input handle
        mov     ah,3fh                  ; funct. 3FH = read
        int     21h                     ; transfer to MS-DOS

        cmp     byte ptr inbuff,cr      ; was anything entered?
        jne     main4                   ; yes, proceed

main3:  mov     ax,4c00h                ; no, exit to MS-DOS
        int     21h

main4:  mov     si,offset inbuff        ; convert convert user's 
        call    atof                    ; input to binary in ST(0)

        fld     st(0)                   ; duplicate the value
        fmul    qword ptr deg2rad       ; convert it to radians 
        fstp    qword ptr arg           ; save angle in radians

        mov     al,' '                  ; clear output format areas
        mov     di,offset disp1 
        mov     cx,30
        rep stosb
        mov     di,offset disp2
        mov     cx,30
        rep stosb
        mov     di,offset disp3
        mov     cx,30
        rep stosb
        mov     di,offset disp4
        mov     cx,30
        rep stosb
        mov     di,offset disp5
        mov     cx,30
        rep stosb

        mov     si,offset disp1         ; convert degrees to ASCII
        call    ftoa

        fld     qword ptr arg           ; convert radians to ASCII
        mov     si,offset disp2
        call    ftoa

        fld     qword ptr arg           ; load radians
        call    fsin                    ; calculate sine
        mov     si,offset disp3         ; convert sine to ASCII
        call    ftoa

        fld     qword ptr arg           ; load radians
        call    fcos                    ; calculate cosine
        mov     si,offset disp4         ; convert cosine to ASCII
        call    ftoa

        fld     qword ptr arg           ; load radians
        call    ftan                    ; calculate tangent
        mov     si,offset disp5         ; convert tangent to ASCII
        call    ftoa

        mov     dx,offset display       ; display original angle,
        mov     cx,d_len                ; angle in radians, sine,
        call    pmsg                    ; cosine, and tangent

        jmp     main2                   ; do it again...

main    endp


pmsg    proc    near                    ; display message on stdout
                                        ; call with 
                                        ; DS:DX = message address
                                        ; CX    = message length

        mov     bx,stdout               ; standard output handle
        mov     ah,40h                  ; function 40h = write
        int     21h                     ; transfer to MS-DOS
        ret                             ; return to caller

pmsg    endp

_TEXT   ends


_DATA   segment word public 'DATA'

signon  db      cr,lf
        db      'Demo Program for Coprocessor Trig Routines.'
        db      cr,lf,lf
        db      'Specify angle in degrees as a signed decimal value'
        db      cr,lf
        db      'followed by the <Enter> key.  The sine, cosine,'
        db      cr,lf
        db      'and tangent of the value are displayed.'
        db      cr,lf,lf
        db      'Press <Enter> alone at any prompt to exit.'
        db      cr,lf

so_len  equ     $-signon

prompt1 db      cr,lf
        db      'Enter angle (degrees): '
p1_len  equ     $-prompt1

display db      cr,lf
        db      'Degrees:  '
disp1   db      30 dup (' ')
        db      cr,lf
        db      'Radians:  '
disp2   db      30 dup (' ')
        db      cr,lf
        db      'Sine:     '
disp3   db      30 dup (' ')
        db      cr,lf
        db      'Cosine:   '
disp4   db      30 dup (' ')
        db      cr,lf
        db      'Tangent:  '
disp5   db      30 dup (' ')
        db      cr,lf
d_len   equ     $-display

errmsg  db      cr,lf
        db      'No 80x87 coprocessor found!'
        db      cr,lf
err_len equ     $-errmsg

deg2rad dq      3f91df46a2529d39h       ; 2 * pi / 360

arg     dq      0                       ; angle in radians

inbuff  db      80 dup (?)              ; keyboard input buffer

_DATA   ends


STACK   segment para stack 'STACK'
        
        db      128 dup (?)

STACK   ends

        end     main

