/*--------------------------------------------------------------
   METAFILE.C -- Demonstrates GPI metafile creation and playing
                 (c) Ziff Communications Co, 1990
                 PC Magazine * Charles Petzold, 6/90
  --------------------------------------------------------------*/

#define INCL_GPI
#include <os2.h>

MRESULT EXPENTRY ClientWndProc  (HWND, USHORT, MPARAM, MPARAM) ;
HMF              CreateMetaFile (void) ;

HAB  hab ;

int main (void)
     {
     static CHAR  szClientClass[] = "Metafile" ;
     static ULONG flFrameFlags = FCF_TITLEBAR      | FCF_SYSMENU |
                                 FCF_SIZEBORDER    | FCF_MINMAX  |
                                 FCF_SHELLPOSITION | FCF_TASKLIST ;
     HMQ          hmq ;
     HWND         hwndFrame, hwndClient ;
     QMSG         qmsg ;

     hab = WinInitialize (0) ;
     hmq = WinCreateMsgQueue (hab, 0) ;
     WinRegisterClass (hab, szClientClass, ClientWndProc, CS_SIZEREDRAW, 0) ;

     hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
                                     &flFrameFlags, szClientClass, NULL,
                                     0L, 0, 0, &hwndClient) ;

     while (WinGetMsg (hab, &qmsg, NULL, 0, 0))
          WinDispatchMsg (hab, &qmsg) ;

     WinDestroyWindow (hwndFrame) ;
     WinDestroyMsgQueue (hmq) ;
     WinTerminate (hab) ;
     return 0 ;
     }

MRESULT EXPENTRY ClientWndProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
     {
     static CHAR szFilename [] = "HOUSE.MET" ;
     static HMF  hmf ;
     HPS         hps ;

     switch (msg)
          {
          case WM_CREATE:
               hmf = CreateMetaFile () ;
               return 0 ;

          case WM_PAINT:
               hps = WinBeginPaint (hwnd, NULL, NULL) ;
               GpiErase (hps) ;

               GpiPlayMetaFile (hps, hmf, 0L, NULL, NULL, 0L, NULL) ;

               WinEndPaint (hps) ;
               return 0 ;

          case WM_DESTROY:
               DosDelete (szFilename, 0L) ;
               GpiSaveMetaFile (hmf, szFilename) ;
               return 0 ;
          }
     return WinDefWindowProc (hwnd, msg, mp1, mp2) ;
     }

HMF CreateMetaFile (void)
     {
     static DEVOPENSTRUC dop = { NULL, "DISPLAY" } ;
     static POINTL       aptl[] = { 0,0,  0,100,   50,150,  100,100,
                                    0,0,  100,0,  100,100,    0,100,  100,0 } ;
     HDC                 hdcMetafile ;
     HMF                 hmf ;
     HPS                 hps ;
     SIZEL               sizlPage ;

               // Open a metafile device context

     hdcMetafile = DevOpenDC (hab, OD_METAFILE, "*", 2L,
                              (PDEVOPENDATA) &dop, NULL) ;

               // Create a presentation space associated with that DC

     sizlPage.cx = 100 ;
     sizlPage.cy = 150 ;

     hps = GpiCreatePS (hab, hdcMetafile, &sizlPage,
                        GPIT_MICRO | GPIA_ASSOC | PU_LOENGLISH) ;

               // Draw a house using eight lines

     GpiMove (hps, aptl) ;
     GpiPolyLine (hps, 8L, aptl + 1) ;

               // Destroy the presentation space

     GpiDestroyPS (hps) ;

               // Close the device context to get the metafile handle

     hmf = DevCloseDC (hdcMetafile) ;

     return hmf ;
     }
