// wsmooth2.c RHS adjunct routines for WinSmooth

#include<windows.h>
#include"wsmooth.h"
#include"wsmooth2.h"
#include<stdio.h>
#include<stdarg.h>
#include<malloc.h>
#include<string.h>
#include<stdlib.h>
#include"filebuf.h"


BOOL getoption(int *setting,char *str,char *op1,char *op2,char *op3,char *op4);

char mbuf[250];
   // general message-to-user handler, like a printf for Windows
void cdecl Message(HWND hwnd, char *format, ...)
    {
    va_list marker;

    va_start(marker, format);
    vsprintf(mbuf,format, marker);
    va_end(marker);

    MessageBox(hwnd,mbuf,"WinSmooth",MB_OK | MB_ICONEXCLAMATION);
    }

extern SETTINGS settings;
extern HWND WinSmooth;
extern char windowname[128];
extern char filename[128];

   // updates WinSmooth title bar
void ChangeTitleBar(char *target)
    {
    char *p = strchr(windowname,' ');

    if(!p)
        p = &windowname[strlen(windowname)];
    *p = '\0';

    strcpy(filename,target);
    strupr(filename);
    strcat(windowname," ");
    strcat(windowname,filename);
    SetWindowText(WinSmooth,(LPSTR)windowname);
    }

   // general function for initializing buffers and opening file
int WSopenfile(char *target)
    {
    BOOL retval = TRUE;

    if(WinSmooth)
        SendMessage(WinSmooth,WM_WSM_HOURGLASS_CURSOR,0,0L);
    if(!filebuf_init())
        {
        SendMessage(WinSmooth,WM_WSM_NORMAL_CURSOR,0,0L);
        Message(WinSmooth,"Fatal Error Initializing File Buffers!");
        retval = FALSE;
        }
    else if(!filebuf_open(target,settings.stripbits))
        retval = FALSE;

    if(WinSmooth)
        {
        ChangeTitleBar(target);
        SendMessage(WinSmooth,WM_WSM_NORMAL_CURSOR,0,0L);
        }
    return retval;
    }

   // reads filename and command-line options
void process_cmdline(char *buffer)
    {
    char *p;
    int setting;
    
    if(p = strchr(buffer,' '))                  // find space after filename
        {
        *p++ = '\0';
        if(getoption(&setting,p,"/M","/m","-M","-m"))
            if(setting >= MINMSECS && setting <= MAXMSECS)
                settings.Msecs = setting;
            else
                Message(WinSmooth,"Value %u for /M option out-of-range: using default",
                    setting);
        if(getoption(&setting,p,"/P","/p","-P","-p"))
            if(setting >= MINPIXELROWS && setting <= MAXPIXELROWS)
                settings.PixelRows = setting;
            else
                Message(WinSmooth,"Value %u for /P option out-of-range: using default",
                    setting);
        setting = getoption(&settings.Msecs,p,"/W","/w","-W","-w");
        }
    }

BOOL getoption(int *setting,char *str,char *op1,char *op2,char *op3,char *op4)
    {
    char *ptr, *ptr2, temp[30];

    if((ptr = strstr(str,op1)) ||
                (ptr = strstr(str,op2)) ||
                (ptr = strstr(str,op3)) ||
                (ptr = strstr(str,op4)))
        {
        ptr += 2;
        strcpy(temp,ptr);
        ptr = temp;
        if(ptr2 = strchr(ptr,' '))
            *ptr2 = '\0';
        *setting = atoi(ptr);
        return TRUE;
        }
    return FALSE;
    }



// end of wsmooth2.c
