/*
 * ATFLOAT -- PC Tech Journal Floating-Point Performance Test
 *
 * Version 1.00
 * Last modified 05/23/86
 * Copyright (c) 1986, PC Tech Journal
 * Program by: Paul Pierce, Ted Forgeron, Steven Armbrust
 *
 * Measures the time it takes to multiply two matrices of
 * double-precision floating-point numbers and compares it
 * to the time it takes an 8MHz PC/AT with an 80287 math
 * coprocessor to do the same.
 */

/* Number of iterations the test runs for. */
#define TRIALS 100

/* Dimension of the matrix */
#define SIZE 20

unsigned long time();
unsigned rand();

double drand()
{

        return (double)rand() / 32767;
}

double a[SIZE][SIZE];
double b[SIZE][SIZE];

main()
{
        int i;
        register j, k;
        int n;
        unsigned long start;
        unsigned long total;
        unsigned trials;
        double t;

        trials = TRIALS;

        /*
         * Fill matrix with random numbers.
         */

        for (i = 0; i < SIZE; i++)
                for (j = 0; j < SIZE; j++)
                        a[i][j] = drand();

        /*
         * Repeatedly multiply the matrices and
         * report the relative and absolute times.
         */

        start = time();
        printf("\nATFLOAT -- PC Tech Journal AT Floating-Point");
        printf(" Performance Test\n");
        printf("Version 1.00, Copyright (c) 1986 PC Tech ");
        printf("Journal\n");
        printf("\nThis test runs for %d iterations ...\n", trials);
        for (n = 1; n <= trials; n++) {
                printf("%d\r", n);
                for (i = 0; i < SIZE; i++) {
                        for (j = 0; j < SIZE; j++) {
                                t = 0;
                                for (k = 0; k < SIZE; k++)
                                        t += a[k][j] * a[i][k];
                                b[i][j] = t;
                        }
                }
        }
        total = time() - start;
        printf("\rElapsed time is %ld seconds.\n\n", total, trials);
        printf("Floating-point performance index relative\n");
        printf("to 8MHz IBM PC/AT with 80287 = %2.1f\n",
                94.0 / (float) total);

}
