#   This is the make file for HLBENCH and its companions in the benchmark
#   suite.  It is designed to be used with Microsoft C 5.1 and its make 
#   utility.

#  The options to the compiler include -Zi (include debugging info),
#  -AM (use Medium model), and -Oait (lots of optimization, but don't
#  do the various loop optimizations).	The output is redirected to
#  an error file for later reference.
#  The -Zi switch doesn't increase the size of the excutable, only the
#  objects; it seems worth it to leave it in rather than have to recompile
#  everything for debugging.

.c.obj:
	cl -c -Zi -W2 -AM -Oait $*.c >e:$*.err

.obj.exe:
	echo $**, >link.lnk
	echo $*.exe, $*.map /NOI /NOE;>>link.lnk
	link @link.lnk


# The following rules can be used when debugging; it turns off optimization
# and links with CodeView enabled.
#.c.obj:
#	cl -c -Zi -W2 -AM $*.c >e:$*.err
#
#.obj.exe:
#	echo $**, >link.lnk
#	echo $*.exe, $*.map /NOI /NOE /CO;>>link.lnk
#	link @link.lnk

FSELECT.OBJ: FSELECT.C winmenu.h

HLBENCH.OBJ: HLBENCH.C

HLMENU.OBJ: HLMENU.C winmenu.h

HLWIN.OBJ: HLWIN.C winmenu.h hltimes.h hl.h

HLWINDOW.OBJ: HLWINDOW.C winmenu.h hltimes.h hl.h

HLANALYZ.OBJ: HLANALYZ.C winmenu.h hltimes.h hl.h

HLTIMES.OBJ: HLTIMES.C hltimes.h

HLTIMER.OBJ: HLTIMER.C hl.h

HLGRAFIT.OBJ: HLGRAFIT.C

HLGRSUBS.OBJ: HLGRSUBS.C

HLSRTSUB.OBJ: HLSRTSUB.C

HLDISK.OBJ: HLDISK.C hltimes.h hlstate.h hl.h

HLTEXT.OBJ: HLTEXT.C hltimes.h hl.h

HLFLOAT.OBJ: HLFLOAT.C hltimes.h hl.h

HLSORT.OBJ: HLSORT.C hltimes.h hl.h

HLDESC.OBJ: HLDESC.C winmenu.h hltimes.h

HLGRAPH.OBJ: HLGRAPH.C hltimes.h hl.h

HLSTART.OBJ: HLSTART.C

hlsort.exe : hlsort.obj hltimer.obj hltimes.obj

hldesc.exe : hldesc.obj hltimes.obj hlmenu.obj hlwin.obj

hlfloat.exe : hlfloat.obj hltimer.obj hlgrsubs.obj hltimes.obj

hltext.exe : hltext.obj hltimes.obj hltimer.obj

hldisk.exe : hldisk.obj hlsrtsub.obj hltimes.obj hltimer.obj

hlbench.exe : hlbench.obj hlmenu.obj hlwin.obj

hlwindow.exe : hlwindow.obj hlwin.obj hltimes.obj hltimer.obj

hlanalyz.exe : hlanalyz.obj hlwin.obj hlmenu.obj hltimes.obj\
	     hltimer.obj hlgrafit.obj hlgrsubs.obj fselect.obj

hlgraph.exe : hlgraph.obj hltimer.obj hltimes.obj hlgrsubs.obj

hlstart.exe : hlstart.obj hlgrsubs.obj

# The two routines below need a different amount of stack from the
# standard; hlsort needs less, because it's pushing the maximum heap
# space; hlanalyz needs more because it has a lot of local variables. 

ENDMAKE: hlsort.exe hlanalyz.exe
    exemod hlsort.exe /stack 300
    exemod hlanalyz.exe /stack 1000
