{
    VGADEMO -- VGA graphics demo.  Pixels, lines.
    line1 is the original Pascal line procedure.
    line2 is an optimized version with assembly language.
}

{$G+}
program vgademo;
uses crt;

procedure setmode(mode:integer); assembler;
asm
    mov ax,mode;
    xor ah,ah;
    int 10h;
end;

procedure cls; assembler;
asm
    mov ax,0A000h;      { ES = video memory }
    mov es,ax;

    xor di,di;          { Set up for clear }
    xor ax,ax;
    mov cx,8000h;

    rep stosw;          { Clear the screen }
end;

procedure putpixel(x, y, color:integer); assembler;
asm
    mov bx,x;           { BX = X, CX = Y }
    mov cx,y;
    add bh,cl;          { BX = offset }
    shl cx,6;
    add bx,cx;

    mov ax,0A000h;      { ES = video memory }
    mov es,ax;
    mov ax,color;       { AX = color }
    mov es:[bx],al;     { Plot pixel }
end;

function getpixel(x, y:integer):integer; assembler;
asm
    mov bx,x;           { BX = X, CX = Y }
    mov cx,y;
    add bh,cl;          { BX = offset }
    shl cx,6;
    add bx,cx;

    mov ax,0A000h;      { ES = video memory }
    mov es,ax;
    mov al,es:[bx];     { Read pixel }
    xor ah,ah;
end;

procedure line1(x1, y1, x2, y2, color:integer);
var
    d, x, y, sx, sy, dx, dy:integer;
begin
    {
        dx, dy = distance, d = deviation,
        sx, sy = sign of distance.
    }

    dx := x2 - x1; dy := y2 - y1;
    if dx > 0 then sx := 1 else sx := -1;
    if dy > 0 then sy := 1 else sy := -1;
    dx := abs(dx); dy := abs(dy);
    x := x1; y := y1;

    if dx > dy then begin
        d := (dy - dx) div 2;       { X is major axis }
        while x <> x2 do begin
            putpixel(x, y, color);  { Put pixel }
            if d >= 0 then begin    { Minor-axis change? }
                dec(d, dx);         { Decrease by 1 }
                inc(y, sy);
            end;
            inc(d, dy);             { Increase by dy/dx }
            inc(x, sx);
        end;
        putpixel(x, y, color);      { Put last pixel }
    end else begin
        d := (dx - dy) div 2;       { Y is major axis }
        while y <> y2 do begin
            putpixel(x, y, color);  { Put pixel }
            if d >= 0 then begin    { Minor-axis change? }
                dec(d, dy);         { Decrease by 1 }
                inc(x, sx);
            end;
            inc(d, dx);             { Increase by dx/dy }
            inc(y, sy);
        end;
        putpixel(x, y, color);      { Put last pixel }
    end;
end;

procedure line2(x1, y1, x2, y2, color:integer);
var
    d, x, y, sx, sy, dx, dy:integer;
begin
    {
        dx, dy = distance, d = deviation,
        sx, sy = sign of distance.
    }

    dx := x2 - x1; dy := y2 - y1;
    if dx > 0 then sx := 1 else sx := -1;
    if dy > 0 then sy := 1 else sy := -1;
    dx := abs(dx); dy := abs(dy);
    x := x1; y := y1;

    asm                             { ES = video memory }
        mov ax,0A000h;
        mov es,ax;
    end;

    if dx > dy then begin
        d := (dy - dx) div 2;       { X is major axis }
        while x <> x2 do begin
            asm
                mov bx,x; mov cx,y; { Plot the pixel }
                add bh,cl; shl cx,6;
                add bx,cx; mov ax,color;
                mov es:[bx],al;
            end;
            if d >= 0 then begin    { Minor-axis change? }
                dec(d, dx);         { Decrease by 1 }
                inc(y, sy);
            end;
            inc(d, dy);             { Increase by dy/dx }
            inc(x, sx);
        end;
        asm
            mov bx,x; mov cx,y;     { Plot the last pixel }
            add bh,cl; shl cx,6;
            add bx,cx; mov ax,color;
            mov es:[bx],al;
        end;
    end else begin
        d := (dx - dy) div 2;       { Y is major axis }
        while y <> y2 do begin
            asm
                mov bx,x; mov cx,y; { Plot the pixel }
                add bh,cl; shl cx,6;
                add bx,cx; mov ax,color;
                mov es:[bx],al;
            end;
            if d >= 0 then begin    { Minor-axis change? }
                dec(d, dy);         { Decrease by 1 }
                inc(x, sx);
            end;
            inc(d, dx);             { Increase by dx/dy }
            inc(y, sy);
        end;
        asm
            mov bx,x; mov cx,y;     { Plot the last pixel }
            add bh,cl; shl cx,6;
            add bx,cx; mov ax,color;
            mov es:[bx],al;
        end;
    end;
end;

var
    i:integer;
begin
    setmode($13);

    while not keypressed do begin
        for i := 1 to 200 do
            putpixel(random(320), random(200), random(256));
    end;

    while keypressed do readkey;
    cls;

    while not keypressed do begin
        for i := 1 to 20 do
            line1(random(320), random(200),
                  random(320), random(200),
                  random(256));
    end;

    while keypressed do readkey;
    cls;

    while not keypressed do begin
        for i := 1 to 20 do
            line2(random(320), random(200),
                  random(320), random(200),
                  random(256));
    end;

    while keypressed do readkey;
    cls;

    setmode($03);
end.

