/*
    VGADEMO -- VGA graphics demo.  Pixels, lines.
    line1() is the original 'C' line function.
    line2() is an optimized version with assembly language.
*/

#include <stdlib.h>
#include <conio.h>

void setmode(int mode);
void cls(void);
void putpixel(int x, int y, int color);
int getpixel(int x, int y);
void line1(int x1, int x2, int y1, int y2, int color);
void line2(int x1, int x2, int y1, int y2, int color);

main()
{
    int i;

    setmode(0x13);

    while(!kbhit())
    {
        for(i = 0; i < 200; i++)
            putpixel(random(320), random(200), random(256));
    }

    while(kbhit()) getch();
    cls();

    while(!kbhit())
    {
        for(i = 0; i < 20; i++)
            line1(random(320), random(200),
                  random(320), random(200),
                  random(256));
    }

    while(kbhit()) getch();
    cls();

    while(!kbhit())
    {
        for(i = 0; i < 20; i++)
            line2(random(320), random(200),
                  random(320), random(200),
                  random(256));
    }

    while(kbhit()) getch();
    cls();

    setmode(0x03);
    return 0;
}

void setmode(int mode)
{
    asm {
        mov ax,mode;
        xor ah,ah;
        int 10h;
    }
}

void cls(void)
{
    asm {

        mov ax,0A000h;      /* ES = video memory */
        mov es,ax;
    
        xor di,di;          /* Set up for clear */
        xor ax,ax;
        mov cx,8000h;
    
        rep stosw;          /* Clear the screen */
    }
}

void putpixel(int x, int y, int color)
{
    asm {
        mov bx,x;           /* BX = X, CX = Y */
        mov cx,y;
        add bh,cl;          /* BX = offset */
        shl cx,6;
        add bx,cx;
    
        mov ax,0A000h;      /* ES = video memory */
        mov es,ax;
        mov ax,color;       /* AX = color */
        mov es:[bx],al;     /* Plot pixel */
    }
}

int getpixel(int x, int y)
{
    asm {
        mov bx,x;           /* BX = X, CX = Y */
        mov cx,y;
        add bh,cl;          /* BX = offset */
        shl cx,6;
        add bx,cx;
    
        mov ax,0A000h;      /* ES = video memory */
        mov es,ax;
        mov al,es:[bx];     /* Read pixel */
    }

    return _AL;
}

void line1(int x1, int y1, int x2, int y2, int color)
{
    int d, x, y, sx, sy, dx, dy;

    /*
        dx, dy = distance, d = deviation,
        sx, sy = sign of distance.
    */

    dx = x2 - x1; dy = y2 - y1;
    if(dx > 0) sx = 1; else sx = -1;
    if(dy > 0) sy = 1; else sy = -1;
    dx = abs(dx); dy = abs(dy);
    x = x1; y = y1;

    if(dx > dy) {
        d = (dy - dx) / 2;          /* X is major dxis */
        while(x != x2) {
            putpixel(x, y, color);  /* Put pixel */
            if(d >= 0) {            /* Minor-dxis change? */
                d -= dx;            /* Decrease by 1 */
                y += sy;
            }
            d += dy;                /* Increase by dy/dx */
            x += sx;
        }
        putpixel(x, y, color);      /* Put last pixel */
    } else {
        d = (dx - dy) / 2;          /* Y is major dxis */
        while(y != y2) {
            putpixel(x, y, color);  /* Put pixel */
            if(d >= 0) {            /* Minor-dxis change? */
                d -= dy;            /* Decrease by 1 */
                x += sx;
            }
            d += dx;                /* Increase by dx/dy */
            y += sy;
        }
        putpixel(x, y, color);      /* Put last pixel */
    }
}

#define PUT_PIXEL(x, y, c) \
    asm { mov bx,x; mov cx,y; add bh,cl; shl cx,6; \
          add bx,cx; mov ax,color; mov es:[bx],al; }

void line2(int x1, int y1, int x2, int y2, int color)
{
    int d, x, y, sx, sy, dx, dy;

    /*
        dx, dy = distance, d = deviation,
        sx, sy = sign of distance.
    */

    dx = x2 - x1; dy = y2 - y1;
    if(dx > 0) sx = 1; else sx = -1;
    if(dy > 0) sy = 1; else sy = -1;
    dx = abs(dx); dy = abs(dy);
    x = x1; y = y1;

    asm mov ax,0A000h;              /* ES = video memory */
    asm mov es,ax;

    if(dx > dy) {
        d = (dy - dx) / 2;          /* X is major dxis */
        while(x != x2) {
            PUT_PIXEL(x, y, color); /* Put pixel */
            if(d >= 0) {            /* Minor-dxis change? */
                d -= dx;            /* Decrease by 1 */
                y += sy;
            }
            d += dy;                /* Increase by dy/dx */
            x += sx;
        }
        PUT_PIXEL(x, y, color);     /* Put last pixel */
    } else {
        d = (dx - dy) / 2;          /* Y is major dxis */
        while(y != y2) {
            PUT_PIXEL(x, y, color); /* Put pixel */
            if(d >= 0) {            /* Minor-dxis change? */
                d -= dy;            /* Decrease by 1 */
                x += sx;
            }
            d += dx;                /* Increase by dx/dy */
            y += sy;
        }
        PUT_PIXEL(x, y, color);     /* Put last pixel */
    }
}

